/*
 * File: fconv.c
 *  Contents: abs, cset, integer, numeric, proc, real, string
 */

#include "../h/rt.h"

/*
 * abs(x) - absolute value of x.
 */
FncDcl(abs,1)
   {
   union numeric result;

   switch (cvnum(&Arg1, &result)) {
      /*
       * If Arg1 is convertible to a numeric, turn Arg0 into
       *  a descriptor for the appropriate type and value.  If the
       *  conversion fails, produce an error.  This code assumes that
       *  n = -n is always valid, which is not necessarily correct.
       */
      case T_Integer:
         if (result.integer < 0L)
            result.integer = -result.integer;
         MkIntT(result.integer, &Arg0);
         break;

      case T_Real:
         if (result.real < 0.0)
            result.real = -result.real;
         if (mkreal(result.real, &Arg0) == Error) 
            RunErr(0, NULL);
         break;

     case T_Bignum:
	 mkbignum (result.bptr, &Arg1);
	 cpbignum (&Arg1, &Arg0);
	 BlkLoc(Arg0)->bignumblk.sign = 0;
	 break;

      default:
         RunErr(102, &Arg1);
      }
   Return;
   }


/*
 * cset(x) - convert x to cset.
 */

FncDcl(cset,1)
   {
   register int i;
   register struct b_cset *bp;
   int *cs, csbuf[CsetSize];
   extern struct b_cset *alccset();

   if (blkreq((word)sizeof(struct b_cset)) == Error) 
      RunErr(0, NULL);

   if (Arg1.dword == D_Cset)
      /*
       * Arg1 already a cset, just return it.
       */
      Arg0 = Arg1;
   else if (cvcset(&Arg1, &cs, csbuf) != CvtFail) {
      /*
       * Arg1 was convertible to cset and the result resides in csbuf.
       *  Allocate *  a cset, make Arg0 a descriptor for it and copy the
       *  bits from csbuf into it.
       */
      Arg0.dword = D_Cset;
      bp = alccset();
      BlkLoc(Arg0) =  (union block *) bp;
      for (i = 0; i < CsetSize; i++)
         bp->bits[i] = cs[i];
      }
   else			/* Not a cset nor convertible to one. */
      Fail;
   Return;
   }


/*
 * integer(x) - convert x to integer.
 */

FncDcl(integer,1)
   {
   union numeric l;

   switch (cvnum(&Arg1, &l)) {

      case T_Integer:
         MkIntT(l.integer, &Arg0);
         break;

     case T_Real:
	 realtobig (l.real, &Arg0);
	 break;

     case T_Bignum:
	 mkbignum (l.bptr, &Arg0);
	 break;

      default:
         Fail;
      }
   Return;
   }

/*
 * numeric(x) - convert x to numeric type.
 */
FncDcl(numeric,1)
   {
   union numeric n1;

   switch (cvnum(&Arg1, &n1)) {

      case T_Integer:
         MkIntT(n1.integer, &Arg0);
         break;

      case T_Real:
         if (mkreal(n1.real, &Arg0) == Error) 
            RunErr(0, NULL);
         break;

     case T_Bignum:
	 mkbignum (n1.bptr, &Arg0);
	 break;

      default:
         Fail;
      }
   Return;
   }


/*
 * proc(x,i) - convert x to a procedure if possible; use i to
 *  resolve ambiguous string names.
 */
FncDcl(proc,2)
   {
   char sbuf[MaxCvtLen];
   
   /*
    * If Arg1 is already a proc, just return it in Arg0.
    */
   Arg0 = Arg1;
   if (Arg0.dword == D_Proc) {
      Return;
      }
   if (cvstr(&Arg0, sbuf) == CvtFail)
      Fail;
   /*
    * Arg2 defaults to 1.
    */
   if (defshort(&Arg2, 1) == Error) 
      RunErr(0, NULL);

   /*
    * Attempt to convert Arg0 to a procedure descriptor using args to
    *  discriminate between procedures with the same names.  Fail if
    *  the conversion isn't successful.
    */
   if (strprc(&Arg0,IntVal(Arg2)) == CvtFail)
      Fail;
   Return;
   }


/*
 * real(x) - convert x to real.
 */

FncDcl(real,1)
   {
   double r;

   /*
    * If Arg1 is already a real, just return it.  Otherwise convert it and
    *  return it, failing if the conversion is unsuccessful.
    */
   if (Arg1.dword == D_Real)
      Arg0 = Arg1;
   else if (cvreal(&Arg1, &r) == T_Real) {
      if (mkreal(r, &Arg0) == Error) 
         RunErr(0, NULL);
      }
   else
      Fail;
   Return;
   }

/*
 * string(x) - convert x to string.
 */

/* >string */
FncDcl(string,1)
   {
   char sbuf[MaxCvtLen];
   extern char *alcstr();

   Arg0 = Arg1;
   switch (cvstr(&Arg0, sbuf)) {

      /*
       * If Arg1 is not a string, allocate it and return it; if it is a
       *  string, just return it; fail otherwise.
       */
      case Cvt:
	 /*
          * Allocate converted string
          */
         if (strreq(StrLen(Arg0)) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(StrLoc(Arg0), StrLen(Arg0));

      case NoCvt:
         Return;

      default:
         Fail;
      }
   }
/* <string */
