/*
 * File: fmisc.c
 *  Contents: char, collect, copy, display, iand, icom, image, ior, ishift,
 *   ixor, ord, runerr, seq, sort, type, errorclear
 */

#include "../h/rt.h"

/*
 * char(i) - produce a string consisting of character i.
 */
FncDcl(char,1)
   {
   word i;
   char c;
   char *alcstr();

   if (cvint(&Arg1, &i) == CvtFail)
      RunErr(101, &Arg1);
   if (i < 0 || i >= 256)
      RunErr(205, &Arg1);
   c = i;
   StrLen(Arg0) = 1;
   StrLoc(Arg0) = alcstr(&c, (word)1);
   Return;
   }

/*
 * collect() - explicit call to garbage collector.
 */

FncDcl(collect,0)
   {
   collect(0);
   Arg0 = nulldesc;
   Return;
   }

/*
 * copy(x) - make a copy of object x.
 */

FncDcl(copy,1)
   {
   register int i;
   struct descrip  *d1, *d2;
   union block *bp, *ep, **tp;
   extern struct b_table *alctable();
   extern struct b_telem *alctelem();
   extern struct b_set *alcset();
   extern struct b_selem *alcselem();
   extern struct b_record *alcrecd();

   if (Qual(Arg1))
      /*
       * Arg1 is a string; just copy its descriptor
       *  into Arg0.
       */
      Arg0 = Arg1;
   else {
      switch (Type(Arg1)) {
         case T_Null:
         case T_Integer:
         case T_Bignum:
         case T_Real:
         case T_File:
         case T_Cset:
         case T_Proc:
         case T_Coexpr:
         case T_External:
            /*
             * Copy the null value, integers, long integers, reals, files,
             *	csets, procedures, and such by copying the descriptor.
             *	Note that for integers, this results in the assignment
             *	of a value, for the other types, a pointer is directed to
             *	a data block.
             */
            Arg0 = Arg1;
            break;

         case T_List:
            /*
             * Pass the buck to cplist to copy a list.
             */
            if (cplist(&Arg1, &Arg0, (word)1, BlkLoc(Arg1)->list.size + 1) ==
                 Error) 
               RunErr(0, NULL);
            break;

         case T_Table:
            /*
             * Allocate space for table and elements and copy old table
             *	block into new.
             */
            if (blkreq((sizeof(struct b_table)) +
                  (sizeof(struct b_telem)) * BlkLoc(Arg1)->table.size) ==
                  Error) 
               RunErr(0, NULL);
            bp = (union block *) alctable(&nulldesc);
            bp->table = BlkLoc(Arg1)->table;
            /*
             * Work down the chain of table element blocks in each bucket
             *	and create identical chains in new table.
             */
            for (i = 0; i < TSlots; i++) {
               tp = &(BlkLoc(bp->table.buckets[i]));
               for (ep = *tp; ep != NULL; ep = *tp) {
                  *tp = (union block *) alctelem();
                  (*tp)->telem = ep->telem;
                  tp = &(BlkLoc((*tp)->telem.clink));
                  }
               }
            /*
             * Return the copied table.
             */
            Arg0.dword = D_Table;
            BlkLoc(Arg0) = bp;
            break;

         case T_Set:
            /*
             * Allocate space for set and elements and copy old set
             *	block into new.
             */
            if (blkreq((sizeof(struct b_set)) +
                 (sizeof(struct b_selem)) * BlkLoc(Arg1)->set.size) == Error) 
               RunErr(0, NULL);
            bp = (union block *) alcset();
            bp->set = BlkLoc(Arg1)->set;
            /*
             * Work down the chain of set elements in each bucket
             *	and create identical chains in new set.
             */
            for (i = 0; i < SSlots; i++) {
               tp = &(BlkLoc(bp->set.sbucks[i]));
               for (ep = *tp; ep != NULL; ep = *tp) {
                  *tp = (union block *) alcselem(&nulldesc,(word)0);
                  (*tp)->selem = ep->selem;
                  tp = &(BlkLoc((*tp)->selem.clink));
                  }
               }
            /*
             * Return the copied set.
             */
            Arg0.dword = D_Set;
            BlkLoc(Arg0) = bp;
            break;

         case T_Record:
            /*
             * Allocate space for the new record and copy the old
             *	one into it.
             */
            if (blkreq(BlkLoc(Arg1)->record.blksize) == Error) 
               RunErr(0, NULL);
            i = BlkLoc(BlkLoc(Arg1)->record.recdesc)->proc.nfields;
            bp = (union block *)alcrecd(i,&BlkLoc(Arg1)->record.recdesc);
            bp->record = BlkLoc(Arg1)->record;
            d1 = bp->record.fields;
            d2 = BlkLoc(Arg1)->record.fields;
            while (i--)
               *d1++ = *d2++;
            /*
             * Return the copied record
             */
            Arg0.dword = D_Record;
            BlkLoc(Arg0) = bp;
            break;

         default:
            syserr("copy: illegal datatype.");
         }
      }
   Return;
   }

/*
 * display(i,f) - display local variables of i most recent
 * procedure activations, plus global variables.
 * Output to file f (default &errout).
 */

FncDcl(display,2)
   {
   long l;
   int count;
   FILE *f;

   /*
    * Arg1 defaults to &level; Arg2 defaults to &errout.
    */
   if ((defint(&Arg1, &l, (word)k_level) == Error) ||
       (deffile(&Arg2, &errout) == Error)) 
      RunErr(0, NULL);

   /*
    * Produce error if file cannot be written.
    */
   f = BlkLoc(Arg2)->file.fd;
   if ((BlkLoc(Arg2)->file.status & Fs_Write) == 0) 
      RunErr(213, &Arg2);

   /*
    * Produce error if Arg1 is negative; constrain Arg1 to be >= &level.
    */
   if (l < 0) 
      RunErr(205, &Arg1)
   else if (l > k_level)
      count = k_level;
   else
      count = l;

   xdisp(count,f);
   Arg0 = nulldesc;		/* Return null value. */
   Return;
   }

/*
 * iand(i,j) - produce bitwise AND of i and j.
 */
FncDcl(iand,2)
   {
   union numeric i, j;
   int t1, t2;

   if ((t1 = cvnum(&Arg1, &i)) == CvtFail)
      RunErr(101, &Arg1);
   if ((t2 = cvnum(&Arg2, &j)) == CvtFail)
      RunErr(101, &Arg2);

   if (t1 == T_Real) {
       realtobig (i.real, &Arg1); t1 = Type (Arg1);}
   if (t2 == T_Real) {
       realtobig (j.real, &Arg2); t2 = Type (Arg2);}

   if (t1 == T_Integer && t2 == T_Integer) {
       MkIntT(i.integer & j.integer, &Arg0);}
   else {
       if (t1 == T_Integer) {
	   bigand (itobigl (i.integer), &Arg2, &Arg0);}
       else if (t2 == T_Integer) {
	   bigand (itobigl (j.integer), &Arg1, &Arg0);}
       else {
	   bigand (&Arg1, &Arg2, &Arg0);}}
       
   Return;
   }

/*
 * icom(i) - produce bitwise complement (one's complement) of i.
 */
FncDcl(icom,1)
   {
   union numeric i;
   int t1;

   if ((t1 = cvnum(&Arg1, &i)) == CvtFail)
      RunErr(101, &Arg1);

   if (t1 == T_Real) {
       realtobig (i.real, &Arg1); t1 = Type (Arg1);}
   if (t1 == T_Integer) {
       MkIntT(~i.integer, &Arg0);}
   else {
       bigsub (itobigl (-1), &Arg1, &Arg0);}

   Return;
   }

/*
 * image(x) - return string image of object x.	Nothing fancy here,
 *  just plug and chug on a case-wise basis.
 */

FncDcl(image,1)
   {
   register word len, outlen, rnlen;
   register char *s;
   register union block *bp;
   char *type;
   extern char *alcstr();
   word prescan();
   char sbuf[MaxCvtLen];
   FILE *fd;

   if (Qual(Arg1)) {
      /*
       * Get some string space.  The magic 2 is for the double quote at each
       *  end of the resulting string.
       */
      if (strreq(prescan(&Arg1) + 2) == Error) 
         RunErr(0, NULL);
      len = StrLen(Arg1);
      s = StrLoc(Arg1);
      outlen = 2;

      /*
       * Form the image by putting a quote in the string space, calling
       *  doimage with each character in the string, and then putting
       *  a quote at then end.	Note that doimage directly writes into the
       *  string space.  (Hence the indentation.)  This techinique is used
       *  several times in this routine.
       */
      StrLoc(Arg0) = alcstr("\"", (word)(1));
      while (len-- > 0)
         outlen += doimage(*s++, '"');
      alcstr("\"", (word)(1));
      StrLen(Arg0) = outlen;
      Return;
      }

   switch (Type(Arg1)) {

      case T_Null:
         StrLoc(Arg0) = "&null";
         StrLen(Arg0) = 5;
         Return;

      case T_Integer:
      case T_Bignum:
      case T_Real:
         /*
          * Form a string representing the number and allocate it.
          */
         cvstr(&Arg1, sbuf);
         len = StrLen(Arg1);
         if (strreq(len) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(StrLoc(Arg1), len);
         StrLen(Arg0) = len;
         Return;

      case T_Cset:

         /*
          * Check for distinguished csets by looking at the address of
          *  of the object to image.  If one is found, make a string
          *  naming it and return.
          */
         if (BlkLoc(Arg1) == ((union block *)&k_ascii)) {
            StrLoc(Arg0) = "&ascii";
            StrLen(Arg0) = 6;
            Return;
            }
         else if (BlkLoc(Arg1) == ((union block *)&k_cset)) {
            StrLoc(Arg0) = "&cset";
            StrLen(Arg0) = 5;
            Return;
            }
         else if (BlkLoc(Arg1) == ((union block *)&k_digits)) {
            StrLoc(Arg0) = "&digits";
            StrLen(Arg0) = 7;
            Return;
            }
         else if (BlkLoc(Arg1) == ((union block *)&k_lcase)) {
            StrLoc(Arg0) = "&lcase";
            StrLen(Arg0) = 6;
            Return;
            }
         else if (BlkLoc(Arg1) == ((union block *)&k_ucase)) {
            StrLoc(Arg0) = "&ucase";
            StrLen(Arg0) = 6;
            Return;
            }
         /*
          * Convert the cset to a string and proceed as is done for
          *  string images but use a ' rather than " to bound the
          *  result string.
          */
         cvstr(&Arg1, sbuf);
         if (strreq(prescan(&Arg1) + 2) == Error) 
            RunErr(0, NULL);
         len = StrLen(Arg1);
         s = StrLoc(Arg1);
         outlen = 2;
         StrLoc(Arg0) = alcstr("'", (word)(1));
         while (len-- > 0)
            outlen += doimage(*s++, '\'');
         alcstr("'", (word)(1));
         StrLen(Arg0) = outlen;
         Return;

      case T_File:
         /*
          * Check for distinguished files by looking at the address of
          *  of the object to image.  If one is found, make a string
          *  naming it and return.
          */
         if ((fd = BlkLoc(Arg1)->file.fd) == stdin) {
            StrLen(Arg0) = 6;
            StrLoc(Arg0) = "&input";
            }
         else if (fd == stdout) {
            StrLen(Arg0) = 7;
            StrLoc(Arg0) = "&output";
            }
         else if (fd == stderr) {
            StrLen(Arg0) = 7;
            StrLoc(Arg0) = "&errout";
            }
         else {
            /*
             * The file is not a standard one; form a string of the form
             *	file(nm) where nm is the argument originally given to
             *	open.
             */
            if (strreq(prescan(&BlkLoc(Arg1)->file.fname)+6) == Error) 
               RunErr(0, NULL);
            len = StrLen(BlkLoc(Arg1)->file.fname);
            s = StrLoc(BlkLoc(Arg1)->file.fname);
            outlen = 6;
            StrLoc(Arg0) = alcstr("file(", (word)(5));
            while (len-- > 0)
               outlen += doimage(*s++, '\0');
            alcstr(")", (word)(1));
            StrLen(Arg0) = outlen;
            }
         Return;

      case T_Proc:
         /*
          * Produce one of:
          *  "procedure name"
          *  "function name"
          *  "record constructor name"
          *
          * Note that the number of dynamic locals is used to determine
          *  what type of "procedure" is at hand.
          */
         len = StrLen(BlkLoc(Arg1)->proc.pname);
         s = StrLoc(BlkLoc(Arg1)->proc.pname);
         switch ((int)BlkLoc(Arg1)->proc.ndynam) {
            default:  type = "procedure "; break;
            case -1:  type = "function "; break;
            case -2:  type = "record constructor "; break;
            }
         outlen = strlen(type);
         if (strreq(len + outlen) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(type, outlen);
         alcstr(s, len);
         StrLen(Arg0) = len + outlen;
         Return;

      case T_List:
         /*
          * Produce:
          *  "list(n)"
          * where n is the current size of the list.
          */
         bp = BlkLoc(Arg1);
         sprintf(sbuf, "list(%ld)", (long)bp->list.size);
         len = strlen(sbuf);
         if (strreq(len) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(sbuf, len);
         StrLen(Arg0) = len;
         Return;

      case T_Table:
         /*
          * Produce:
          *  "table(n)"
          * where n is the size of the table.
          */
         bp = BlkLoc(Arg1);
         sprintf(sbuf, "table(%ld)", (long)bp->table.size);
         len = strlen(sbuf);
         if (strreq(len) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(sbuf, len);
         StrLen(Arg0) = len;
         Return;

      case T_Set:
         /*
          * Produce "set(n)" where n is size of the set.
          */
         bp = BlkLoc(Arg1);
         sprintf(sbuf, "set(%ld)", (long)bp->set.size);
         len = strlen(sbuf);
         if (strreq(len) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(sbuf,len);
         StrLen(Arg0) = len;
         Return;

      case T_Record:
         /*
          * Produce:
          *  "record name(n)"
          * where n is the number of fields.
          */
         bp = BlkLoc(Arg1);
         rnlen = StrLen(BlkLoc(bp->record.recdesc)->proc.recname);
         if (strreq(15 + rnlen) == Error)    /* 15 = *"record " + *"(nnnnnn)"*/
            RunErr(0, NULL);
         bp = BlkLoc(Arg1);
         sprintf(sbuf, "(%ld)",
            (long)BlkLoc(bp->record.recdesc)->proc.nfields);
         len = strlen(sbuf);
         StrLoc(Arg0) = alcstr("record ", (word)(7));
            alcstr(StrLoc(BlkLoc(bp->record.recdesc)->proc.recname),rnlen);
            alcstr(sbuf, len);
         StrLen(Arg0) = 7 + len + rnlen;
         Return;

      case T_Coexpr:
         /*
          * Produce:
          *  "co-expression #m (n)"
          *  where m is the number of the co-expressions and n is the
          *  number of results that have been produced.
          */
#ifdef NoCoexpr
         if (strreq((uword)18) == Error)
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr("co-expression #1 (0)", (word)(21));
         StrLen(Arg0) = 21;
#else					/* NoCoexpr */
         if (strreq((uword)30) == Error) 
            RunErr(0, NULL);
         sprintf(sbuf, " #%ld (%ld)", (long)BlkLoc(Arg1)->coexpr.id,
            (long)BlkLoc(Arg1)->coexpr.size);
         len = strlen(sbuf);
         StrLoc(Arg0) = alcstr("co-expression", (word)(13));
         alcstr(sbuf, len);
         StrLen(Arg0) = 13 + len;
#endif					/* NoCoexpr */
         Return;

      case T_External:
         /*
          * For now, just produce "external(n)". 
          */
         sprintf(sbuf, "external(%ld)", (long)BlkLoc(Arg1)->externl.blksize);
         len = strlen(sbuf);
         if (strreq(len) == Error) 
            RunErr(0, NULL);
         StrLoc(Arg0) = alcstr(sbuf, len);
         StrLen(Arg0) = len;
         Return;

      default:
         syserr("image: unknown type.");
      }
   Return;
   }

/*
 * doimage(c,q) - allocate character c in string space, with escape
 *  conventions if c is unprintable, '\', or equal to q.
 *  Returns number of characters allocated.
 */

doimage(c, q)
int c, q;
   {
   static char cbuf[] = "\\\0\0\0";
   extern char *alcstr();

   if (c >= ' ' && c < '\177') {
      /*
       * c is printable, but special case ", ', and \.
       */
      switch (c) {
         case '"':
            if (c != q) goto def;
            alcstr("\\\"", (word)(2));
            return 2;
         case '\'':
            if (c != q) goto def;
            alcstr("\\'", (word)(2));
            return 2;
         case '\\':
            alcstr("\\\\", (word)(2));
            return 2;
         default:
         def:
            cbuf[0] = c;
            cbuf[1] = '\0';
            alcstr(cbuf, (word)(1));
            return 1;
         }
      }

   /*
    * c is some sort of unprintable character.	If it is one of the common
    *  ones, produce a special representation for it, otherwise, produce
    *  its octal value.
    */
   switch (c) {
      case '\b':			/*	   backspace	*/
         alcstr("\\b", (word)(2));
         return 2;
      case '\177':			/*      delete	  */
         alcstr("\\d", (word)(2));
         return 2;
      case '\33':			/*	    escape	 */
         alcstr("\\e", (word)(2));
         return 2;
      case '\f':			/*	   form feed	*/
         alcstr("\\f", (word)(2));
         return 2;
      case '\n':			/*	   new line	*/
         alcstr("\\n", (word)(2));
         return 2;
/*
 * The following code is operating-system dependent. Handle \r if available.
 */

#if PORT
      case '\r':			/*	   return	*/
         alcstr("\\r", (word)(2));
         return 2;
#endif					/* PORT */

#if AMIGA
#endif					/* AMIGA */

#if ATARI_ST || MSDOS || UNIX || VMS
      case '\r':			/*	   return	*/
         alcstr("\\r", (word)(2));
         return 2;
#endif					/* ATARI || MSDOS || UNIX || VMS */

#if MACINTOSH
#if MPW
   /* not available */
#endif					/* MPW */
#endif					/* MACINTOSH */

#if VM || MVS
#endif					/* VM || MVS */

/*
 * End of operating-system specific code.
 */
      case '\t':			/*	   horizontal tab     */
         alcstr("\\t", (word)(2));
         return 2;
      case '\13':			/*	    vertical tab     */
         alcstr("\\v", (word)(2));
         return 2;
      default:				/*	  octal constant  */
         cbuf[0] = '\\';
         cbuf[1] = ((c&0300) >> 6) + '0';
         cbuf[2] = ((c&070) >> 3) + '0';
         cbuf[3] = (c&07) + '0';
         alcstr(cbuf, (word)(4));
         return 4;
      }
   }

/*
 * prescan(d) - return upper bound on length of expanded string.  Note
 *  that the only time that prescan is wrong is when the string contains
 *  one of the "special" unprintable characters, e.g. tab.
 */
word prescan(d)
struct descrip *d;
   {
   register word slen, len;
   register char *s, c;

   s = StrLoc(*d);
   len = 0;
   for (slen = StrLen(*d); slen > 0; slen--)
      if ((c = (*s++)) < ' ' || c >= 0177)
         len += 4;
      else if (c == '"' || c == '\\' || c == '\'')
         len += 2;
      else
         len++;

   return len;
   }

/*
 * ior(i,j) - produce bitwise inclusive OR of i and j.
 */
FncDcl(ior,2)
{
   union numeric i, j;
   int t1, t2;

   if ((t1 = cvnum(&Arg1, &i)) == CvtFail)
      RunErr(101, &Arg1);
   if ((t2 = cvnum(&Arg2, &j)) == CvtFail)
      RunErr(101, &Arg2);

   if (t1 == T_Real) {
       realtobig (i.real, &Arg1); t1 = Type (Arg1);}
   if (t2 == T_Real) {
       realtobig (j.real, &Arg2); t2 = Type (Arg2);}

   if (t1 == T_Integer && t2 == T_Integer) {
       MkIntT(i.integer | j.integer, &Arg0);}
   else {
       if (t1 == T_Integer) {
	   bigor (itobigl (i.integer), &Arg2, &Arg0);}
       else if (t2 == T_Integer) {
	   bigor (itobigl (j.integer), &Arg1, &Arg0);}
       else {
	   bigor (&Arg1, &Arg2, &Arg0);}}
       
   Return;
   }

/*
 * ishift(i,j) - produce i shifted j bit positions (left if j<0, right if j>0).
 */
FncDcl(ishift,2)
   {
   union numeric i;
   word j;
   int t1;

   if ((t1 = cvnum(&Arg1, &i)) == CvtFail)
      RunErr(101, &Arg1);
   if (cvint(&Arg2, &j) == CvtFail)
      RunErr(101, &Arg2);

   /*
    *  CHANGE: ishft is now signed, as this is the only possible
    *  way to make it sensibly apply to bignums.
    */

   if (t1 == T_Real) {
       realtobig (i.real, &Arg1); t1 = Type (Arg1);}

   if (t1 == T_Bignum) {
       bigshifti (&Arg1, j, &Arg0);}
   else if (j > 0) {
       bigshifti (itobigl (i.integer), j, &Arg0);}
   else {
       if (i.integer >= 0) {
	   MkIntT (i.integer >> -j, &Arg0);}
       else {
	   MkIntT ((i.integer >> -j) | (-1 << (WordBits + j)), &Arg0);}}

   Return;
   }

/*
 * ixor(i,j) - produce bitwise exclusive OR of i and j.
 */
FncDcl(ixor,2)
{
   union numeric i, j;
   int t1, t2;

   if ((t1 = cvnum(&Arg1, &i)) == CvtFail)
      RunErr(101, &Arg1);
   if ((t2 = cvnum(&Arg2, &j)) == CvtFail)
      RunErr(101, &Arg2);

   if (t1 == T_Real) {
       realtobig (i.real, &Arg1); t1 = Type (Arg1);}
   if (t2 == T_Real) {
       realtobig (j.real, &Arg2); t2 = Type (Arg2);}

   if (t1 == T_Integer && t2 == T_Integer) {
       MkIntT(i.integer ^ j.integer, &Arg0);}
   else {
       if (t1 == T_Integer) {
	   bigxor (itobigl (i.integer), &Arg2, &Arg0);}
       else if (t2 == T_Integer) {
	   bigxor (itobigl (j.integer), &Arg1, &Arg0);}
       else {
	   bigxor (&Arg1, &Arg2, &Arg0);}}
       
   Return;
   }

/*
 * ord(s) - produce integer ordinal (value) of single chracter.
 */
FncDcl(ord,1)
   {
   char sbuf[MaxCvtLen];

   if (cvstr(&Arg1, sbuf) == CvtFail)
      RunErr(103, &Arg1);
   if (StrLen(Arg1) != 1)
      RunErr(205, &Arg1);
   MkIntT(*StrLoc(Arg1) & 0xFF, &Arg0);
   Return;
   }

/*
 * runerr(i,x) - produce runtime error i with value x.
 */

FncDclV(runerr)
   {
   long l;

   if (nargs < 1)
      RunErr(-101, NULL);

   switch (cvint(&Arg(1), &l)) {
       case T_Integer:
           if (l <= 0)
              RunErr(205, &Arg(1));
	   break;

       default:
          RunErr(101, &Arg(1));
       }

   if (nargs == 1) {
      RunErr((int)(-l), NULL);
      }
   else {
      RunErr((int)l, &Arg(2));
      }
      
   }

/*
 * seq(e1,e2) - generate e1, e1+e2, e1+e2+e2, ... .
 */

FncDcl(seq,2)
   {
   long from, by;

   /*
    * Default Arg1 and Arg2 to 1.
    */
   if ((defint(&Arg1, &from, (word)1) == Error) ||
       (defint(&Arg2, &by, (word)1) == Error)) 
      RunErr(0, NULL);
   
   /*
    * Produce error if Arg2 is 0, i.e., an infinite sequence of Arg2s.
    */
   if (by == 0) 
      RunErr(211, &Arg2);

   /*
    * Suspend sequence, stopping when largest or smallest integer
    *  is reached.
    */
   while ((from <= MaxLong && by > 0) || (from >= MinLong && by < 0)) {
      MkIntT(from, &Arg0);
      Suspend;
      from += by;
      }
   Fail;
   }

struct dpair {
   struct descrip dr;
   struct descrip dv;
   };

/*
 * sort(l) - sort list l.
 * sort(S) - sort set S.
 * sort(t,i) - sort table.
 */

FncDcl(sort,2)
   {
   register struct descrip *d1;
   register word size;
   register int i;
   word nslots;
   struct b_list *lp, *tp;
   union block *bp, *ep;
   extern struct b_list *alclist();
   extern struct b_lelem *alclstb();
   extern anycmp(), trefcmp(), tvalcmp(), trcmp3(), tvcmp4();

   if (Arg1.dword == D_List) {
      /*
       * Sort the list by copying it into a new list and then using
       *  qsort to sort the descriptors.  (That was easy!)
       */
      size = BlkLoc(Arg1)->list.size;
      if (cplist(&Arg1, &Arg0, (word)1, size + 1) == Error) 
         RunErr(0, NULL);
      qsort((char *)BlkLoc(BlkLoc(Arg0)->list.listhead)->lelem.lslots,
         (int)size, sizeof(struct descrip), anycmp);
      }
   else if (Arg1.dword == D_Set) {
      /*
       * Create a list the size of the set (or at least 
       *  MinListSlots), copy each element into the list, and
       *  then sort the list using qsort as in list sorting
       *  and return the sorted list.
       */
   nslots = size = BlkLoc(Arg1)->set.size;
   if(nslots < MinListSlots)
      nslots = MinListSlots;

   if (blkreq(sizeof(struct b_list) + sizeof(struct b_lelem) +
      nslots * sizeof(struct descrip)) == Error) 
      RunErr(0, NULL);

   bp = BlkLoc(Arg1);
   lp = alclist(size);
   lp->listhead.dword = lp->listtail.dword = D_Lelem;
      BlkLoc(lp->listtail) = (union block *)alclstb(nslots, (word)0, size);
   BlkLoc(lp->listhead) = BlkLoc(lp->listtail);
   if (size > 0) {  /* only need to sort non-empty sets */
      d1 = BlkLoc(lp->listhead)->lelem.lslots;
      for(i = 0; i < SSlots; i++) {
      ep = BlkLoc(bp->set.sbucks[i]);
      while (ep != NULL) {
         *d1 = ep->selem.setmem;
         d1++;
         ep = BlkLoc(ep->selem.clink);
         }
      }
      qsort((char *)BlkLoc(lp->listhead)->lelem.lslots,(int)size,
         sizeof(struct descrip),anycmp);
   }
   Arg0.dword = D_List;
   BlkLoc(Arg0) = (union block *) lp;
   }

   else if (Arg1.dword == D_Table) {
      /*
       * Default i (the type of sort) to 1.
       */
      if (defshort(&Arg2, 1) == Error) 
         RunErr(0, NULL);
      switch ((int)IntVal(Arg2)) {

      /*
       * Cases 1 and 2 are as in standard Version 5.
       */
         case 1:
         case 2:
		{
      /*
       * The list resulting from the sort will have as many elements as
       *  the table has, so get that value and also make a valid list
       *  block size out of it.
       */
      nslots = size = BlkLoc(Arg1)->table.size;
      if (nslots < MinListSlots)
         nslots = MinListSlots;
      /*
       * Ensure space for: the list header block and a list element
       *  block for the list which is to be returned,
       *  a list header block and a list element block for each of the two
       *  element lists the sorted list is to contain.	Note that the
       *  calculation might be better expressed as:
       *    list_header_size + list_block_size + nslots * descriptor_size +
       *     nslots * (list_header_size + list_block_size + 2*descriptor_size)
       */
      if (blkreq(sizeof(struct b_list) + sizeof(struct b_lelem) +
         nslots * (sizeof(struct b_list) + sizeof(struct b_lelem) +
            3 * sizeof(struct descrip))) == Error) 
         RunErr(0, NULL);
      /*
       * Point bp at the table header block of the table to be sorted
       *  and point lp at a newly allocated list
       *  that will hold the the result of sorting the table.
       */
      bp = BlkLoc(Arg1);
      lp = alclist(size);
      lp->listhead.dword = lp->listtail.dword = D_Lelem;
      BlkLoc(lp->listtail) = (union block *)alclstb(nslots, (word)0, size);
      BlkLoc(lp->listhead) = BlkLoc(lp->listtail);
      /*
       * If the table is empty, there is no need to sort anything.
       */
      if (size <= 0)
         break;
         /*
          * Point d1 at the start of the list elements in the new list
          *  element block in preparation for use as an index into the list.
          */
         d1 = BlkLoc(lp->listhead)->lelem.lslots;
         /*
          * Traverse the element chain for each table bucket.  For each
          *  element, allocate a two-element list and put the table
          *  entry value in the first element and the assigned value in
          *  the second element.  The two-element list is assigned to
          *  the descriptor that d1 points at.	When this is done, the
          *  list of two-element lists is complete, but unsorted.
          */
         for (i = 0; i < TSlots; i++) {
            ep = BlkLoc(bp->table.buckets[i]);
            while (ep != NULL) {
               d1->dword = D_List;
               tp = alclist((word)2);
               BlkLoc(*d1) = (union block *) tp;
               tp->listhead.dword = tp->listtail.dword = D_Lelem;
               BlkLoc(tp->listtail) = (union block *)alclstb((word)2, (word)0,
                  (word)2);
               BlkLoc(tp->listhead) = BlkLoc(tp->listtail);
               BlkLoc(tp->listhead)->lelem.lslots[0] = ep->telem.tref;
               BlkLoc(tp->listhead)->lelem.lslots[1] = ep->telem.tval;
               d1++;
               ep = BlkLoc(ep->telem.clink);
               }
            }
         /*
          * Sort the resulting two-element list using the sorting function
          *  determined by i.
          */
         if (IntVal(Arg2) == 1)
            qsort((char *)BlkLoc(lp->listhead)->lelem.lslots, (int)size,
                  sizeof(struct descrip), trefcmp);
         else
            qsort((char *)BlkLoc(lp->listhead)->lelem.lslots, (int)size,
                  sizeof(struct descrip), tvalcmp);
         break;		/* from cases 1 and 2 */
         }
      /*
       * Cases 3 and 4 were introduced in Version 5.10.
       */
         case 3 :
         case 4 :
                 {
      /*
       * The list resulting from the sort will have twice as many elements as
       *  the table has, so get that value and also make a valid list
       *  block size out of it.
       */
      nslots = size = BlkLoc(Arg1)->table.size * 2;
      if (nslots < MinListSlots)
         nslots = MinListSlots;
      /*
       * Ensure space for: the list header block and a list element
       *  block for the list which is to be returned, and two descriptors for
       *  each table element.
       */
      if (blkreq(sizeof(struct b_list) + Vsizeof(struct b_lelem) +
            (nslots * sizeof(struct descrip))) == Error) 
         RunErr(0, NULL);

      /*
       * Point bp at the table header block of the table to be sorted
       *  and point lp at a newly allocated list
       *  that will hold the the result of sorting the table.
       */
      bp = BlkLoc(Arg1);
      lp = alclist(size);
      lp->listhead.dword = lp->listtail.dword = D_Lelem;
      BlkLoc(lp->listtail) = (union block *)alclstb(nslots, (word)0, size);
      BlkLoc(lp->listhead) = BlkLoc(lp->listtail);
      /*
       * If the table is empty there's no need to sort anything.
       */
      if (size <= 0)
         break;

         /*
          * Point d1 at the start of the list elements in the new list
          *  element block in preparation for use as an index into the list.
          */
         d1 = BlkLoc(lp->listhead)->lelem.lslots;
         /*
          * Traverse the element chain for each table bucket.  For each
          *  table element copy the the entry descriptor and the value
          *  descriptor into adjacent descriptors in the lslots array
          *  in the list element block.
          *  When this is done we now need to sort this list.
          */
         for (i = 0; i < TSlots; i++) {
            ep = BlkLoc(bp->table.buckets[i]);
            while (ep != NULL) {
               *d1 = ep->telem.tref;
               d1++;
               *d1 = ep->telem.tval;
               d1++;
               ep = BlkLoc(ep->telem.clink);
               }
            }
         /*
          * Sort the resulting two-element list using the sorting function
          *  determined by i.
          */
         if (IntVal(Arg2) == 3)
            qsort((char *)BlkLoc(lp->listhead)->lelem.lslots, (int)size / 2,
                  (2 * sizeof(struct descrip)), trcmp3);
         else
            qsort((char *)BlkLoc(lp->listhead)->lelem.lslots, (int)size / 2,
                  (2 * sizeof(struct descrip)), tvcmp4);
            break; /* from case 3 or 4 */
            }

         default:
            RunErr(205, &Arg2);

         } /* end of switch statement */

      /*
       * Make Arg0 point at the sorted list.
       */
      Arg0.dword = D_List;
      BlkLoc(Arg0) = (union block *) lp;
      }
   else {  /* Tried to sort something that wasn't a list or a table. */
      RunErr(115, &Arg1);
      }
   Return;
   }

/*
 * trefcmp(d1,d2) - compare two-element lists on first field.
 */

trefcmp(d1,d2)
struct descrip *d1, *d2;
   {
   extern anycmp();

#ifdef Debug
   if (d1->dword != D_List || d2->dword != D_List)
      syserr("trefcmp: internal consistency check fails.");
#endif					/* Debug */
   return (anycmp(&(BlkLoc(BlkLoc(*d1)->list.listhead)->lelem.lslots[0]),
                  &(BlkLoc(BlkLoc(*d2)->list.listhead)->lelem.lslots[0])));
   }

/*
 * tvalcmp(d1,d2) - compare two-element lists on second field.
 */

tvalcmp(d1,d2)
struct descrip *d1, *d2;
   {
   extern anycmp();

#ifdef Debug
   if (d1->dword != D_List || d2->dword != D_List)
      syserr("tvalcmp: internal consistency check fails.");
#endif					/* Debug */
   return (anycmp(&(BlkLoc(BlkLoc(*d1)->list.listhead)->lelem.lslots[1]),
                  &(BlkLoc(BlkLoc(*d2)->list.listhead)->lelem.lslots[1])));
   }

/*
 * The following two routines are used to compare descriptor pairs in the
 *  experimental table sort.
 *
 * trcmp3(dp1,dp2)
 */

trcmp3(dp1,dp2)
struct dpair *dp1,*dp2;
{
   extern anycmp();

   return (anycmp(&((*dp1).dr),&((*dp2).dr)));
}
/*
 * tvcmp4(dp1,dp2)
 */

tvcmp4(dp1,dp2)
struct dpair *dp1,*dp2;

   {
   extern anycmp();

   return (anycmp(&((*dp1).dv),&((*dp2).dv)));
   }

/*
 * type(x) - return type of x as a string.
 */

FncDcl(type,1)
   {

   if (Qual(Arg1)) {
      StrLen(Arg0) = 6;
      StrLoc(Arg0) = "string";
      }

   else {
      switch (Type(Arg1)) {

         case T_Null:
            StrLen(Arg0) = 4;
            StrLoc(Arg0) = "null";
            break;

	 case T_Bignum:
         case T_Integer:
            StrLen(Arg0) = 7;
            StrLoc(Arg0) = "integer";
            break;

         case T_Real:
            StrLen(Arg0) = 4;
            StrLoc(Arg0) = "real";
            break;

         case T_Cset:
            StrLen(Arg0) = 4;
            StrLoc(Arg0) = "cset";
            break;

         case T_File:
            StrLen(Arg0) = 4;
            StrLoc(Arg0) = "file";
            break;

         case T_Proc:
            StrLen(Arg0) = 9;
            StrLoc(Arg0) = "procedure";
            break;

         case T_List:
            StrLen(Arg0) = 4;
            StrLoc(Arg0) = "list";
            break;

         case T_Table:
            StrLen(Arg0) = 5;
            StrLoc(Arg0) = "table";
            break;

         case T_Set:
            StrLen(Arg0) = 3;
            StrLoc(Arg0) = "set";
            break;

         case T_Record:
            Arg0 = BlkLoc(BlkLoc(Arg1)->record.recdesc)->proc.recname;
            break;

         case T_Coexpr:
            StrLen(Arg0) = 13;
            StrLoc(Arg0) = "co-expression";
            break;

         case T_External:
            StrLen(Arg0) = 8;
            StrLoc(Arg0) = "external";
            break;

         default:
            syserr("type: unknown type.");
         }
      }
   Return;
   }

/*
 * errorclear() - clear error condition.
 */

FncDcl(errorclear,0)
   {
   k_errornumber = 0;
   k_errortext = "";
   k_errorvalue = nulldesc;
   Return;
   }
