/* stdfp.h: target file generated partly by fpc from source tmp.fp */

#define FALSEOBJ  	0
#define TRUEOBJ   	1
#define INTCONST  	2
#define FLOATCONST	3
#define ATOMCONST 	4
#define CHARCONST 	5
#define NILOBJ    	6
#define VECTOR    	7

typedef struct fp_object * fp_data;

struct fp_object
{
  short fp_type;
  short fp_ref;
  union
  {
    long fp_int;
    int fp_char; /* long for reasons of alignment in constant definitions */
    char * fp_atom;
    float fp_float;
    fp_data fp_next;
  } fp_header;
  fp_data fp_entry;
};

struct fp_constant
{
  short fp_type;
  short fp_ref;
  long fp_value;
  fp_data fp_entry;
};

struct fp_floatc
{
  short fp_type;
  short fp_ref;
  float fp_value;
};

struct fp_charc
{
  short fp_type;
  short fp_ref;
  int fp_value;
};

struct stackframe
{
  char * st_name;
  fp_data st_data;
  struct stackframe * st_prev;
};

#define inc_ref(d)	((d)->fp_ref++)
#define dec_ref(d)	if (((d)->fp_type == VECTOR) && \
				(--((d)->fp_ref) <= 0)) returnvect (d)
#define abs(n)	((n) < 0 ? - (n) : (n))

