/* mkffp.c: this file, when linked with the FP preprocessor, will
 *	    produce an FP to FFP compiler. The compiler will read in
 *	    one or more FP files and for each FP function defined
 *	    will produce a corresponding FFP file function.ffp.
 */

#include <stdio.h>
#include <strings.h>
#include "fpc.h"
#include "parse.h"
#include "code.h"

FILE * outfile;

/* set newname to "" to indicate that no file should be opened */
void newfname (oldname, newname)
char * oldname, * newname;
{
  *newname = '\0';
}

static void codeobj (tree)
fpexpr tree;
{
  switch (tree->exprtype)
  {
    case NIL:
      (void) fprintf (outfile, "<>");
      break;
    case TRUE:
      (void) fprintf (outfile, "T");
      break;
    case FALSE:
      (void) fprintf (outfile, "F");
      break;
    case INT:
      (void) fprintf (outfile, "%d", tree->fpexprv.intobj);
      break;
    case FLOAT:
      (void) fprintf (outfile, "%f", tree->fpexprv.floatobj);
      break;
    case SYM:
      (void) fprintf (outfile, "%s", tree->fpexprv.symbol);
      break;
    case CHAR:
      (void) fprintf (outfile, "'%c", tree->fpexprv.character);
      break;
    case LIST:
      (void) putc ('<', outfile);
      while (tree != 0)
      {
	codeobj (tree->fpexprv.listobj.listel);
        (void) putc (' ', outfile);
	tree = tree->fpexprv.listobj.listnext;
      }
      (void) fprintf (outfile, ">\n");
      break;
    default:
      yyerror ("compiler error 11");
  }
}

static void codeexpr (tree)
fpexpr tree;
{
#define STKSIZE	128
  fpexpr stack [STKSIZE];
  int stkptr;

  switch (tree->exprtype)
  {
    case COND:
      (void) fprintf (outfile, "<cond ");
      codeexpr (tree->fpexprv.conditional [0]);
      (void) putc (' ', outfile);
      codeexpr (tree->fpexprv.conditional [1]);
      (void) putc (' ', outfile);
      codeexpr (tree->fpexprv.conditional [2]);
      (void) fprintf (outfile, ">\n");
      break;
    case BUR:
    case BU:
      if (tree->exprtype != BU)
	(void) fprintf (outfile, "<bur ");
      else
	(void) fprintf (outfile, "<bu ");
      codeexpr (tree->fpexprv.bulr.bufun);
      (void) putc (' ', outfile);
      codeobj (tree->fpexprv.bulr.buobj);
      (void) fprintf (outfile, ">\n");
      break;
    case WHILE:
      (void) fprintf (outfile, "<while ");
      codeexpr (tree->fpexprv.whilestat [0]);
      (void) putc (' ', outfile);
      codeexpr (tree->fpexprv.whilestat [1]);
      (void) fprintf (outfile, ">\n");
      break;
    case COMP:
      (void) fprintf (outfile, "<compose ");
      stkptr = 0;
      while (tree != 0)
      {
	if (stkptr >= STKSIZE)
	  yyerror ("compiler stack overflow, compose too long");
        stack [stkptr++] = tree->fpexprv.compconstr.compexpr;
	tree = tree->fpexprv.compconstr.compnext;
      }
      while (stkptr != 0)
      {
        codeexpr (stack [--stkptr]);
        (void) putc (' ', outfile);
      }
      (void) fprintf (outfile, ">\n");
      break;
    case AA:
      (void) fprintf (outfile, "<aa ");
      codeexpr (tree->fpexprv.aains);
      (void) fprintf (outfile, ">\n");
      break;
    case CONSTR:
      (void) fprintf (outfile, "<constr ");
      while (tree != 0)
      {
        codeexpr (tree->fpexprv.compconstr.compexpr);
        (void) putc (' ', outfile);
	tree = tree->fpexprv.compconstr.compnext;
      }
      (void) fprintf (outfile, ">\n");
      break;
    case TREE:
    case RINSERT:
    case INSERT:
      if ((tree->fpexprv.aains->exprtype == FNCALL) &&
	  (strcmp (tree->fpexprv.aains->fpexprv.funcall, "plus") == 0))
        (void) fprintf (outfile, "plus");
      else if ((tree->fpexprv.aains->exprtype == FNCALL) &&
	  (strcmp (tree->fpexprv.aains->fpexprv.funcall, "times") == 0))
        (void) fprintf (outfile, "times");
      else if ((tree->fpexprv.aains->exprtype == FNCALL) &&
	  (strcmp (tree->fpexprv.aains->fpexprv.funcall, "and") == 0))
        (void) fprintf (outfile, "and");
      else if ((tree->fpexprv.aains->exprtype == FNCALL) &&
	  (strcmp (tree->fpexprv.aains->fpexprv.funcall, "or") == 0))
        (void) fprintf (outfile, "or");
      else
      {
	if (tree->exprtype == TREE)
          (void) fprintf (outfile, "<tree ");
        else if (tree->exprtype == RINSERT)
          (void) fprintf (outfile, "<rinsert ");
        else /* (tree->exprtype == INSERT) */
          (void) fprintf (outfile, "<insert ");
        codeexpr (tree->fpexprv.aains);
        (void) fprintf (outfile, ">\n");
      }
      break;
    case RSEL:
      (void) fprintf (outfile, "<rselect %d>\n", tree->fpexprv.lrsel);
      break;
    case SEL:
      (void) fprintf (outfile, "<select %d>\n", tree->fpexprv.lrsel);
      break;
    case FNCALL:
      (void) fprintf (outfile, "%s", tree->fpexprv.funcall);
      break;
    default:
      if ((tree->exprtype >= NIL) && (tree->exprtype <= CHAR))
      {
	(void) fprintf (outfile, "<const ");
        codeobj (tree);
	(void) fprintf (outfile, ">\n");
      }
      else
        yyerror ("compiler error 10");
  }
}

/* called for each source FP function */
void code (fun, tree)
char * fun;
fpexpr tree;
{
  char name [256];

  (void) strcpy (name, fun);
  (void) strcpy (name + strlen (fun), ".ffp");
  outfile = fopen (name, "w");
  if (outfile == 0)
  {
    (void) sprintf (name, "unable to open file %s, aborting\n", name);
    yyerror (name);
  }
  codeexpr (tree);
  (void) fclose (outfile);
}

/* the following two functions are provided for compatibility */
void putfileheader (inname, outname)
char * inname;
char * outname;
{
}

void putfiletail ()
{
}
