# set.fp: defines, implements set operations on lists.
# A set is a collection of possibly unrelated items. Items
# may be added to this collection or deleted from it, or
# the existence of an item may be inquired about.
# An item is in the set if it is in the list at the top level.
# For instance, x and <y z> are in the set <a x b <y z> x>,
# but neither y nor z are in the set. Multiple copies of
# an item are allowed in a set.
# operations provided are:
# member: <item set> returns whether the item is in the set.
# include: <item set> returns a new set where the item has
#	been apndl'd to the set unless it was already present.
# exclude: <item set> returns a new set where the item has
#	been deleted from the set if it was there, and the
#	original set otherwise.
# includem: <<item*> set> returns a new set where all the
#	items have included, in the reverse order: in
#	other words, the two lists are appended, and the
#	first copy of any duplicates is then deleted.
# excludem: <<item*> set> returns a new set where any
#	item from item* is excluded.
# index: <item set> returns the index (position) of
#	the item in the set, or 0 if member would return false
#	if several copies of the item are present, it returns the first

Def member null o 2 -> _F;
           \/or o aa = o distl

Def include member -> 2; apndl

Def exclude null o 2 -> 2;
	    append o aa (!= -> tl; _<>) o distl

Def includem /include o apndr

Def excludem /exclude o apndr

# each set element becomes <pos <item element>>, then any that
# match send up their value, then the first valid value is taken
Def index null o 2 -> _0;
          \/((bu = 0) o 1 -> 2; 1) o aa (= o 2 -> 1; _0) o
	  trans o [iota o length, id] o distl

Def tstset [id, (\/and o aa = )] o
	    [[member o _<a, <>>, _F],
	     [member o _<x, <a, x, b, <y, z>, x>>, _T],
	     [member o _<<y, z>, <a, x, b, <y, z>, x>>, _T],
	     [member o _<y, <a, x, b, <y, z>, x>>, _F],
	     [member o _<z, <a, x, b, <y, z>, x>>, _F],
	     [include o _<a, <>>, _<a>],
	     [include o _<a, <b, c, d>>, _<a, b, c, d>],
	     [include o _<b, <b, c, d>>, _<b, c, d>],
	     [include o _<c, <b, c, d>>, _<b, c, d>],
	     [include o _<d, <b, c, d>>, _<b, c, d>],
	     [exclude o _<a, <>>, _<>],
	     [exclude o _<d, <b, c, d>>, _<b, c>],
	     [exclude o _<c, <b, c, d>>, _<b, d>],
	     [exclude o _<b, <b, c, d>>, _<c, d>],
	     [exclude o _<a, <b, c, d>>, _<b, c, d>],
	     [includem o _<<a, b, c>, <>>, _<a, b, c>],
	     [includem o _<<>, <>>, _<>],
	     [includem o _<<>, <b, c, d>>, _<b, c, d>],
	     [includem o _<<a>, <b, c, d>>, _<a, b, c, d>],
	     [includem o _<<a, b>, <b, c, d>>, _<a, b, c, d>],
	     [includem o _<<b, a>, <b, c, d>>, _<a, b, c, d>],
	     [includem o _<<c, z, b, a, d>, <b, c, d>>, _<z, a, b, c, d>],
	     [excludem o _<<a, b, c>, <>>, _<>],
	     [excludem o _<<>, <>>, _<>],
	     [excludem o _<<>, <b, c, d>>, _<b, c, d>],
	     [excludem o _<<a>, <b, c, d>>, _<b, c, d>],
	     [excludem o _<<a, b>, <b, c, d>>, _<c, d>],
	     [excludem o _<<b, a>, <b, c, d>>, _<c, d>],
	     [excludem o _<<c, z, b, a, d>, <b, c, d>>, _<>],
	     [index o _<a, <b, c, d>>, _0],
	     [index o _<a, <>>, _0],
	     [index o _<a, <a, b, c, d>>, _1],
	     [index o _<a, <a, a, c, d>>, _1],
	     [index o _<a, <a, b, a, d>>, _1],
	     [index o _<a, <a, b, c, a>>, _1],
	     [index o _<b, <a, b, c, d>>, _2],
	     [index o _<b, <a, b, b, d>>, _2],
	     [index o _<b, <a, b, c, b>>, _2],
	     [index o _<c, <a, b, c, d>>, _3],
	     [index o _<c, <a, b, c, c>>, _3],
	     [index o _<d, <a, b, c, d>>, _4]]
