# pairpos : <x1..xn> ==> <<1 x1>..<n xn>>
Def pairpos null -> _<>; trans o [iota o length, id]

# allpairs : <x1..xn> ==> <<<> x1> <x1 x2>..<xn <>>>
Def allpairs trans o [(bu apndl <>), apndr o [id, _<>]]

# ntl : <n <x1..xm>> ==> <xn+1..xm>
Def ntl	append o aa (>= o [1, 1 o 2] -> _<>; [2 o 2]) o
	distl o [1, pairpos o 2]

# nhd : <n <x1..xm>> ==> <x1..xn>
Def nhd append o aa (< o [1, 1 o 2] -> _<>; [2 o 2]) o
	distl o [1, pairpos o 2]

# seln : <<i l> <x1..xn>>, 1 <= i <= n, i + l <= n, l >= 0
# ==> <xi..xi+l-1>
Def seln nhd o [2 o 1, ntl o [- o [1 o 1, _1], 2]]

# selectl: <i <x1..xn>>, 1 <= i <= n ==> xi
Def selectl 1 o 2 o (while (bur > 1) o 1 [(bur - 1) o 1, tl o 2])

# selectr: <<xn..x1> i>, 1 <= i <= n ==> xi
Def selectr 1r o 2r o (while (bur > 1) o 1r [tlr o 2r, (bur - 1) o 1r])

# poslen : <<i1..in><x1..xm>>, i1 = 1, in <= m ==>
#	<<i1 i2-i1>..<in m+1-in>>
# i.e. the data is almost ready for seln
Def poslen trans o [1, aa - o trans o
			[apndr o [tl o 1, (bu + 1) o length o 2], 1]]

# breakup : <<i1..in><x1..xm>>, i1 = 1, in <= m ==>
#	<<x1..xi2-1><xi2..xi3-1>..<xin..xm>>
Def breakup aa seln o distr o [poslen, 2]

# permute : <<i1 x1>..<in xn>> where {iy} = 1..n ==> <xj..xk>
#	where ij = 1, ik = n and so on for the intermediate i's
Def permute append o aa append o aa aa (= o [1 o 1, 2] -> [2 o 1]; _<>) o
	   aa distr o distl o [id, iota o length]

# rank : <x <x1..xn>> ==> m where m is the number of xi's <= x
Def rank \/+ o aa ( < -> _0; _1) o distl

Def tstlib [trans, =] o
	   [[pairpos o _<7, 5, 3, 1>, ntl o _<2, <4, 5, 6, 8>>,
	     allpairs o _<1, 2, 3, 4, 5, 6, 7, 8, 9>, allpairs o _<1>,
	     nhd o _<2, <4, 5, 6, 8>>,
	     seln o _<<3, 4>, <1, 2, 3, 4, 5, 6, 7, 8>>,
	     selectl o _<5, <a, b, c, d, e, f, g>>,
	     selectr o _<<a, b, c, d, e, f, g>, 5>,
	     breakup o _<<1, 4, 6>, <1, 2, 3, 4, 5, 6, 7, 8, 9, 10>>,
	     permute o _<<5, 9>, <2, 3>, <1, 1>, <4, 7>, <3, 5>>,
	     permute o _<<2, 3>, <1, 7>, <3, 5>>,
	     rank o _<4, <1, 2, 3, 4, 5, 6>>, rank o _<2, <5, 0, 4, 1>>],
	    _<<<1, 7>, <2, 5>, <3, 3>, <4, 1>>,
 	      <6, 8>,
 	      <<<>, 1>, <1, 2>, <2, 3>, <3, 4>, <4, 5>, <5, 6>, <6, 7>,
		<7, 8>, <8, 9>, <9, <>>>,
 	      <<<>, 1>, <1, <>>>,
 	      <4, 5>,
 	      <3, 4, 5, 6>,
	      e,
	      c,
 	      <<1, 2, 3>, <4, 5>, <6, 7, 8, 9, 10>>,
 	      <1, 3, 5, 7, 9>,
 	      <7, 3, 5>,
 	      4,
 	      2>]
