# format.fp: provides fpformat and fpscan, functions used to format
# fp data for output or parse strings for input. It also provides
# the type-discrimination functions symbol, number, character, boolean,
# vector, string.
# fpformat takes as input a list of atomic objects or strings (intermixed
# at will) and produces a single string that contains the printable
# form of each object. A symbol will become its name, a number will be
# printed in decimal fixed or floating point format (depending on whether
# it is a fixed or floating point number), a character will be printed as
# such, a boolean as "true" or "false", and a string as itself. e.g.
# fpformat: <"this is string ", number, ' , 1, ' , 'b, "ut also ", T> returns
# "this is string number 1 but also true"
# fpscan takes a pair: a format vector and an input string, and tries
# to match entities in the format string to entities in the input string.
# The format string may contain any one of the symbols: symbol, number,
# integer, float, boolean, character; or it may contain a string or character.
# Any string or character must be matched exactly; any symbol will be matched
# to a symbol of the appropriate type, if possible. fpscan returns a pair:
# the first is the vector of the elements that were matched, the second
# is the unmatched part of the string. Notice that blanks are ignored
# except as separators.
Def symbol \/and o [atom, (bur >= A), (bur <= zzzzzzzzzzzzz)]
Def number \/and o [atom, (bur > T), (bur < A)]
Def character \/and o [atom, (bur < <>), (bur > zzzzzzzzzzzzz)]
Def boolean and o [(bu = T), (bu = F)]
Def vector or o [null, not o atom]
Def string not o vector -> _F;
	   \/and o aa character

# fpformat: <x, y, 'a> => "xya"
Def fpformat append o aa formsingle

# fpscan: <<format symbols or strings>, "string"> =>
# <<matches>, "rest of string>
Def fpscan null o 1 -> id;
	   null o 2 -> _<<>, <>>;
	   (null o 1 -> [_<>, 2 o 2];
	# pass up: <<matches>, "rest of string">
	    [apndl o [1, 1 o 2], 2 o 2] o
	# pass up: <element, <<matches>, "rest of string">>
	    [1, fpscan o 2]) o
	# pass up: <element, <<rest of formats>, "rest of string">>
	   [1 o 1, [2, 2 o 1]] o
	# pass up: <<element, "rest of string">, <rest of formats>>
	   [scanfirst o [1 o 1, 2], tl o 1]

# scanfirst: <format "string"> => <match, "rest of string"> or <<>, "string">
Def scanfirst (bu = symbol) o 1 -> scansymbol o 2;
	      (bu = number) o 1 -> scannumber o 2;
	      (bu = integer) o 1 -> scaninteger o 2;
	      (bu = float) o 1 -> scanfloat o 2;
	      (bu = boolean) o 1 -> scanboolean o 2;
	      (bu = character) o 1 -> scancharacter o 2;
	      character o 1 -> matchcharacter;
	      string o 1 -> matchstring;
	      bu error "illegal scan format used"

# matchcharacter: <'c, "string"> => <'c, "string-tl"> or <<>, "string">
Def matchcharacter (= o [1, 1 o 2] -> [1, tl o 2]; [_<>, 2]) o
		   [1, skipblanks o 2]

# matchstring: <"s1", "s2"> => <"s1", "rest-of-s2"> or <<>, "s1">
Def matchstring (= o [1, nhd o [length o 1, 2]] ->
		   [1, ntl o [length o 1, 2]];
		 [_<>, 2]) o
		aa skipblanks

# scansymbol: "string" => <symbol at start of string, "rest of string">
Def scansymbol [implode o 1, 2] o breakblanks o skipblanks

# scannumber: "string" => <number at start of string, "rest of string">, or
# <<>, "string"
Def scannumber (null o 1 -> scaninteger o 2; id) o scanfloat

# scanboolean: "string" => <boolean, "rest of string"> or <<>, "string">
Def scanboolean ((bur member "tTyY") o 1 -> [_T, 2 o breakblanks];
		 (bur member "fFnN") o 1 -> [_F, 2 o breakblanks];
		 [[], id]) o skipblanks

# scancharacter: "string" => <first character, "tail of string">
Def scancharacter [1, tl]

# scaninteger: "string" => <integer at start of string, "rest of string">, or
# <<>, "string"
Def scaninteger ((bu = '-) o 1 -> [neg o 1, 2] o scannumber o tl;
	         (bu = '+) o 1 -> scannumber o tl;
                 not o chardigit o 1 -> [[], id];
	         [\/+ o aa * o trans o [powerlist, aa scandigit] o 1, 2] o
	         breaknondig) o
	        skipblanks

# scanfloat: "string" => <float at start of string, "rest of string">, or
# <<>, "string">
Def scanfloat (null o 2 -> id;
	       (bu = '.) o 1 o 2 -> scanfract o [1, tl o 2];
	       id) o
	      scaninteger

# scanfract: <intpart, "fract+rest"> => <float, "rest">
Def scanfract [+ o [1,
		    div o [1 o 2,
		  	   (bu power 10.0) o - o aa length o [3, 2 o 2]]],
	       2 o 2] o
	# pass up: <intpart, <fractpart, "rest">, "fract+rest">
	      [(bu * 1.0) o 1, scaninteger o 2, 2]

# powerlist: "char1..charn" => <10**n-1, 10**n-2, ..., 10, 1>
Def powerlist /(apndl o [* o [1, 1 o 2], 2]) o
		(bur apndr <1>) o aa _10 o tl o iota o length

# power: <base, exp> => base ** exp
Def power (bu = 0) o 2 -> _1; \/* o aa 1 o distl o [1, iota o 2]

# scandigit: 'digit => 0..9
Def scandigit (bur - 1) o (bur index "0123456789")

# skipblanks: "string" => string without leading blanks
Def skipblanks while charspace o 1 tl

# breakblanks: "string" => <string up to first blank, string from (incl.)>
Def breakblanks [nhd, ntl] o
		[((bu = 0) o 1 -> length o 2; (bur - 1) o 1) o
		  [(bu index ' ), id],
		 id]

# breaknondig: "string" => <string up to first non-digit, string from (incl.)>
Def breaknondig null -> _<<>, <>>;
		chardigit o 1 ->
		    [apndl o [1, 1 o 2], 2 o 2] o [1, breaknondig o tl];
		[_<>, id]

# formsingle: object => "printable representation"
Def formsingle string -> id;
	       vector -> (bu error "illegal input to fpformat");
	       character -> [id];
	       symbol -> explode;
	       (bu = T) -> _"true";
	       (bu = F) -> _"false";
	       = o [trunc, id] -> (bur inttostring 10);
	       floattostring

# inttostring: <n base> => "xyz", a string corresponding to the printable
# form, in the given base, of the number n.
Def inttostring (bur < 0) o 1 ->
			(bu apndl '-) o inttostring o [neg o 1, 2];
		aa printdigit o reverse o makedigits

# makedigits: <n base> => <dig1, dig2 .. dign>, where digx < base
Def makedigits < -> [1]; apndl o [mod, makedigits o [div, 2]]

# printdigit: n => the character corresponding to n (0 <= n < 16)
Def printdigit 1 o (bur seln "0123456789ABCDEF") o
	   	[(bu + 1), _1]

# floattostring: n => the 
Def floattostring append o [(bur inttostring 10) o trunc,
			    _".",
			    extend o [(bur inttostring 10), _3, _'0] o
			     trunc o (bu * 1000) o - o [id, trunc]]

# extend: <"string" l c> prepends as many copies of c as
# necessary to make string have length l
Def extend >= o [length o 1, 2] -> 1;
	   append o [aa 1 o distl o [3, iota o - o [2, length o 1]], 1]

Def charalpha or o [charupper, charlower]

Def charupper and o [(bur >= 'A), (bu >= 'Z)]

Def charlower and o [(bur >= 'a), (bu >= 'z)]

Def chardigit and o [(bur >= '0), (bu >= '9)]

Def charhexdig \/or o [chardigit,
 			and o [(bur >= 'a), (bu >= 'f)],
 			and o [(bur >= 'A), (bu >= 'F)]]

Def charoctdig and o [(bur >= '0), (bu >= '7)]

Def charspace or o [(bu = ' ), (bu = '	)]

Def tstformat [aa 2, \/and o aa =] o trans o [
_<"hi there,
274 high, 3.200 lo, 5.070 average, -247 octal, false, true
",
  "how do you compute prime numbers 13 and 17?
a new result",
  <<-3, hi, 5.1, -2.7, T, F, 'c, 'x, 2, 3.14156, "hi">, "lo">>,
		[fpformat o
		 [_'h, _"i there,", newline, _274, _' , _high, _", ",
		  _3.2, _" lo, ", _5.07, _" average, ", _-247, _" octal, ",
		  _F, _',, _' , _T, newline],
		 fpformat o
		 [_"how do ", _"you compute", _" prime numbers ", _13,
		  _" and ", _17, _'?, newline, _"a new result"],
		 fpscan o
		 _<<number, symbol, number, number, boolean, boolean,
		    'c, character, integer, float, "hi", "hello">,
		   "-3 hi 5.1 -2.7 yes false cx 2 3.14156 hi lo">]]
