/* fpc: fp to c translator
 */

#include <stdio.h>
#include <strings.h>
#include "fpc.h"
extern FILE * fopen ();
extern char * sprintf ();
extern int errno;
extern char * sys_errlist [];
extern int sys_nerr;

/* here comes all the "exported" stuff, mostly flags showing which
   switches were given on the command line */
FILE * outf;
int makemain;		/* this and the following used for flag settings: -m */
char mainfn [MAXIDLEN];	/* -mfname: the main function, if any */
int verbose;		/* -v: print fpc version, functions being done */
int useparms;		/* -p: if program has parms, input is <> */
int rstring;		/* -i: read input as string, not fp object */
int wstring;		/* -o: write output as string, not fp object */
int redirout;		/* -c: output is of form: <<device op data>*> */
/* Typical system-independent devices are graphic, turtle, bitmap.
   For graphic, ops such as circle and line (with corresponding data
   cx cy r, or x1 y1 x2 y2), are available. Similarly for turtle we
   have <turtle move 2> and <turtle turnto west>. Not implemented. */
int makeast;		/* -a: The main function is used in an AST system */
int makedeb;		/* -d: trace all functions during execution */
int makeee;		/* -e: trace function entry/exit (no params,res) */
int check;		/* -n: do not check for illegal inputs */
int printspace;		/* -s: print how much space was used and returned */
char tracefns [MAXIDS] [MAXIDLEN];	/* the functions to be traced (-t) */
int traceptr;		/* the first free slot */
/* end of the exported variables */

static int dostdio = 1;	/* only if no file name is given */

static int badexit = 0;	/* if syntax error was found, return (1) at end */

static void resetglobals ()
{
  outf = stdout;
  makemain = 0;
  mainfn [0] = '\0';
  rstring = 0;
  wstring = 0;
  redirout = 0;
  makeast = 0;
  makedeb = 0;
  printspace = 0;
  makeee = 0;
  check = 1;
  traceptr = 0;
  verbose = 0;
  useparms = 0;
}

static void clrmains ()
{
  rstring = 0;
  wstring = 0;
  redirout = 0;
  makeast = 0;
  useparms = 0;
  printspace = 0;
}

static char * fname = 0;

int main (argc, argv)
int argc;
char *argv[];
{
  FILE *dataIn;
  int argind, len;
  char outname [256];
  int swind;
  char errbuf [256];			/* used for sprintf's */
  extern void newfname ();
  void closerror ();
  char * syserror ();

  resetglobals ();
  for (argind = 1; argind < argc; argind++)
  {
    if (argv [argind] [0] != '-')
    {
      dostdio = 0;	/* at least one file was given */
      if (! makemain)
	clrmains ();
      fname = argv [argind];
      len = strlen (fname);
      if ((fname [len - 3] != '.') ||
	  (fname [len - 2] != 'f') ||
	  (fname [len - 1] != 'p'))	/* wrong extension */
      {
	(void) sprintf (errbuf,
	         	"error in source file name (%s): should end in .fp\n",
		        fname);
        yyerror (errbuf);
	continue;
      }
      newfname (fname, outname);
/* use newfname so whatever code generator is attached can decide how
   to call the file, if any */
      dataIn = fopen (argv [argind], "r");
      if (*outname != '\0')
        outf = fopen (outname, "w");
      else
        outf = stdout;
      if ((dataIn == 0) || (outf == 0))
      {
	(void) sprintf (errbuf, "error opening file %s: %s\n",
		        (dataIn == 0) ? fname : outname, syserror ());
	yyerror (errbuf);
	continue;
      }
      if (makemain && (mainfn [0] == '\0'))
      {
	(void) strcpy (mainfn, fname);
	mainfn [len - 3] = '\0';
      }
      fpcFile (dataIn, fname, outname);
      if ((outf != stdout) && (fclose (outf) != 0))
	closerror (outname);
      else if (fclose (dataIn) != 0)
	closerror (outname);
      resetglobals ();
    }
    else	/* we are parsing a switch */
      for (swind = 1; (argv [argind] [swind] != '\0'); swind++)
      {
	switch (argv [argind] [swind])
        {
	  case 'v':
	    verbose = 1;
	    (void) printf ("fpc 1.0\n");
	    break;
	  case 'm':
	    makemain = 1;
	    if (argv [argind] [swind + 1] != '\0')
/* function name is also given */
	      (void) strcpy (mainfn, (argv [argind]) + swind + 1);
	    argv [argind] [swind + 1] = '\0';   /* to break out of the loop */
	    break;
	  case 'a':
	    makeast = 1;
	    break;
	  case 'p':
	    useparms = 1;
	    break;
	  case 'i':
	    rstring = 1;
	    break;
	  case 'o':
	    wstring = 1;
	    break;
	  case 'c':
	    redirout = 1;
	    break;
	  case 'd':
	    makedeb = 1;
	    if (! check)
	      (void) fprintf (stderr,
			      "option -n conflicts with -d, ignored\n");
	    check = 1;
	    break;
	  case 'e':
	    makeee = 1;
	    if (! check)
	      (void) fprintf (stderr,
			      "option -n conflicts with -e, ignored\n");
	    check = 1;
	    break;
	  case 'n':
	    check = (makedeb || makeee);
	    if (check)
	      (void) fprintf (stderr,
			      "option -n conflicts with -%c, ignored\n",
		       ((makedeb) ? 'd' : 'e'));
	    break;
	  case 's':
	    printspace = 1;
	    break;
	  case 't':
	    (void) strcpy (tracefns [traceptr++], (argv [argind]) + swind + 1);
	    argv [argind] [swind + 1] = '\0';   /* to break out of the loop */
	    break;
	  default:
	    (void) sprintf (errbuf, "unknown option -%c",
			    argv [argind] [swind]);
	    yyerror (errbuf);
	}
      }
  }
  if (dostdio)
    fpcFile (stdin, "user input", "screen output");
  return (badexit);	/* makefile will abort if something didn't compile */
}

static char * syserror ()
{
  char syserr [256];

  if (errno < sys_nerr)
    strcpy (syserr, sys_errlist [errno]);
  else
    (void) sprintf (syserr, "undocumented error number %d", errno);
  return (syserr);
}

static void closerror (filename)
char * filename;
{
  char errbuf [256];

  (void) sprintf (errbuf, "error closing file \"%s\": %s\n",
		  filename, syserror ());
  yyerror (errbuf);
}

fpcFile (fptr, inname, outname)
FILE *fptr;
char * inname, * outname;
{
  extern FILE * yyin;
  void putfileheader ();
  void putfiletail ();

  putfileheader (inname, outname);
  yyin = fptr;
  yyparse ();
  putfiletail ();
}

int current_line = 1;

set_line (s)
char * s;
{
  while (((*s > '9') || (*s < '0')) && (*s != '\0'))
    s++;
  if (*s == '\0')
    return;
  (void) sscanf (s, "%d", &current_line);
}

inc_line ()
{
  current_line++;
}

yyerror (s)
char * s;
{
  extern char yytext [];

  puterror (s, yytext);
}

puterror (s, t)
char * s;
char * t;
{
  extern char funname [];
  extern int inerror;

  if (! inerror)
  {
    if (fname != 0)
      (void) fprintf (stderr, "\"%s\", ", fname);
    (void) fprintf (stderr, "line %d: ", current_line);
    (void) fprintf (stderr, "%s in function %s", s, funname);
    if (*t != '\0')
      (void) fprintf (stderr, ", token is %s", t);
    (void) fprintf (stderr, "\n");
  }
  inerror = 1;
  badexit = 1;
}
