/* code.h: defines the constants used by code.c not declared in parse.h */

#define DCLMASK	0x7	/* There will be at most DCLMASK+1 declarations */
			/* on a single line. This value only affects */
			/* pretty-printing and should be 2^x-1 for some x */

#define DCLEMASK 0x3	/* Like DCLMASK, but for externs, which are longer */

#define HEADERTYPE "long"
			/* this must be a type of the same size as the */
			/* largest element of the union {...} fp_header */
			/* in the declaration of fp_object. Otherwise, */
			/* the declaration of constants will be incorrect */

#define HEADERFLOAT "float"	/* this is the type of fp_float */

#define HEADERCHAR "int"	/* this is the type of fp_char */

#define BRACE (void) fprintf (outf, "%s{\n", indentstr ()); indent (1)

#define UNBRACE (void) indent (0); fprintf (outf, "%s}\n", indentstr ())
