/* parse.h: defines the possible structures of the parse tree
 *	    used to represent FP functions.
 */

#define COND	0
#define BU	1
#define BUR	2
#define WHILE	3
#define COMP	4
#define AA	5
#define CONSTR	6
#define INSERT	7
#define RINSERT	8
#define TREE	9
/* unnecessary, since the individual constant types take care of this
 #define CONST	10 */
#define SEL	11
#define RSEL	12
#define MULTI	13
/* not a real functional form, used for in-lining /{+, *, and, or} */
#define FNCALL	14
#define INVALID	15

#define NIL	20
#define TRUE	21
#define FALSE	22
#define LIST	23
#define INT	24
#define FLOAT	25
#define SYM	26
#define CHAR	27

typedef struct fpexprd * fpexpr;

union fpexprc
{
  fpexpr conditional [3];	/* if, then, else */
  struct {
	   fpexpr bufun;
	   fpexpr buobj;
	 } bulr;		/* bu, bur */
  fpexpr whilestat [2];		/* predicate, body */
  struct {
	   fpexpr compexpr;
           fpexpr compnext;
         } compconstr;
/* compose, construct both have lists of expressions */
  fpexpr aains;			/* aa, all inserts, multi */
  int lrsel;			/* left, right selects */
  char * funcall;		/* function call */
  struct {
	   fpexpr listel;
           fpexpr listnext;
         } listobj;
  long intobj;
  double floatobj;
  char * symbol;
  char * string;
  char character;
};

struct fpexprd
{
  int exprtype;
  union fpexprc fpexprv;
  char constvar [6];		/* only used for constants */
};

#ifndef STACKDEPTH
#define STACKDEPTH 100
#endif

