# printf.fp: provides fpprintf and fpscanf, functions defined like
# the corresponding C functions.
# e.g. fpprintf: <"hello %c %s\n", 'x, "string"> would return
# 	"hello x string<newline>"
# for now, field lengths are not defined
Def fpprintf append o aa format o trans o [parsectrl, distformats]

# parsectrl: "control %x string%y \n" => <"control %x", "string%y", " <nl>">
Def parsectrl breakup o
# next two lines, check that 1 is in the list of break up positions
	      (null o 1 -> [_<1>, 2];
	       (bu != 1) o 1 o 1 -> [(bu apndl 1) o 1, 2]; id) o
# next line, make sure that the last break-up position is needed
	      (> o [1r o 1, length o 2] -> [tlr o 1, 2]; id) o
# figure out preliminary break-up positions, put newlines
	      [append o aa parsebreak o pairpos o tl o allpairs,
	       id] o subnewline o 1

# parsebreak: <pos, <c1, c2>> => <> if c1 != %, <pos+2> if c1 = %
Def parsebreak (bu = '%) o 1 o 2 -> [(bu + 2) o 1]; _<>

# subnewline: string => string with newline instead of every \n
Def subnewline append o aa subcharpair o tlr o allpairs

# subcharpair: <c1, c2> => newline if c1 = \, c2 = n; <c1> otherwise
Def subcharpair (bu = '\\) o 2 -> _<>; (bu = "\n") -> newline; [2]

# format: <ctrl-substring arg> => <new-substring>
Def format (bur < 2) o length o 1 -> 1;		# end of format string
	   (bu != '%) o 2r o 1 -> 1;		# same
	   (bu = 's) o 1r o 1 ->
		append o [tlr o tlr o 1, subnewline o 2];	# cat strings
	   (bu = 'd) o 1r o 1 ->
		append o [tlr o tlr o 1, (bur numtostring 10) o 2];
	   (bu = 'x) o 1r o 1 ->
		append o [tlr o tlr o 1, (bur numtostring 16) o 2];
	   (bu = 'o) o 1r o 1 ->
		append o [tlr o tlr o 1, (bur numtostring 8) o 2];
	   (bu = 'c) o 1r o 1 ->
		apndr o [tlr o tlr o 1, 2];
	   (bu error "fpprintf: unknown format was used")

# distformats: <format-string, other-args*> => <other-args*> or
# <other-args* format-string>, the former in the case that the last
# 2 elements of format-string are %c, where c is any character.
Def distformats (bur < 2) o length o 1 -> tl;
		(bu = '%) o 2r o 1 -> tl;
		rotl

# numtostring: <n base> => "xyz", a string corresponding to the printable
# form, in the given base, of the number n.
Def numtostring (bur < 0) o 1 ->
			(bu apndl '-) o numtostring o [neg o 1, 2];
		aa printdigit o reverse o makedigits

# makedigits: <n base> => <dig1, dig2 .. dign>, where digx < base
Def makedigits < -> [1]; apndl o [mod, makedigits o [div, 2]]

# printdigit: n => the character corresponding to n (0 <= n < 16)
Def printdigit 1 o (bur seln "0123456789ABCDEF") o
	   	[(bu + 1), _1]

Def charalpha or o [charupper, charlower]

Def charupper and o [(bur >= 'A), (bu >= 'Z)]

Def charlower and o [(bur >= 'a), (bu >= 'z)]

Def chardigit and o [(bur >= '0), (bu >= '9)]

Def charhexdig \/or o [chardigit,
			and o [(bur >= 'a), (bu >= 'f)],
			and o [(bur >= 'A), (bu >= 'F)]]

Def charoctdig and o [(bur >= '0), (bu >= '7)]

Def charspace or o [(bu = ' ), (bu = '	)]

Def tstfpprintf [aa 2, \/and o aa =] o trans o [
_<"hi there,
274 high, 3D4F lo, -247 octal
",
  "how do you compute prime numbers 13 and 17?
a new result">,
		aa fpprintf o
		[[_"h%s\\n%d h%cgh, %x lo, %o octal%s",
		  _"i there,", _274, _'i, _15695, _-167, newline],
		 [_"how do %s prime numbers %d and %x?%sa new result",
		  _"you compute", _13, _23, _"\\n"]]]
