# prims.fp: test suite for any implementation of FP or FP/FFP
Def prims [id, \/and] o
	  [testtl, testtlr,
	   testrotl, testrotr,
	   testid, testatom,
	   testdistl, testdistr,
	   testapndl, testapndr,
	   testeq, testnoteq,
	   testleq, testgeq,
	   testless, testgreater,
	   testplus, testminus,
	   testtimes, testdiv,
	   testneg, testmod,
	   testnull, testlength,
	   testtrans, testreverse,
	   testand, testor,
	   testnot, testiota]

Def testand \/and o aa = o
	   (bu trans <F, F, F, T>) o aa and o _<<F, F>, <F, T>, <T, F>, <T, T>>

Def testapndl \/and o aa = o
	   (bu trans <<a>, <a, b>, <a, b, c>, <<>>, <<a>>, <<a>, <b>>>) o
	   aa apndl o
	     _<<a, <>>, <a, <b>>, <a, <b, c>>, <<>, <>>, <<a>, <>>,
	       <<a>, <<b>>>>

Def testapndr \/and o aa = o
	   (bu trans <<a>, <a, b>, <a, b, c>, <<>>, <<a>>, <<a>, <b>>>) o
	   aa apndr o
	     _<<<>, a>, <<a>, b>, <<a, b>, c>, <<>, <>>, <<>, <a>>,
	       <<<a>>, <b>>>

Def testatom \/and o aa = o
	   (bu trans <T, T, T, T, T, T, T, F, F, F, F>) o
	   aa atom o
	    _<T, F, <>, 1, 1.0, a, 'a, "string", <vector>,
	      <"vector">, <v, e, c, t, o, r>>

Def testdistl \/and o aa = o
	   (bu trans <<>, <<a, 1>>, <<b, 1>, <b, 2>>, <<<>, 1>,
		      <<>, 2>, <<>, 3>>>) o
	   aa distl o _<<x, <>>, <a, <1>>, <b, <1, 2>>, <<>, <1, 2, 3>>>

Def testdistr \/and o aa = o
	   (bu trans <<>, <<a, 1>>, <<a, 2>, <b, 2>>,
		      <<a, <>>, <b, <>>, <c, <>>>>) o
	   aa distr o _<<<>, x>, <<a>, 1>, <<a, b>, 2>, <<a, b, c>, <>>>

Def testdiv \/and o aa = o
	   (bu trans
		<1,   1,   0,   2,   -12,   -3,    6,
	 	 1.0, 1.0, 0.5, 2.0, -8.75, -17.5, 6.25>) o
	   aa div o
	   _<<1, 1>, <10, 10>, <1, 2>, <2, 1>, <35, -3>, <-35, 17>, <-27, -4>,
	     <1, 1.0>, <10.0, 10>, <1.0, 2.0>, <2.0, 1>, <35, -4.0>,
	     <-35.0, 2.0>, <-25.0, -4.0>>

Def testeq \/and o aa = o
	   (bu trans
	    <T, F, F, F, T, F, F, F, F, F,
	     T, F, F, F, F, F, F, F, F,
	     T, F, F, F, F, F, F, F, F,
	     T, F, T, F, F, F, F, F, F, F,
	     T, F, F, F, F, F, F,
	     T, F, F, F, F, F, F,
	     T, F, F, F, F, F, F,
	     T, F, F, F, F, F, F, F, F,
	     T, F>) o aa = o
	   _<<1, 1>, <1, 0>, <1, a>, <1, 'a>, <1, 1.0>, <1, 0.99>,
		<1, <>>, <1, T>, <1, F>, <1, <1>>,
	     <a, a>, <a, b>, <a, 1>, <a, 'a>, <a, 1.0>, <a, <>>,
		<a, T>, <a, F>, <a, <a>>,
	     <'a, 'a>, <'a, 'b>, <'a, 1>, <'a, a>, <'a, 1.0>,
		<'a, <>>, <'a, T>, <'a, F>, <'a, <'a>>,
	     <1.0, 1.0>, <1.0, 2.0>, <1.0, 1>, <1.1, 1>, <1.0, 'a>,
		<1.0, a>, <1.0, <>>, <1.0, T>, <1.0, F>, <1.0, <1.0>>,
	     <T, T>, <T, 1>, <T, 'T>, <T, 1.0>, <T, <>>, <T, F>, <T, <T>>,
	     <F, F>, <F, 1>, <F, 'F>, <F, 1.0>, <F, <>>, <F, T>, <F, <F>>,
	     <<>, <>>, <<>, 1>, <<>, 'F>, <<>, 1.0>, <<>, T>, <<>, F>,
		<<>, <<>>>,
	     <<a>, <a>>, <<a>, <b>>, <<a>, 1>, <<a>, 'a>, <<a>, 1.0>,
		<<a>, <>>, <<a>, T>, <<a>, F>, <<a>, <<a>>>,
	     <<a, <b>, <c, <d>>, e>, <a, <b>, <c, <d>>, e>>,
	     <<a, <b>, <c, <d>>, e>, <a, <b>, <c, <f>>, e>>>

# only test geq on atoms, chars and numbers. Particular implementations
# may have it defined for other values as well, but that is not portable
Def testgeq \/and o aa = o
	   (bu trans <T, T, F, T, T, F, T, T, F, T, T, F, T, T, F, T, T, F>) o
	   aa >= o
	   _<<1, 0>, <1, 1>, <1, 2>,
	     <1.0, 0.99>, <1.0, 1.0>, <1.0, 1.01>,
	     <1, 0.99>, <1, 1.0>, <1, 1.01>,
	     <1.01, 1>, <1.0, 1>, <0.99, 1>,
	     <m, a>, <m, m>, <m, z>,
	     <'m, 'a>, <'m, 'm>, <'m, 'z>>

Def testgreater \/and o aa = o
	   (bu trans <T, F, F, T, F, F, T, F, F, T, F, F, T, F, F, T, F, F>) o
	   aa > o
	   _<<1, 0>, <1, 1>, <1, 2>,
	     <1.0, 0.99>, <1.0, 1.0>, <1.0, 1.01>,
	     <1, 0.99>, <1, 1.0>, <1, 1.01>,
	     <1.01, 1>, <1.0, 1>, <0.99, 1>,
	     <m, a>, <m, m>, <m, z>,
	     <'m, 'a>, <'m, 'm>, <'m, 'z>>

Def testid \/and o aa = o
	   (bu trans <1, a, 'a, 1.0, T, F, <>, "id", <id, 1, x>>) o
	   aa id o  _<1, a, 'a, 1.0, T, F, <>, "id", <id, 1, x>>

Def testiota \/and o aa = o
	   (bu trans <<>, <1>, <1, 2>, <1, 2, 3, 4, 5, 6, 7, 8, 9, 10>>) o
	   aa iota o _<0, 1, 2, 10>

Def testlength \/and o aa = o
	   (bu trans <0, 1, 1, 2, 3, 4, 10>) o
	   aa length o
	   _<<>, <1>, <<<>>>, <<a, b, c>, <d, e>>, "xyz", "four", "lenght ten">

Def testleq \/and o aa = o
	   (bu trans <F, T, T, F, T, T, F, T, T, F, T, T, F, T, T, F, T, T>) o
	   aa <= o
	   _<<1, 0>, <1, 1>, <1, 2>,
	     <1.0, 0.99>, <1.0, 1.0>, <1.0, 1.01>,
	     <1, 0.99>, <1, 1.0>, <1, 1.01>,
	     <1.01, 1>, <1.0, 1>, <0.99, 1>,
	     <m, a>, <m, m>, <m, z>,
	     <'m, 'a>, <'m, 'm>, <'m, 'z>>

Def testless \/and o aa = o
	   (bu trans <F, F, T, F, F, T, F, F, T, F, F, T, F, F, T, F, F, T>) o
	   aa < o
	   _<<1, 0>, <1, 1>, <1, 2>,
	     <1.0, 0.99>, <1.0, 1.0>, <1.0, 1.01>,
	     <1, 0.99>, <1, 1.0>, <1, 1.01>,
	     <1.01, 1>, <1.0, 1>, <0.99, 1>,
	     <m, a>, <m, m>, <m, z>,
	     <'m, 'a>, <'m, 'm>, <'m, 'z>>

Def testminus \/and o aa = o
	   (bu trans <1, -1, 0, 11, -5, 3, -5>) o
	   aa - o
	   _<<1, 0>, <0, 1>, <1, 1>, <7, -4>, <-3, 2>, <-5, -8>, <-8, -3>>

Def testmod \/and o aa = o
	   (bu trans <0, 0, 1, 0, 1, 16, 3>) o
	   aa mod o
	   _<<1, 1>, <10, 10>, <1, 2>, <2, 1>, <35, -3>, <-35, 17>, <-27, -4>>

Def testneg \/and o aa = o (bu trans <0, 0, 1, -1.0, 15.2, -17>) o
	   aa neg o _<0, -0, -1, 1.0, -15.2, 17>

Def testnot \/and o aa = o (bu trans <T, F>) o aa not o _<F, T>

Def testnoteq \/and o aa = o
	   (bu trans
	    <F, T, T, T, F, T, T, T, T, T,
	     F, T, T, T, T, T, T, T, T,
	     F, T, T, T, T, T, T, T, T,
	     F, T, F, T, T, T, T, T, T, T,
	     F, T, T, T, T, T, T,
	     F, T, T, T, T, T, T,
	     F, T, T, T, T, T, T,
	     F, T, T, T, T, T, T, T, T,
	     F, T>) o aa != o
	   _<<1, 1>, <1, 0>, <1, a>, <1, 'a>, <1, 1.0>, <1, 0.99>,
		<1, <>>, <1, T>, <1, F>, <1, <1>>,
	     <a, a>, <a, b>, <a, 1>, <a, 'a>, <a, 1.0>, <a, <>>,
		<a, T>, <a, F>, <a, <a>>,
	     <'a, 'a>, <'a, 'b>, <'a, 1>, <'a, a>, <'a, 1.0>, <'a, <>>,
		<'a, T>, <'a, F>, <'a, <'a>>,
	     <1.0, 1.0>, <1.0, 2.0>, <1.0, 1>, <1.1, 1>, <1.0, 'a>, <1.0, a>,
		<1.0, <>>, <1.0, T>, <1.0, F>, <1.0, <1.0>>,
	     <T, T>, <T, 1>, <T, 'T>, <T, 1.0>, <T, <>>, <T, F>, <T, <T>>,
	     <F, F>, <F, 1>, <F, 'F>, <F, 1.0>, <F, <>>, <F, T>, <F, <F>>,
	     <<>, <>>, <<>, 1>, <<>, 'F>, <<>, 1.0>, <<>, T>, <<>, F>,
		<<>, <<>>>,
	     <<a>, <a>>, <<a>, <b>>, <<a>, 1>, <<a>, 'a>, <<a>, 1.0>,
		<<a>, <>>, <<a>, T>, <<a>, F>, <<a>, <<a>>>,
	     <<a, <b>, <c, <d>>, e>, <a, <b>, <c, <d>>, e>>,
	     <<a, <b>, <c, <d>>, e>, <a, <b>, <c, <f>>, e>>>

Def testnull \/and o aa = o
	   (bu trans <T, F, F, F, F, F, F, T, F, F, F>) o
	   aa null o _<<>, 0, 1, a, '0, T, F, "", "nil", <nil>,
		       <m, <o, n>, <<s>, t, e>, r>>

Def testor \/and o aa = o
	   (bu trans <F, T, T, T>) o aa or o _<<F, F>, <F, T>, <T, F>, <T, T>>

Def testplus \/and o aa = o
	   (bu trans <0, 2, 1, 1, -2, 3, -9>) o
	   aa + o _<<0, 0>, <1, 1>, <1, 0>, <0, 1>, <1, -3>, <-5, 8>, <-4, -5>>

Def testreverse \/and o aa = o
	   (bu trans
	       <<>, <a>, <b, a>, <4, 3, 2, 1>, <<e, f>, <c, d>, <a, b>>>) o
	   aa reverse o
	   _<<>, <a>, <a, b>, <1, 2, 3, 4>, <<a, b>, <c, d>, <e, f>>>

Def testrotl \/and o aa = o
	   (bu trans
	       <<>, <a>, <b, a>, <2, 3, 4, 5, 1>, <<r, s>, <t, u>, <p, q>>>) o
	   aa rotl o
	   _<<>, <a>, <a, b>, <1, 2, 3, 4, 5>, <<p, q>, <r, s>, <t, u>>>

Def testrotr \/and o aa = o
	   (bu trans
	       <<>, <a>, <b, a>, <5, 1, 2, 3, 4>, <<t, u>, <p, q>, <r, s>>>) o
	   aa rotr o
	   _<<>, <a>, <a, b>, <1, 2, 3, 4, 5>, <<p, q>, <r, s>, <t, u>>>

Def testtimes \/and o aa = o
	   (bu trans <0, 0, 0, 9, -2, -4, 6, 6, 28, -18, -10>) o
	   aa * o
	   _<<0, 0>, <0, 5>, <1, 0>, <1, 9>, <1, -2>, <-1, 4>, <-1, -6>,
	     <-2, -3>, <4, 7>, <-6, 3>, <5, -2>>

Def testtl \/and o aa = o
	   (bu trans <<>, <a>, <a, b, c>, <<>>, <<a>>, <<a>, <b>>>) o
	   aa tl o
	   _<<a>, <1, a>, <z, a, b, c>, <a, <>>, <x, <a>>, <<x>, <a>, <b>>>

Def testtlr \/and o aa = o
	   (bu trans <<>, <a>, <a, b, c>, <<>>, <<a>>, <<a>, <b>>>) o
	   aa tlr o
	   _<<a>, <a, b>, <a, b, c, d>, <<>, a>, <<a>, x>, <<a>, <b>, <c>>>

Def testtrans \/and o aa = o
	   (bu trans
	    <<>, <>, <>,
	     <<a>, <b>, <c>, <d>, <e>, <f>>, <<1, 2, 3, 4, 5>>,
	     <<a, c>, <b, d>>, <<a, 1, x>, <b, 2, y>, <c, 3, z>>,
	     <<a, 1, l>, <b, 2, m>, <c, 3, n>, <d, 4, o>, <e, 5, p>>>) o
	   aa trans o
	   _<<<>>, <<>, <>>, <<>, <>, <>, <>, <>>,
	     <<a, b, c, d, e, f>>, <<1>, <2>, <3>, <4>, <5>>,
	     <<a, b>, <c, d>>, <<a, b, c>, <1, 2, 3>, <x, y, z>>,
	     <<a, b, c, d, e>, <1, 2, 3, 4, 5>, <l, m, n, o, p>>>
