# nqueens.fp: gives all solutions for placing n queens on an nxn
# chessboard in such a way that they do not threaten each other
# Typical call:
# nqueens 8

# nqueens : n => board printout, or nil
Def nqueens prtboards o nmqueens o [id, id]

# nmqueens : <n, m> => list of n safe row positions for n queens on an
# n-column by m-row chessboard. Precondition: n <= m
# e.g., nmqueens : <2, 3> => <<1, 3>, <3, 1>>
Def nmqueens (bu = 1) o 1 -> aa [id] o iota o 2;
	     append o aa (null -> id; [id]) o aa safe o
		append o aa distl o distr o
		[iota o 2, nmqueens o [(bur - 1) o 1, 2]]

# safe : <row, rowpositions> => <row | rowpositions> if safe, <> otherwise
# e.g. safe : <3, <1, 4, 7>> => <3, 1, 4, 7>, safe : <3, <4, 1, 7>> => <>
Def safe \/and o aa saferow o aa apndl o pairpos o distl -> apndl ; _<>

# pairpos : <x1..xn> ==> <<1 x1>..<n xn>>
Def pairpos null -> _<>; trans o [iota o length, id]

# saferow : <col, row@col1, row@col> => whether a queen placed at
# (row@col1, 1) is safe from one at (row@col, col)
Def saferow \/and o aa != o [tl, [1, - o tl], [1, neg o - o tl]]

# prtboards : <rowlist1..rowlistn> => board1 ++ newline ++ .. ++ boardn
Def prtboards null -> _"no solution found"; mergelines o aa prtboard

# prtboard : <row1..rown> => printed form of the board, where Q represents
# a position, _ a blank, and rows are terminated by newlines. e.g.
# prtboard: <1, 3, 2> => "Q__\n__Q\n_Q_\n", where \n represents new line.
Def prtboard mergelines o trans o aa prtcol o distr o [id, length]

# prtcol : <row size> => printed form of the column containing the given row
Def prtcol aa (= -> _'Q; _'_) o distl o [1, iota o 2]

# mergelines: <str1..strn> => str, where str is the concatenation of the
# stri's separated by newlines
Def mergelines append o aa (append o [id, newline])
