# A store is a place you can keep objects in and retrieve them
# by key. A key should be an atom or a number -- later on
# this may be extended.
# newstore:x gives a (new) empty store
# store:<<key value> store> stores the given value under key, possibly
#	replacing a previous value with the same key
# retrieve:<key store> returns the pair <key value> associated with
#	the given key, or <> if the key is not in the store
# unstore:<key store> removes the value with given key, if any.
# allstored:store returns a list of pairs <key value>, one pair/key
# storesize:store returns the number of values in the store
# haskey:<key store> returns whether some value with the given key
#	is in the store.
# current implementation: a store is a tree of <key value left right>
# where left and right are also trees.
# invariant: all keys in left are < than key, all keys in right are >
# than key.
# no kind of tree balancing is done for now

Def newstore _<>

Def store null o 2 -> [1 o 1, 2 o 1, _<>, _<>];
	  = o [1 o 1, 1 o 2] -> [1 o 2, 2 o 1, 3 o 2, 4 o 2];
	  < o [1 o 1, 1 o 2] ->
		[1 o 2, 2 o 2, store o [1, 3 o 2], 4 o 2];
	  [1 o 2, 2 o 2, 3 o 2, store o [1, 4 o 2]]

Def retrieve null o 2 -> _<>;
	     = o [1, 1 o 2] -> [1, 2 o 2];
	     < o [1, 1 o 2] -> retrieve o [1, 3 o 2];
	     retrieve o [1, 4 o 2]

Def unstore haskey -> unstaux; 2
#unstaux is like unstore except it doesn't check for presence of key
Def unstaux = o [1, 1 o 2] -> unstlift o 2;
	    < o [1, 1 o 2] -> [1 o 2, 2 o 2, unstaux o [1, 3 o 2], 4 o 2];
	    [1 o 2, 2 o 2, 3 o 2, unstaux o [1, 4 o 2]]
# unstlift replaces each node with its left subtree, recursively
Def unstlift null o 3 -> 4;	# we're at the end of left chaining.
	     [1 o 3, 2 o 3, unstlift o 3, 4]

Def allstored null -> id; apndl o [[1, 2], append o aa allstored o [3, 4]]

Def storesize null -> _0; (bu + 1) o + o aa storesize o [3, 4]

Def haskey null o 2 -> _F;
	   = o [1, 1 o 2] -> _T;
	   < o [1, 1 o 2] -> haskey o [1, 3 o 2];
			     haskey o [1, 4 o 2]

Def tststore [id, (\/and o aa = )] o
             [[haskey o [_1, store o [_<1, garble>, newstore]], _T],
              [haskey o [_1, store o [_<2, garble>, newstore]], _F],
              [retrieve o [_1, store o [_<2, garble>,
			       store o [_<3, foo>, newstore]]], _<>],
              [retrieve o [_2, store o [_<2, garble>, newstore]], _<2, garble>],
              [retrieve o [_1, store o [_<2, garble>,
			       store o [_<1, foo>, newstore]]], _<1, foo>],
              [retrieve o [_2, store o [_<2, garble>,
			       store o [_<1, foo>, newstore]]], _<2, garble>],
              [retrieve o [_1, store o [_<1, foo>,
			       store o [_<2, garble>, newstore]]], _<1, foo>],
              [retrieve o [_2, store o [_<2, garble>,
			       store o [_<1, foo>, newstore]]], _<2, garble>],
              [allstored o store o [_<2, garble>, newstore], _<<2, garble>>],
              [allstored o newstore, _<>],
              [or, _T] o [(bu = <<a, b>, <c, d>>), (bu = <<c, d>, <a, b>>)] o
               allstored o store o [_<a, b>, store o [_<c, d>, newstore]],
	      [storesize o newstore, _0],
	      [storesize o store o [_<1, useless>, newstore], _1],
              [storesize o store o [_<a, b>, store o [_<c, d>, newstore]], _2],
              [storesize o unstore o [_a, store o [_<c, d>, newstore]], _1],
              [storesize o unstore o [_a, store o [_<a, b>, newstore]], _0],
              [allstored o unstore o [_a, store o [_<a, b>,
					  store o [_<c, d>, newstore]]],
	       _<<c, d>>],
              [allstored o unstore o [_c, store o [_<a, b>,
					  store o [_<c, d>, newstore]]],
	       _<<a, b>>],
              [allstored o unstore o [_c, store o [_<c, d>, newstore]], _<>],
              [allstored o unstore o [_a, store o [_<c, d>, newstore]],
	       _<<c, d>>]
             ]
