%start FPProgram
%token Def Symbol Sel Rsel Then Else Compose Alpha Insert Rinsert Tree
%token Bu Bur While
%token ',' '[' ']' '(' ')' '<' '>' '_' '+' '-' '*' '='
%token Div Geq Leq Noteq TrueConst FalseConst String CharConst Float
%%

FPProgram: FPDef
         | FPProgram FPDef
	 ;

FPDef: Def
       Symbol { parsefnstart (yytext); }
       Toplev { parsefnend (); }
     ;

Toplev: Comp
	Then
	{ parsethen (); }
	Toplev
	Else
	{ parseelse (); }
	Toplev
	{ parseendif (); }
      | Bu
	{ parsebustart (0); }
	Toplev
	{ parsebufun (); }
	Object
	{ parsebuobj (); }
      | Bur
	{ parsebustart (1); }
	Toplev
	{ parsebufun (); }
	Object
	{ parsebuobj (); }
      | While
	{ whilestart (); }
	Toplev
	{ whilepred (); }
	Toplev
	{ whilefun (); }
      | Comp
      ;

Comp: Expr
    | Expr
      Compose
      { parsecomp (); }
      Comp
    ;

Expr: '('
      { startcomp (); }
      Toplev
      { endcomp (); }
      ')'
    | Alpha
      Expr
      { parseaa (); }
    | '[' ']'
      { parsenil (); }
    | '['
      { parseconstr (); }
      ToplevList
      ']'
      { constrnext (); endconstr (); }
    | Insert
      { parseinsert (0); }
      Expr
      { endinsert (); }
    | Rinsert
      { parseinsert (1); }
      Expr
      { endinsert (); }
    | Tree
      { parseinsert (2); }
      Expr
      { endinsert (); }
    | '_' Object
    | Sel
      { parsesel (yytext, 0); }
    | Rsel
      { parsesel (yytext, 1); }
    | Symbol
      { parsefncall (yytext); }
    | '+'
      { parsefncall ("plus"); }
    | '-'
      { parsefncall ("minus"); }
    | '*'
      { parsefncall ("times"); }
    | Div
      { parsefncall ("div"); }
    | '='
      { parsefncall ("eq"); }
    | '<'
      { parsefncall ("less"); }
    | '>'
      { parsefncall ("greater"); }
    | Geq
      { parsefncall ("gequal"); }
    | Leq
      { parsefncall ("lequal"); }
    | Noteq
      { parsefncall ("notequal"); }
    ;

ToplevList: Toplev
	  | ToplevList ','
	    { constrnext (); }
	    Toplev

Object: TrueConst
	{ consttrue (); }
      | FalseConst
	{ constfalse (); }
      | Sel
	{ constnum (yytext); }
      | Symbol
	{ constsym (yytext); }
      | String
	{ conststr (yytext); }
      | CharConst
	{ constchr (yytext); }
      | Float
	{ constreal (yytext); }
      | '<' '>'
        { parsenil (); }
      | '<'
	{ liststart (); }
	ObjList
	'>'
	{ listend (); }
      | Def
	{ constsym ("Def"); }
      | Alpha
	{ constsym ("aa"); }
      | Compose
	{ constsym ("o"); }
      | Div
	{ constsym ("div"); }
      | Bu
	{ constsym ("bu"); }
      | Bur
	{ constsym ("bur"); }
      | While
	{ constsym ("while"); }
      ;

ObjList: Object
	 { listnext (); }
       | ObjList ','
	 Object
	 { listnext (); }

%%

#include "lex.yy.c"

#undef YYMAXDEPTH
#define YYMAXDEPTH 2048

void parsefnstart ();
void parsefnend ();
void parsethen ();
void parseelse ();
void parseendif ();
void parsebustart ();
void parsebufun ();
void parsebuobj ();
void whilestart ();
void whilepred ();
void whilefun ();
void parsecomp ();
void startcomp ();
void endcomp ();
void parseaa ();
void parseconstr ();
void constrnext ();
void endconstr ();
void parseinsert ();
void endinsert ();
void parsesel ();
void parsefncall ();
void parsenil ();
void consttrue ();
void constfalse ();
void constnum ();
void constsym ();
void conststr ();
void constchr ();
void constreal ();
void liststart ();
void listnext ();
void listend ();

