/* fpc.h: defines some constants for array declarations */

#ifndef MAXIDS
#define MAXIDS	256	/* the maximum number of identifiers in a table */
#endif

#ifndef MAXIDLEN
#define MAXIDLEN 64	/* max. number of characters in an identifier */
#endif

/* here comes all the "exported" stuff, mostly flags showing which
   switches were given on the command line */
extern FILE * outf;

extern int makemain;	/* -m: make main calling the file name */
extern char mainfn [MAXIDLEN];	/* -mfname: the main function, if any */

extern int verbose;	/* -v: print fpc version, functions being done */

extern int rstring;	/* -i: read input as string, not fp object */
extern int wstring;	/* -o: write output as string, not fp object */
extern int redirout;	/* -c: output is of form: <<file data>*> */
extern int makeast;	/* -a: The main function is used in an AST system */
extern int useparms;	/* -p: if program has parms, input is <> */

extern int makedeb;	/* -d: trace all functions during execution */
extern int makeee;	/* -e: print functions being called/returned */
extern int check;	/* -n: check for illegal arguments */
extern int printspace;	/* -s: print how much space was used and returned */

extern char tracefns [MAXIDS] [MAXIDLEN]; /* the functions to be traced (-t) */
extern int traceptr;	/* the first free slot */

/* end of the exported variables */
