/* fp.h: header file for all fp programs translated to C using fpc.
 *	declares types, defines, some externs
 */

#include "stdfp.h"

/* #define MAXINT	0x7FFF		/* for 16-bit fp_ints */
#define MAXINT		0x7FFFFFFF	/* for 32-bit fp_ints */
/* #define MAXINT	0x7FFFFFFFFFFFFFFF	/* for 64-bit fp_ints */

#define FNAMELEN	256	/* on UNIX, file names are under 256 chars */

/* this type is just for determining the size of a constant object */
struct fp_const_size
  {
    short fp_const_type;
    short fp_const_ref;
    union {int fp_const_constant;
           char * fp_const_atom; }
		fp_const_header;
  };

struct fp_atom
{
  short fp_type;
  short fp_ref;
  char * fp_atom;
};

/* these values are used by the storage manager */
#define CONSTSIZE	(sizeof (struct fp_const_size))
#define VECTSIZE	(sizeof (struct fp_object))

#define fp_nil		(& nilobj)
#define fp_true		(& tobj)
#define fp_false	(& fobj)

extern struct fp_object nilobj;
extern struct fp_object tobj;
extern struct fp_object fobj;
