// Class interval
//	A definition of intervals for interval arithmetic.
//
//	The representation of the interval is two doubles
//	but conversion operators are defined for int and float.
//
//	Error handling is weak.  In an IEEE compliant implementation,
//	quiet NANs could be used to indicate bounds that were
//	invalid.  Otherwise, more state (and checking) would
//	need to be added.

// To get the definition of MAXDOUBLE
#include <values.h>

class interval {
    double lo_bound, hi_bound;
public:
    double lo(void)		{ return lo_bound; }
    double hi(void)		{ return hi_bound; }
    double width(void)		{ return hi_bound - lo_bound; }
    interval()			{ lo_bound = -MAXDOUBLE; hi_bound = MAXDOUBLE; }
    interval(double l, double h){ lo_bound = l<h?l:h; hi_bound = l<h?h:l; }
    interval(double f)		{ lo_bound = f; hi_bound = f; }
    interval(float l, float h)	{ lo_bound = l<h?l:h; hi_bound = l<h?h:l; }
    interval(float f)		{ lo_bound = f; hi_bound = f; }
    interval(int l, int h)	{ lo_bound = l<h?l:h; hi_bound = l<h?h:l; }
    interval(int i)		{ lo_bound = i; hi_bound = i; }
    interval operator+(interval I);
    interval operator-(interval I);
    interval operator*(interval I);
    interval operator/(interval I);
    interval &operator+=(interval I);
    interval &operator-=(interval I);
    interval &operator*=(interval I);
    interval &operator/=(interval I);
    int contains(interval I)	{ return lo_bound <= I.lo_bound && 
					 hi_bound >= I.hi_bound; }
    int overlaps(interval I)	{ return lo_bound <= I.hi_bound && 
					 hi_bound >= I.lo_bound; }
    int equal(interval I)	{ return lo_bound == I.lo_bound && 
					 hi_bound == I.hi_bound; }
};
