// A simple test program for the interval class

#include <CC/stdio.h>
#include <CC/string.h>
#include "interval.h"

void Usage(char *name)
{
    fprintf(stderr, "usage: %s real real +|-|*|/ real real\n", name);
}

main(int argc, char **argv)
{
    float a,b,c,d;

    if (argc != 6) {
	Usage(argv[0]);
	exit(1);
    }

    a = atof(argv[1]);
    b = atof(argv[2]);
    c = atof(argv[4]);
    d = atof(argv[5]);
    {
	interval I1(a,b);
	interval I2(c,d);
	interval Result, Result2;

	switch (argv[3][0]) {
	case '+': Result = I1 + I2; break;
	case '-': Result = I1 - I2; break;
	case '*': Result = I1 * I2; break;
	case '/': Result = I1 / I2; break;
	default: 
	    Usage(argv[0]);
	    exit(2);
	}

	printf("[%f, %f] %s [%f, %f] == [%f, %f]\n", 
		I1.lo(), I1.hi(), argv[3], I2.lo(), I2.hi(), 
		Result.lo(), Result.hi());

	// Now check out += and integer-to-interval conversion
	Result2 = Result;
	Result2 += 4;
	printf("[%f, %f] + 4 == [%f, %f]\n", 
		Result.lo(), Result.hi(), Result2.lo(), Result2.hi());
    }
}
