/*
 * settime - change the access and modification times of files
 * Usage: settime [-amv] [-f file] [time] file...
 * Options:
 * -a		only change access time
 * -m		only change modification time
 * -v		(verbose) display time being set
 * -f file	set time to time of file
 * 
 * Exit status = number of files that couldn't be set.
 *
 * Latest revision: 08/05/88
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

int     verbose = 0;		/* Show time being set? */
int     seta = 0;		/* Change access time? */
int     setm = 0;		/* Change modification time? */

main(argc, argv)
    int     argc;
    char  **argv;
{
    char   *ctime();
    time_t  unctime();
    extern int optind;
    extern char *optarg;
    time_t  newatime;		/* Value to set access time to. */
    time_t  newmtime;		/* Value to set modification time to. */
    struct stat statbuf;
    char   *fromfile = NULL;	/* Filename to set from. */
    int     nerrs = 0;
    int     c;			/* Option character. */

    while ((c = getopt(argc, argv, "amvf:")) != EOF)
	switch (c) {
	case 'a':
	    seta = 1;
	    break;
	case 'f':
	    fromfile = optarg;
	    break;
	case 'm':
	    setm = 1;
	    break;
	case 'v':
	    verbose = 1;
	    break;
	default:
	    usage(argv[0]);
	}

    if (seta + setm == 0)
	seta = setm = 1;

    if (optind == argc)
	usage(argv[0]);

    if (fromfile) {
	if (stat(fromfile, &statbuf)) {
	    perror(fromfile);
	    exit(1);
	}
	newatime = statbuf.st_atime;
	newmtime = statbuf.st_mtime;
    } else if (optind == argc - 1) {
	usage(argv[0]);
    } else {
	newatime = newmtime = unctime(argv[optind++]);
	if (newatime == (time_t) - 1) {
	    fprintf(stderr, "%s: bad time\n", argv[0]);
	    exit(1);
	}
    }

    if (verbose) {
	if (seta)
	    printf("Setting access time to       %s", ctime(&newatime));
	if (setm)
	    printf("Setting modification time to %s", ctime(&newmtime));
    }
    for (; optind < argc; ++optind)
	if (settm(argv[optind], newatime, newmtime)) {
	    perror(argv[optind]);
	    ++nerrs;
	}
    exit(nerrs);
}

/*
 * Return 1 if fail, 0 if ok.
 */
settm(file, newa, newm)
    char   *file;
    time_t  newa,
            newm;
{
    time_t  utimebuf[2];	/* [0] = accessed, [1] = modified. */
    struct stat statbuf;

    utimebuf[0] = newa;
    utimebuf[1] = newm;

    if (seta == 0 || setm == 0) {
	if (stat(file, &statbuf) == -1)
	    return 1;
	if (seta == 0)
	    utimebuf[0] = statbuf.st_atime;
	if (setm == 0)
	    utimebuf[1] = statbuf.st_mtime;
    }
    return utime(file, utimebuf);
}

usage(f)
    char   *f;
{
    fprintf(stderr, "Usage: %s [-amv] [-f file] [time] file...\n", f);
    exit(1);
}
