/* untri - convert ANSI C trigraph sequences to single characters.
 *         currently implemented as a filter, but a rewritten main
 *         could allow a more sophisticated interface.
 *
 *  This source donated to the public domain by John P. Nelson 1988
 */

#include <stdio.h>
#include <strings.h>

char *trichar = "=(/)'<!>-";
char *translate = "#[\\]^{|}~";
main()
    {
    process(stdin, stdout);
    }

/*
 * Note:  I used a goto in this function, because we are essentially
 *     performing a two character lookahead, but unputc is only guaranteed
 *     to be able to push back one character.  Otherwise, the goto would be
 *     unnecessary.
 */
process(in, out)
FILE *in, *out;
    {
    int c;
    char *ptr;

    while ((c = getchar(in)) != EOF)
	{
reprocess:
	if (c == '?')
	    {
	    if ((c = getc(in)) != '?')
		{
		if (c != EOF)
		    ungetc(c, in);
		putc('?', out);
		continue;
		}
	    c = getc(in);
	    if (c != EOF)
		{
		if (ptr = strchr(trichar, c))
		    {
		    /* yup, it's a trigraph */
		    putc(translate[ptr - trichar], out);
		    continue;
		    }
		ungetc(c, in);
		}
	    putc('?', out);
	    c = '?';
	    /* ungetc('?', in); continue; */
	    goto reprocess;
	    }
	putc(c, out);
	}
    }
