#include "modemcap.h"
#ifdef	UNIX_S5
#include <termio.h>
#endif
#ifdef	UNIX_V7
#include <sgtty.h>
#endif

extern	int	merrno;

hangup (fd)
int	fd;
{
#ifdef	UNIX_S5
	struct	termio	termio;
	struct	termio	hupcl;
#endif
#ifdef	UNIX_V7
	struct	sgttyb	termio;
	struct	sgttyb	hupcl;
#endif
	if (HU == (char *) 0 && HC == 0) {
		undial (fd);
		return (0);
	}
	if (AT != (char *) 0) {
		write (fd, AT, strlen (AT));
		if (AD)
			sleep (AD);
	}
	if (HU) {
		if (CS)
			write (fd, CS, strlen (CS));
		write (fd, HU, strlen (HU));
		if (CE)
			write (fd, CE, strlen (CE));

		if (IS) {
			write (fd, IS, strlen (IS));
			if (ID)
				sleep (ID);
		}
		undial (fd);
		return (1);
	}
#ifdef	UNIX_S5
	ioctl (fd, TCGETA, &termio);
	ioctl (fd, TCGETA, &hupcl);
	
	hupcl.c_cflag &= ~CBAUD;
	hupcl.c_cflag |= HUPCL;

	ioctl (fd, TCSETA, &hupcl);
	sleep (2);
	ioctl (fd, TCSETA, &termio);
#endif
#ifdef	UNIX_V7
	gtty (fd, &termio);
	gtty (fd, &hupcl);

	hupcl.sg_ispeed = B0;
	hupcl.sg_ospeed = B0;
	stty (fd, &hupcl);
	sleep (2);
	stty (fd, &termio);
#endif
	undial (fd);
	return (1);
}
