#include <fcntl.h>
#include <dial.h>
#include <signal.h>
#include <stdio.h>
#include "modemcap.h"

#ifdef	UNIX_V7
typedef	int	void;
#endif
static	char	lockfile[64];
static	int	modemfd = -1;
extern	int	merrno;

static	findline (line, baud)
char	*line;
int	baud;
{
	int	exists = 0;
	int	l_baud;
	char	l_line[DVC_LEN+1];
	char	l_type[DVC_LEN+1];
	char	buf[64];
	FILE	*fp;

	if ((fp = fopen (LDEVS, "r")) == NULL)
		return (merrno = NO_Ldv);

	while (fgets (buf, 64, fp) != NULL) {
		if (buf[0] == '#')		/* ignore comment lines			*/
			continue;

		if (sscanf (buf, "%s%s%*s%d", l_type, l_line, &l_baud) != 3)
			continue;		/* mangled line				*/

		if (strcmp (l_type, "DIR") != 0)
			continue;		/* not a direct connect line		*/

		if (strcmp (l_line, line) == 0)
			exists++;		/* say device exists at some baud rate	*/
		else
			continue;		/* wrong device				*/

		if (l_baud == baud) {		/* found device at desired baud rate	*/
			fclose (fp);
			return (1);
		}
	}
	if (exists)
		return (merrno = ILL_BD);
	else
		return (merrno = DV_NT_K);
}

static	char	*findmodem (line)
{
	static	char	modemtype[16];
	char	device[DVC_LEN + 1];
	char	buf[82];
	FILE	*fp;

	if ((fp = fopen (_MODEMTYPE_, "r")) == NULL)
		return (NULL);

	while (fgets (buf, 82, fp) != NULL) {
		if (buf[0] == '#')
			continue;

		sscanf (buf, "%s%s\n", modemtype, device);
		if (strcmp (line, device) == 0) {
			fclose (fp);
			return (modemtype);
		}
	}
	fclose (fp);
	return (NULL);
}

struct speedlist {
	int	value;
	int	name;
} speeds[] = {
	{    0,     0},
	{  110,  B110},
	{  300,  B300},
	{  600,  B600},
	{ 1200, B1200},
	{ 2400, B2400},
	{ 4800, B4800},
	{ 9600, B9600},
	{19200, EXTA},
	{38400, EXTB},
	{   -1, -1}
};

static	findspeed (speed)
int	speed;
{
	register struct	speedlist *ps;

	for (ps = speeds; ps->value >= 0; ps++)
		if (ps->value == speed)
			return (ps->name);

	return (0);
}

alarmcatch ()
{
	long	timebuf[2];

	time (&timebuf[0]);
	timebuf[1] = timebuf[0];

	utime (lockfile, timebuf);
	signal (SIGALRM, alarmcatch);
	alarm (3600);
}

hupcatch ()
{
	close (modemfd);
	unlink (lockfile);
	signal (SIGHUP, SIG_DFL);
}

int	dial (call)
CALL	*call;
{
	char	modemline[64];			/* device name				*/
	char	*modemname;			/* modemcap name of modem		*/
	char	*strcpy (),
		*strcat ();
#ifdef	UNIX_S5
	struct	termio	termio;
#endif
#ifdef	UNIX_V7
	struct	sgttyb	termio;
#endif
	int	fd;
	int	err;

	strcat (strcpy (modemline, DEVDIR), call->line);
	strcat (strcpy (lockfile, LOCK), call->line);

	/*
	 * FIX - Version 7 does not have three operand open(), write
	 * conditional compilation for this here ...
	 */

	if (access (lockfile, 0) == 0 || (fd = creat (lockfile, 0)) == -1)
		return (merrno = DV_NT_A);	/* lock existed or couldn't be created	*/
	else
		close (fd);			/* created lock, now close descriptor	*/

	fd = -1;				/* channel illegal until line is opened	*/

	if ((err = findline (call->line, call->baud)) <= 0)
		goto error;

	if ((modemname = findmodem (call->line)) == NULL) { /* can't determine the type of modem	*/
		err = DV_NT_K;
		goto error;
	}
	if ((fd = open (modemline, O_RDWR)) < 0) { /* can't open modem line		*/
		err = L_PROB;
		goto error;
	}
#ifdef	UNIX_S5
	if (call->attr != (struct termio *) 0) { /* set attributes			*/
		if (ioctl (fd, TCSETA, call->attr) == -1) { /* some ioctl() problem	*/
			err = L_PROB;
			goto error;
		}
	} else {
		ioctl (fd, TCGETA, &termio);
		if ((termio.c_cflag = findspeed (call->baud)) == 0) {
			err = ILL_BD;
			goto error;
		}
		termio.c_cflag |= (CS8|CREAD|HUPCL);
		termio.c_iflag = 0;
		termio.c_oflag = 0;
		termio.c_lflag = 0;
		termio.c_cc[VMIN] = 1;
		termio.c_cc[VTIME] = 1;
		if (ioctl (fd, TCSETA, &termio) == -1) {
			err = L_PROB;
			goto error;
		}
	}
#endif
#ifdef	UNIX_V7
	if (call->attr != (struct sgttyb *) 0) { /* set attributes			*/
		if (gtty (fd, call->attr) == -1) { /* some gtty() problem */
			err = L_PROB;
			goto error;
		}
	} else {
		gtty (fd, &termio);
		if ((termio.sg_ispeed = findspeed (call->baud)) == 0) {
			err = ILL_BD;
			goto error;
		}
		termio.sg_ospeed = termio.sg_ispeed;
		termio.sg_flags = RAW|ANYP;
		termio.sg_erase = -1;
		termio.sg_kill = -1;
		if (stty (fd, &termio) == -1) {
			err = L_PROB;
			goto error;
		}
	}
#endif
	initmodem (modemname, fd);		/* setup modemcap variables		*/
	if (call->telno == (char *) 0)		/* no phone number, connection complete	*/
		goto okay;

	if (! DI) {				/* modem has no ACU!!!			*/
		err = A_PROB;			/* no ACU to attach to			*/
		goto error;
	}
	if (BD != call->baud) {			/* is connection desired at high speed?	*/
		if (BL != call->baud)	{	/* is connection desired at low speed?	*/
			err = ILL_BD;		/* modem can't handle this speed	*/
			goto error;
		}
		BD = BL;			/* set baud to low baud rate		*/
		CO = CL;			/* set connect reply to low baud reply	*/
	}
	if (err = mdial (call->telno, fd)) 	/* some error trying to dial		*/
		goto error;

	signal (SIGALRM, alarmcatch);		/* set catcher for ALARM clock		*/
	signal (SIGHUP, hupcatch);		/* set catcher for HANG UP		*/
	alarm (3600);				/* set clock for 1 hour to touch lock	*/

okay:
	return (modemfd = fd);

error:
	unlink (lockfile);
	if (fd > 2)
		close (fd);
	return (merrno = err);
}

void	undial (fd)
int	fd;
{
	if (fd > 2)
		close (fd);

	unlink (lockfile);
	alarm (0);
}
