.TH MENU 1
.SH NAME
MENU -- A Menu Preprocessor for UNIX

.SH SYNOPSIS

MENU is invoked by a command line of the following form:

.ce
menu [-n] menufile

.ce
- or -

.ce
menu [-menuname] menufile

where the "-n" is optional and is the number of a menu to be invoked in
a menu file which contains more than one menu or "-menuname" is optional
and is the name of the menu to be invoked in a menu file which contains
more than one menu.

MENU command lines may take the following forms:

.nf
 menu mymenu       <-- invoke on file 'mymenu'
 menu -2 mymenu    <-- invoke menu 2 of file 'mymenu'
 menu -main mymenu <-- invoke menu 'main' of file 'mymenu'

.fi
.SH DESCRIPTION

MENU (written in C) is a very simple menu preprocessor for use
under the UNIX operating system.  A user can compose files containing
screen displays and command lines which are invoked in response to
single-character
commands, and MENU will present those screen displays to the user and
accept both single-character and text string (terminated by a RETURN)
input from the user.

.SH WRITING MENU FILES

A file which can be processed by MENU can take on the following
general format:

.ne 17
.nf
-o              <-- set global options (optional line)
#o              <-- define screen display and set local options
<text>          <-- text of screen display
#               <-- end of screen display
<c><text>       <-- command letter followed by text of command line
   ...          <-- additional menus, all of the format
                        #o
                        <text>
                        #
                        <c><text>
#o              <-- define screen display and set local options for
                        next menu
<text>
#
<c><text>       <-- command letter followed by text of command line
##              <-- marks end of last menu

.fi
There are four options recognized by the MENU processor.  These
options are:

.ne 6
.nf
    d - Display text of menu (screen display)
    n<text> - set name of menu
    p - If 'd' is on, page (fill screen with blank lines)
            when end of menu text (screen display)
            is reached
    x - Allow the user to exit to UNIX

.fi
When MENU is first invoked, the D, P, and X options are OFF.
The text
of the screen displays will not be shown and the user will not be allowed
to exit to UNIX.

The first line (which is optional) of the menu file
toggles the global options to ON from their initial state of OFF.  The
dash (-) can be followed by any combination of the menu options in any
order (-dpx = -xpd = -pxd).  This global option line sets the options
for all of the menus in the file except for those menus whose option
line toggles selected options.

Each menu begins with its own option line.  This is the hash (#)
followed by zero or more of the option characters.  For each option character
specified, the state of the global options FOR THIS MENU ONLY is reversed.
Note the following example:

.ne 20
.nf
       -dpx            <-- turn on all options
       #x              <-- do not allow the user to exit
                               to UNIX for this menu
       <text>
       #
       <c><text>
       #px             <-- do not allow the user to exit
                               to UNIX and do not page the
                               screen display for this menu
       <text>
       #
       <c><text>
       #               <-- all options are on for this menu
       <text>
       #
       <c><text>
       ##

.fi
The text of the screen display (that text which follows the
local options line for each menu) can be any text desired with the
one exception that the first character of any line of this text may
not be a hash (#).  The hash, of course, signals the end of the
screen display text and the beginning of the command text.
Example:

.ne 8
.nf
        #dpxndemo       <-- this menu has no globals set, name "demo"
                Any     <-- text of menu
                Text
                I Want
        #
        <c><text>
        ##              <-- only one menu in this file

.fi
Finally, the last part of a menu entry is the command
definition itself.  The definition of a menu command is of the
following general form:

.ce
<char><text>

where <char> is one character which will invoke the text of a
command line.
When you first invoke the MENU program it creates a pipe to the shell.
The shell is selected by looking at the SHELL environment variable.
If this variable is not set then
"sh"
is used.
For example, valid menu command lines include:

.ne 3
.nf
     dls             <-- run ls if char 'd' is typed
     Dls | pr -4t    <-- run 'ls | pr -4t' if char
                        'D' is typed

.fi
There are five special characters which may be embedded
into the text of the command line to cause MENU to perform some
additional processing.  These characters are:

.ne 10
.nf
    !       <-- cause MENU to wait when command line
                    completes
    :       <-- goto a menu
    ~       <-- submit the command line by spawning off a
                     subshell; this is useful for invoking
                    commands which must be attached to a
                    physical device, such as vi
    =       <-- change the current working directory
    '       <-- prompt user for string input

.fi
The first character is used to cause MENU to wait for user
input after the text of the command line is executed (before displaying
the screen of the menu the user is returning to).  If the exclamation
mark (!) is the first character of text (right after the single-character
command), then MENU will wait after the text of the command line
is executed.  Examples:

.ne 2
.nf
       d!ls            <-- run 'ls' and then wait
       D!ls | pr -4t   <-- run 'ls | pr -4t' and then wait

.fi
The exclamation mark acts as a prefix character, and it may be
followed by one of the command characters (:,~,=,') if the menu programmer
desires.

The second special character is used to transfer control
from one menu in a menu file to another.  If the colon (:) is the
first character of text (right after the single-character command),
then the rest of the line is assumed to be the text of a number or a menu
name,
and control is transferred to that menu (first menu is 1, second is 2, etc)
in the file.  ":2" will transfer to menu 2, ":20" will transfer
to menu 20, etc., and ":help" will transfer to the menu named "help," etc.
Examples:

.ne 5
.nf
       2:2     <-- goto menu 2 if char '2' is typed
       h:1     <-- goto menu 1 if char 'h' is typed
       ?:100   <-- goto menu 100 if char '?' is typed
       h:help  <-- goto menu named 'help' if char 'h' is typed
       H:help  <-- goto menu named 'help' if char 'H' is typed

.fi
The third character (tilde, which is '~')
is used to invoke a command line by using a
subshell.  The normal invocation process involves using the UNIX
system (3) function, which suspends the current process and invokes a
new process.  This option is useful when submitting commands which
put the terminal into raw mode, such as screen editors.

The fourth character is used to change MENU's current working directory.
Upon seeing this option MENU will send a change directory command to the
shell so that it too will change to the new working directory.  Examples:

.ne 2
.nf
       U=..            <-- go up to the parent directory
       c=bin           <-- go into the bin directory
.fi

Finally, the fifth character is followed by text to prompt the
user for input, and the user is allowed to enter any text he desires.
This text will be inserted at the point of the prompt.  Unlike the
other two commands, the text input command (') may appear anywhere
in the text of the command line.  This text may be bracketed by the
quote character (like 'Enter Source File'), in which case the user's
input is inserted into the command line at this point and command line
processing from the menu file resumes after the second quote.  Alternatively,
this text may be preceeded by the quote character (like 'Enter File? ),
in which case the end of the line indicates the end of the prompt.  In
both cases, the last character of the prompt is followed by a trailing
blank to improve readability.
Examples:

.ne 22
.nf
     u'Enter Command?        <-- user is prompted with
                                     'Enter Command? '
                                     and his text becomes
                                     the command line
     u!'Command?             <-- like above, but MENU
                                     waits when the command
                                     is completed
     d!ls 'File Spec?' | wc  <-- the command line
                                     'ls <user input> | wc' is
                                     built
     ccp 'Source?' 'Destination?'
                             <-- the user is prompted once
                             with 'Source? ', allowed
                             to enter his input, is
                             prompted on the next line
                             with 'Destintion? ',
                             allowed to enter his input,
                             and the command line
                             'cp <user 1> <user 2>'
                             is built
.fi
.SH EXAMPLE

The following is a sample menu file.
Note that it contains commands which are available
on my UNIX SYSTEM V but may not be available on yours.

.ne 48
.nf

-dpx
#p
MENU 1 - Basic Operations

        ---- Directory ----     ---- File Transfer ----
        d display directory     1 compress file
        D disp dir with arg     2 uncompress file
        / change directory      u uc - transfer file

        ------ Filer ------     -------- Other --------
            c  copy file         C  C Programming Menu
            e  edit file         w  who is on?
            f  format file       z  enter any command
            r  remove file
            t  type file

#
C:cprog
ccp 'Source File?' 'Destination File or Dir?
d!ls | pr -4t
D!ls 'Enter File Spec?
/='Enter Directory Name?
1xsq 'Enter File Name?
2xusq 'Enter File Name?
uuc z
e~vi 'Enter File Name?
fnroff >out.roff 'Output is on out.roff -- Enter File Name?
rrm 'Enter File Name?
t!type 'Enter File Name?
w!who
z!'Enter Command Line?
#ncprog
MENU 2 -- C Programming

        -------- Filer --------         ---- Compiler ----
          d  display directory            c  compile prog
          e  edit file
          r  remove file                ----- Other ------
          t  type file                    z  run prog
                                          M  Main menu
#
M:1
d!ls | pr -4t
evi 'Enter File Name?
rrm 'Enter File Name?
t!type 'Enter File Name?
c!cc  'Enter File Name?
z!'Enter Command Line?
##
.fi
.SH FILES
.nf
menu.c   -- source code
mcheck.c -- menu file syntax checker
.fi
.SH DIAGNOSTICS

MENU issues very simple error messages when syntax errors are
encountered in the menu file.  I did this to keep MENU as simple as possible,
and it is a good idea to run any new menu file through MCHECK before running
it under MENU.  MCHECK gives complete, self-explanatory error messages on
syntax errors contained in a menu file.

.SH BUGS

No known problems exist at this time.  This design is vastly improved
over the original MENU 1.0, and nesting of shell procedures as well as
multiple prompted entries on the same line are now supported.

.SH AUTHOR

MENU was originally written by Richard Conn.  Contributing Authors
(by version number) are:

.ne 10
.nf
                1.0 - Richard Conn
                2.0 - Richard Conn
                2.1 - Orest Jarosiewicz
                2.2 - Richard Conn
                2.3 - Richard Conn
                2.4 - Richard Conn
                2.5 - Richard Conn
.fi


