/*
 * MCHECK.C -- Menu File Syntax Checker for MENU.C by Richard Conn 
 *
 * MCHECK checks the syntax of a menu file (one which is to be processed
 * by MENU.C) for errors and gives complete, informative diagnostics. 
 *
 */

#define versmaj 1		/* Major Version Number */
#define versmin 4		/* Minor Version Number */

/*
 * Revision History 
 *
 * Version 1.0 - Richard Conn 
 *
 * Version 1.1 - Richard Conn. The ability to check for menu references
 * out of range added. 
 *
 * Version 1.2 - Richard Conn. Global references made local. 
 *
 * Version 1.3 - Richard Conn.  Bug fixes and general redesign. 
 *
 * Version 1.4 - Richard Conn.  Menu name checks. 
 *
 */

#define FALSE   0
#define TRUE    ~FALSE

#define HASH    '#'
#define DASH    '-'
#define GOTO    ':'

#include <stdio.h>
#include <ctype.h>

/* Global variables */
#define inlen 500
char            inline[inlen];
int             curline;
int             menumax;
int             menunum;
#define newline fgets(inline, inlen, fd)

main (argc, argv)
    int             argc;
    char           *argv[];
{
    char            c;
    FILE           *fopen (), *fd;

    /* banner */
    printf ("MCHECK Version %d.%d\n", versmaj, versmin);

    /* check for file name */
    if (argc == 1) {
	printf ("Syntax: mcheck filename\n");
	exit (-1);
    }
    /* try to open menu file for input */
    if ((fd = fopen (argv[1], "r")) == NULL) {
	printf ("Menu File %s NOT Found\n", argv[1]);
	exit (-1);
    }
    /* print file name */
    printf ("File: %s\n", argv[1]);

    /* process file */
    curline = 0;
    menumax = 0;
    menunum = 0;
    if (newline == (char *) NULL)
	premature ();
    curline++;
    if ((c = inline[0]) == DASH) {
	prglobals ();
	if (newline == (char *) NULL)
	    premature ();
	curline++;
    }
    while (1) {			/* Process next menu */
	menunum++;
	c = inline[0];
	if (c != HASH) {
	    printf (" New menu expected but not found at line %d\n",
		    curline);
	    premature ();
	}
	prglobals ();
	printf (" Processing Menu %d\n", menunum);
	prdisp (fd);
	prcmds (fd);
    }
}

/* process global parameters  */
prglobals ()
{
    char           *c;

    c = inline;
    c++;
    while (*c != '\n') {
	switch (*c) {
	case ' ':
	case 'D':
	case 'd':
	case 'P':
	case 'p':
	case 'X':
	case 'x':
	    break;		/* OK */
	case 'n':
	case 'N':
	    while (*c > ' ')
		c++;
	    c--;
	    break;
	case HASH:
	    done ();
	    break;
	default:
	    printf (" Invalid Global %c at line %d\n", *c, curline);
	    break;
	}
	c++;
    }
}

/* process commands */
prcmds (fd)
    FILE           *fd;
{
    char           *c;
    int             gotomenu;

    while (newline != (char *) NULL) {
	curline++;
	c = inline;
	if (*c == HASH)
	    return;
	c++;			/* pt to first char after command
				 * letter */
	if (*c == GOTO) {	/* GOTO processing */
	    c++;
	    if (isdigit (*c)) {
		gotomenu = atoi (c);
		if (menumax < gotomenu)
		    menumax = gotomenu;
		if (gotomenu == 0)
		    printf (" GOTO Menu 0 on Line %d\n", curline);
	    }			/* no check made for menu names */
	}
    }
    done ();
}

/* process display */
prdisp (fd)
    FILE           *fd;
{
    int             lcount;

    lcount = 0;
    while (newline != (char *) NULL) {
	curline++;
	lcount++;
	if (inline[0] == HASH) {
	    printf ("   %d Lines in Display\n", lcount - 1);
	    return;
	}
    }
    premature ();
}

/* premature EOF */
premature ()
{
    printf (" Premature end of file at line %d\n", curline);
    exit (0);
}

/* processing completed */
done ()
{
    printf (" Processing completed on/after line %d\n", curline);
    exit (0);
}
