#ifndef lint
static char rcsid[] = "$Header: getenv.c,v 1.6 85/09/24 16:37:23 david Exp $";
#endif lint
/*
 * Routines to muck up environment variables.
 * 
 * $Log:	getenv.c,v $
 * Revision 1.6  85/09/24  16:37:23  david
 * Changed setenv() to 1) use that "untested" loop from getenv()
 * to find the variable, and 2) be a little more intelligent about
 * setting the new value into the environment.
 * 
 * Revision 1.5  85/09/24  16:18:37  david
 * Removed traces of Berkeley code for release to net.
 * (Rewrote getenv(), which hasn't been tested yet,
 * but "oughta work").
 * 
 * Revision 1.4  85/09/24  15:44:29  david
 * Fix setenv() to return an int.
 * Fix rstenv() to set nenv to 0 (for consistency).
 * 
 * Revision 1.3  85/05/14  18:33:47  david
 * Put #ifndef BSD_4_2 ... #endif around getenv().  Because it already
 * exists in the 4.2 library.
 * 
 * Revision 1.2  85/05/14  18:27:58  david
 * Added routines:
 * 
 * setenv(name, value) -- sets an environment variable for name to value.
 * rstenv() -- Resets environment to that of parent.
 * firstenv() -- Initializes sequential scan of environment variables.
 * nextenv() -- Gives next variable.
 * 
 * Also, an internal routine init() which saves the parent environment
 * and copies it to malloc()'d memory.
 * 
 * Revision 1.1  85/01/04  22:57:28  root
 * Initial revision
 * 
 *
 */

#define NULL ((char *)0)

static int initd = 0;		/* set to non-zero after we've set
				 * up environ for children.
				 */
static char **p_environ;	/* Holds pointer to original environment.
				 * We'll be modifying environ to point
				 * to the new environment.
				 */
static int nenv;		/* Number of entries in environ.
				 * Use this to calculate the size of
				 * environ.
				 */


extern	char **environ;
char	*nvmatch();
extern char *malloc(), *realloc();
extern int free();
extern char *strcpy();



/*
 * init() -- Set up initialized and p_environ.
 */
static void init()
{
	int i;

	p_environ = environ;
	for (nenv = 0; p_environ[nenv] != (char *)NULL; nenv++)
			;

	/* Allocate an array of pointers to each environment string */
	environ = (char **)malloc((unsigned)(nenv * sizeof(char **)));

	/* Copy each string to the new environment */
	for (i=0; i<nenv; i++) {
		environ[i] = malloc((unsigned)(strlen(p_environ[i]) + 1));
		(void) strcpy(environ[i], p_environ[i]);
	}

	/* trailer value */
	environ[nenv] = (char *)NULL;
	nenv++;
	initd = 1;
}



#ifndef BSD_4_2
/*
 *	getenv(name)
 *	returns ptr to value associated with name, if any, else NULL
 *	A version of this routine is already present in
 *	most standard libraries.  It's here mostly for reference.
 */
char *getenv(name)
char *name;
{
	register char *v, *s1, *s2;
	register int i;

	for (i = 0; environ[i] != NULL; i++) {
		for (s1=environ[i], s2=name; *s1 == *s2; s1++, s2++) {
			if (*s2 == '\0' || *s2 == '=')
				/* Reached the end of "name" */
				if (*s1 == '=')
					return(++s1);
				else
					break;
			if (*s1 == '=' || *s1 == '\0')
				break;
		}
	}
	return(NULL);
}
#endif /* BSD_4_2 */

/*
 * setenv(name, value) -- Set new value for name.
 *	Returns: non-zero (TRUE) when out of memory, zero for success.
 *
 * WARNING!
 *	"goto"'s live within this procedure!
 */
int setenv(name, value)
char *name, *value;
{
	int i;
	register char *s1, *s2;

	if (initd == 0)
		init();
	for (i = 0; environ[i] != NULL; i++) {
		for (s1=environ[i], s2=name; *s1 == *s2; s1++, s2++) {
			if (*s2 == '\0' || *s2 == '=')
				/* Reached the end of "name" */
				if (*s1 == '=')
					goto found;
				else
					break;
			if (*s1 == '=' || *s1 == '\0')
				break;
		}
	}
	/* It wasn't in the environment already.  add it there. */
	nenv++;
	environ = (char **)realloc((char *)environ,
			(unsigned)(nenv * sizeof(char **)));
	if (environ == (char **)NULL)
		return(0 == 0);
	environ[nenv] = (char *)NULL;
	goto out;
found:
	(void) free(environ[i]);
	environ[i] = malloc(strlen(name) + 1 + strlen(value) + 1);
out:
	(void) strcpy(environ[i], name);
	(void) strcat(environ[i], "=");
	(void) strcat(environ[i], value);
	return(0 == 1);
}

/*
 * rstenv() -- reset environment back to parents environment.
 */
void rstenv()
{
	register int i;

	initd = 0;
	for (i=0; i<nenv; i++)
		(void) free(environ[i]);
	(void) free((char *)environ);
	environ = p_environ;
	nenv = 0;
}

/*
 * firstenv() -- For sequentially scanning environment.  Sets pointer
 * to first environment variable.
 */
static int curenv;

char *firstenv()
{
	if (initd == 0)
		init();
	curenv = 0;
	return(environ[curenv]);
}

/*
 * nextenv() -- look at next environment variable.
 */
char *nextenv()
{
	if (initd == 0) {
		init();
		curenv = 0;
		return(environ[0]);
	}
	else {
		return(environ[++curenv]);
	}
}
