/*
	Function:    filter "Filter Command Line Files In Classic UNIX Style"
	Created:     Sat Aug 10 21:57:12 EDT 1985
	By:          Gary Perlman (Wang Institute, Tyngsboro, MA 01879 USA)
	Compilation: nothing unusual
	Tester:      $Compile: cc -DSTANDALONE -o catfilter %f
	---------------------------------------------------------------
	Preconditions:
		The index of the first file operand has been determined.
	Postconditions:
		All files have been opened, processed, and closed.
	Returns:
		The return status (non-zero is bad) depends on the accessibility
		of files, the ability to open them, and the return statuses of
		the called function.
	Exceptions:
		If any file cannot be accessed, then none will be processed.
		During processing, if something goes wrong (a file that could
		be accessed cannot be opened, or the file processor returns a
		non-zero status), processing continues.
	Global Data Used:
		None
	Global Data Modified:
		None
	Notes:
		"-" is the conventional name for the standard input.
			It can only be read once.
		Fputs and putc are used to print error messages to avoid
			loading just because filter used it.
*/

#include <stdio.h>
#define	isstdin(file) (file[0] == '-' && file[1] == '\0')
/* LINTLIBRARY */
int
filter (argc, argv, curarg, process)
int 	argc;          /* real number of command line args */
char	**argv;        /* command line argument pointer */
int 	curarg;        /* first argv to filter */
int 	(*process) (); /* status process (char *name, FILE *ioptr) */
	{
	int 	status = 0;         /* return status of this function */
	int 	arg;                /* loop index variable */
	char	*file;              /* name of the current file */
	char	*pgm = argv[0];     /* name of the program */
	FILE	*ioptr;             /* file pointer for opening */
	int 	countstdin = 0;     /* number of times stdin is processed */
	if (curarg == argc)
		status += ((*process) ("-", stdin));
	else
		{
		/* first check to make sure all files can be opened to read */
		for (arg = curarg; arg < argc; arg++)
			{
			file = argv[arg];
			if (isstdin (file))
				countstdin++;
			else if (access (file, 4))
				{
				fputs (pgm, stderr);
				fputs (": Can't read '", stderr);
				fputs (file, stderr);
				putc ('\'', stderr);
				putc ('\n', stderr);
				status++;
				}
			}
		if (countstdin > 1)
			{
			fputs (pgm, stderr);
			fputs (": Can only read standard input once\n", stderr);
			status++;
			}
		if (status == 0)
			for (arg = curarg; arg < argc; arg++)
				{
				file = argv[arg];
				if (isstdin (file))
					status += ((*process) (file, stdin) != 0);
				else if (ioptr = fopen (file, "r"))
					{
					status += ((*process) (file, ioptr) != 0);
					(void) fclose (ioptr);
					}
				else
					{
					fputs (pgm, stderr);
					fputs (": Can't open '", stderr);
					fputs (file, stderr);
					putc ('\'', stderr);
					putc ('\n', stderr);
					status++;
					}
				}
		}
	return (status);
	}

#ifdef STANDALONE

int
cat (file, ioptr)
char	*file;
register	FILE	*ioptr;
	{
	register	int 	C;
	while ((C = getc (ioptr)) != EOF)
		putchar (C);
	return (0);
	}

main (argc, argv) char **argv;
	{
	int 	cat ();
	if (filter (argc, argv, 1, cat))
		putc ('\007', stderr); /* UNIX friendly error message */
	}

#endif STANDALONE
