#include <stdio.h>

/*
 * This is a short program for demonstrating the capabilities of egetopt().
 * Run it with various combinations of options and arguments on the command
 * line to see how egetopt() works.
 *
 * Experiment around with this by changing some of my settings and
 * recompiling.
 */

#define OPT_STRING	"abc~d~e?f?"
/* Meaning:
 *
 * -a and -b take no arguments.
 * -c and -d take mandatory arguments (I set 'optneed' to '~', below).
 * -e and -f take optional arguments (I set 'optmaybe' to '?', below).
 */

#define OPT_CHARS	"-+="
/* Meaning:
 *
 * Options can begin with '-', '+', or '='.
 */


/*
 * New global variables used in egetopt() only:
 */
extern int optneed;	/* character used for mandatory arguments */
extern int optmaybe;	/* character used for optional arguments */
extern int optchar;	/* character which begins a given argument */
extern int optbad;	/* what egetopt() returns for a bad option */
extern int opterrfd;	/* where egetopt() error messages go */
extern char *optstart;	/* string which contains valid option start chars */

/*
 * Global variables which exist in getopt() and egetopt():
 */
extern int optind;	/* index of current argv[] */
extern int optopt;	/* the actual option pointed to */
extern int opterr;	/* set to 0 to suppress egetopt's error messages */
extern char *optarg;	/* the argument of the option */

main(argc, argv)
int argc;
char **argv;
{
	int ch;

	opterrfd = fileno(stdout);	/* errors to stdout */
	opterr = 0;		/* set this to 1 to get egetopt's error msgs */
	optbad = '!';		/* return '!' instead of '?' on error */
	optneed = '~';		/* mandatory arg identifier (in OPT_STRING) */
	optmaybe = '?';		/* optional arg identifier (in OPT_STRING) */
	optstart = OPT_CHARS;	/* characters that can start options */

	while ((ch = egetopt(argc, argv, OPT_STRING)) != EOF) {
		printf("\n\toption index (optind) after egetopt(): %5d\n",
			optind);
		printf("\t\tegetopt() return value:            %c (%d)\n",
			ch, ch);
		printf("\t\tchar that begins option (optchar): %c\n",
			optchar);
		printf("\t\tactual char looked at (optopt):    %c\n",
			optopt);
		printf("\t\toption argument:                   \"%s\"\n",
			optarg == NULL ? "(null)" : optarg);
	}

	for (; optind < argc; ++optind) {
		printf("\n\targument index                         %5d\n",
			optind);
		printf("\t\targument:                          \"%s\"\n",
			argv[optind] == NULL ? "(null)" : argv[optind]);
	}

	exit(0);
}
