/*
 * (c) Copyright 1990 Conor P. Cahill (uunet!virtech!cpcahil).  
 * You may copy, distribute, and use this software as long as this
 * copyright statement is not removed.
 */

/* 
 * I have only partially implemented these tests.  If you have the time and
 * energy and wish to add some tests, feel free to do so.  I would appreciate
 * it if you sent me a copy of the modified files. 
 */

#include <stdio.h>

/* 
 * These tests test the memory functions...
 */

main()
{
	char	  buffer[500];
	int	  exitval = 0;
	char	* memccpy();
	char	* memchr();
	char	* ptr1;
	char	* ptr2;

	fprintf(stdout,"Begining memory(3) tests...\n");

	/*
 	 * test memccpy()...
 	 */

	ptr1 = "abcdefghijklmn";	

	buffer[0] = 'n';
	buffer[1] = 'o';
	buffer[2] = 'p';
	buffer[3] = 'q'; 
	buffer[4] = 'r';
	buffer[5] = 's';
	ptr2 = memccpy(buffer,ptr1,'d',3);

	if( ptr2 != (char *) 0)
	{
		fprintf(stdout,"memccpy() failed to use passed length\n");
		exitval++;
	}

	/*
 	 * verify that the correct bytes got copied and the others do not
	 * get clobbered
	 */
	if( (buffer[0] != 'a') ||
	    (buffer[1] != 'b') ||
	    (buffer[2] != 'c') ||
	    (buffer[3] != 'q') ||
	    (buffer[4] != 'r') ||
	    (buffer[5] != 's')  )
	{
		fprintf(stdout,"memccpy() failed to copy bytes correctly\n");
		fprintf(stdout,"Should have been 'abcqrs' was '%6.6s'\n",buffer);
		exitval++;
	}



	buffer[0] = 'n';
	buffer[1] = 'o';
	buffer[2] = 'p';
	buffer[3] = 'q'; 
	buffer[4] = 'r';
	buffer[5] = 's';
	ptr2 = memccpy(buffer,ptr1,'d',4);

	if( ptr2 != (buffer+4) )
	{
		fprintf(stdout,"memccpy() failed to find byte in data\n");
		exitval++;
	}

	/*
 	 * verify that the correct bytes got copied and the others do not
	 * get clobbered
	 */
	if( (buffer[0] != 'a') ||
	    (buffer[1] != 'b') ||
	    (buffer[2] != 'c') ||
	    (buffer[3] != 'd') ||
	    (buffer[4] != 'r') ||
	    (buffer[5] != 's')  )
	{
		fprintf(stdout,"memccpy() failed to copy bytes correctly\n");
		fprintf(stdout,"Should have been 'abcdrs' was '%6.6s'\n",buffer);
		exitval++;
	}

	/*
	 * Test memchr()...
	 */

	ptr1 = "abcdefghijklmn";

	ptr2 = memchr(ptr1,'c',10);
	
	if( ptr2 != (ptr1+2) )
	{
		fprintf(stdout,"memchr() failed to find byte in data\n");
		exitval++;
	}

	ptr2 = memchr(ptr1,'j',10);
	
	if( ptr2 != (ptr1+9) )
	{
		fprintf(stdout,"memchr() failed to find byte in data\n");
		exitval++;
	}

	ptr2 = memchr(ptr1,'k',10);
	
	if( ptr2 != (char *) 0)
	{
		fprintf(stdout,"memchr() failed to obey length argument\n");
		exitval++;
	}

	fprintf(stdout,"Memory tests complete!\n");
	exit(exitval);

}
