/*COMMAND:  FORK AND EXEC COMMAND STRING
**
**  DESCRIPTION:
**		doneok = command(string, inbackground)
**  This routine takes a full command string and executes it.  It's
**  different from "system(3)" in that ">", "<", ">>", and "|" are
**  handled internally.
**
**  This code may be freely copied provided that this sentence and
**  the copyright are retained; all other rights reserved.  Copyright
**  1985, Richard E. $alz (rs@mirror.UUCP).
*/

/* LINTLIBRARY */
#include <errno.h>

/* Pick a dialect, any dialect. */
#define BSD			/* Bezerkeley	*/
/*#define USG			/* Deathstar	*/


#ifdef	BSD
#include <sys/file.h>
#include <sys/wait.h>

typedef union wait	WAITER;
#define W_STATUS(w)	w.w_status
static char		SHELL[] = "/bin/csh";
#endif


#ifdef	USG
#include <fcntl.h>

typedef int		WAITER;
#define W_STATUS(w)	w;
static char		SHELL[] = "/bin/sh";
#endif


/* Handy shorthands. */
#define STDIN		0
#define STDOUT  	1
#define SH		 (&SHELL[sizeof SHELL - 3])

/* Globals and externals. */
extern int		 errno;
extern char		*calloc();
int			 cmndno;
int		       (*cmndclean)();



int
command(text, background)
    register char	 *text;
    int			  background;
{
    register char	**vp;
    register char	**vector;
    register char	 *s;
    register char	 *t;
    register int	  pid;
    register short	  count;
    WAITER		  w;
    int			  dead;
    int			  poop[2];

    /* "Vfork" is probably not the right thing to do. */
    if ((pid = fork()) == 0)
    {
	/* Call child cleanup routine, if there is one. */
	if (cmndclean)
	    (*cmndclean)();

	/* If any meta-characters, pass on to the shell. */
	for (t = text; *t; t++)
	    for (s = ";!~&?*\"\'`\\$(){}"; *s; s++)
		if (*s == *t)
		{
		    (void)execl(SHELL, SH, "-c", text, NULL);
		    _exit(99);
		}

	/* Get number of words, get an array to hold it. */
	for (t = text, count = 2; *t; )
	    if (*t++ <= ' ')
		count++;
	vector = (char **)calloc((unsigned int)count, sizeof(char *));

	/* Skip leading whitespace. */
	while (*text <= ' ')
	    text++;

	/* Loop over command string. */
	for (vp = vector; *text; vp++)
	{
	    /* Put pointer to start of word in array, move to next. */
	    for (*vp = text; *text; text++)
		if (*text <= ' ')
		{
		    /* Null out end, skip multiple spaces. */
		    for (*text++ = '\0'; *text <= ' '; )
			text++;
		    break;
		}

	    /* Handle redirection of input; note we back up the array
	       pointer to overwrite the "<file", but pick up the filename
	       as the second character.  Lots of work being done by that
	       "*vp-- + 1"! */
	    if (**vp == '<')
	    {
		(void)close(STDIN);
		(void)open(*vp-- + 1, O_RDONLY);
	    }

	    /* Handle redirection of output. */
	    if (**vp == '>')
	    {
		(void)close(STDOUT);
		/* Undocumented; handle ">>file", too. */
		if ((*vp)[1] == '>')
		    (void)open(*vp-- + 2, O_WRONLY | O_CREAT | O_APPEND, 0666);
		else
		    (void)open(*vp-- + 1, O_WRONLY | O_CREAT | O_TRUNC, 0666);
	    }

	    /* Handle piping. */
	    if (!strcmp(*vp, "|"))
	    {
		(void)pipe(poop);
		if (fork() == 0)
		{
		    /* Kid is left side of "|"; change stdout, close pipe. */
		    (void)close(STDOUT);
		    (void)dup(poop[1]);
		    (void)close(poop[0]);
		    (void)close(poop[1]);
		    /* Break out to the exec() part. */
		    break;
		}
		/* Parent is right side of "|"; change stdin, close pipe. */
		(void)close(STDIN);
		(void)dup(poop[0], STDIN);
		(void)close(poop[0]);
		(void)close(poop[1]);
		/* Cheat; vp is incremented in next pass through loop. */
		vp = vector - 1;
	    }
	}
	*vp = NULL;
	(void)execvp(*vector, vector);
	_exit(99);
    }

    if (background || pid < 0)
	return(pid);

    /* Wait until the kid exits, or until errno tells us that we have
       no kid (what happened?)  NOTE:  if the caller has other processes
       in the background, and they exit first, they will be found, and
       ignored, here. */
    do
	dead = wait(&w);
    while (dead != pid && (dead > 0 || errno != ECHILD));

    cmndno = W_STATUS(w);
    return(cmndno == 0);
}
