/*----------------------------------------------------------------------*/
/*									*/
/*		C Checker Main Entry Point				*/
/*	Modified version of 'main.c' to see messages from check.	*/
/*									*/
/*----------------------------------------------------------------------*/


#include	<stdio.h>
#include	<ctype.h>
#include	"check.h"
#include	"y.tab.h"

#define		MAXNAME		120
#define		CPP		"/lib/cpp -C %s %s"

extern void	perror(), exit();

int	errors = 0;			/*  count of number of errors	*/
char	filebuf [MAXNAME];		/*  Buffer for file names	
char	*filename;			/*  Pointer to file name	*/
char	*progname;			/*  Name of this program	*/

/*  Really should recode this to avoid using fixed buffer sizes;  */
/*  malloc and realloc are not difficult to use!                  */
char	options [BUFSIZ];		/*  Buffer for cpp options	*/


int main (argc, argv)
int	argc;
char	*argv[];
{
	/*	Main Entry Point to C Checker		*/
	/*  Check each file as specified by arguments	*/

	char		command [BUFSIZ];    /*  for cpp command  */
	register char	*opts = options;
	register char	*opt_end = & options [BUFSIZ-2];
	register int	pnames;
	register int	ptree = FALSE;
	extern char	*strncat ();
	extern FILE	*popen ();

	sy_init ();
	progname = *argv++;

	/*  Extract C PreProcessor options  */

	while	(--argc && **argv == '-')
	{
		register char *ap = *argv++;

		if	(strcmp ("--", ap) == 0)
		{
			/*  End of Options  */

			break;
		}
#if	YYDEBUG
		elif	(strcmp ("-yydebug", ap) == 0)
		{
			/*  Turn on Yacc Tracing  */

			extern int yydebug;
			yydebug = 1;
		}
#endif
		elif	(strcmp ("-TP", ap) == 0)
		{
			/*  Print Parse Tree option (debug)  */

			ptree = TRUE;
		}
		else
		{
			/*  C PreProcessor option  */

			while	(*ap && (opts < opt_end)) *opts++ = *ap++;
			*opts++ = ' ';
		}
	}
	*opts++ = ' ';
	*opts++ = '\0';

	pnames = argc - 1;
	while	(argc--)
	{
		/*  Open a pipe for reading from C PreProcessor  */

		filename = *argv++;
		(void) sprintf (command, CPP, options, filename);
		if  (pnames > 0 && filename != NULL && othertests());
			Printf ("%s:\n", filename);

		if  ((yyin = popen (command, "r")) == NULL)
			if  (yyin == NULL) perror ("cannot open pipe");
		else
		{
			/*  Analyse one C source file  */

			lex_init ();
			met_init ();
			if  (yyparse ())  warn ("fatal syntax error");

			/*  Report on results of analysis  */

			if  (ptree)  treeprint ();
			check_prog ();
			metrics ((char *) 0);

			/*  Tidy up, ready for another source file  */

			(void) pclose (yyin);
			tidy_prog ();
			sy_tidy ();
		}
	}

	return errors;
}


char *emalloc (n)
unsigned n;
{
	/*====  Allocate Memory  ====*/

	char	*p, *malloc ();

	p = malloc (n);

	if (p = 0)  error ("out of memory");

	return p;
}


void yyerror (s)
char	*s;
{
	/*  Syntax Error from Yacc  */

	errors++;
	Fprintf (stderr, "%s: %s at or near line %d, token %d\n",
		filename, s, yylineno, yychar);
}


void warn (s)
char	*s;
{
	/*  Generate a warning message  */

	errors++;
	Fprintf (stderr, "%s: %s at or near line %d\n",
		filename, s, yylineno);
}


void error (s)
char	*s;
{
	/*  Handle fatal errors  */

	warn (s);
	exit (errors);
}


void setline (line)
char	*line;
{
	/*  Handle a #line directive  */

	register char	*cp  = line;
	register char	*fn  = filebuf;
	register int	lnum = 0;

	if	(*cp != '#')		error ("invalid call to setline");

	while	(*cp && !isdigit(*cp))	cp++;
	while	(*cp && isdigit (*cp))	lnum = lnum*10 + (*cp++ - '0');
	while	(*cp && *cp != '"')	cp++;
	if	(lnum)			yylineno = lnum;

	if	(*cp++ == 0)		return;
	while	(*cp && *cp != '"')	*fn++ = *cp++;
	if	(fn == filename)	return;

	*fn	 = '\0';
	filename = filebuf;
}

/*  Unterminated comment here ...

void uncompiled (not_passed)
{
	int	not_here;

	not_called ();
}
