/*===========	Header file for C Checker Program	================*/

#define		elif		else if
#define		TRUE		1
#define		FALSE		0
#define		Printf		(void) printf
#define		Fprintf		(void) fprintf
#define		NilNode		((NodePtr) 0)
#define		NilSym		((Symbol *) 0)


/*===========	Type Definitions			================*/

typedef int	Token;			/*  type of Lex tokens		*/

typedef	enum	{
	Find,		/* Find only */
	Create		/* Find and create if required */
}	Action;

typedef struct	Symbol {		/*  type of Symbol Table Entry	*/
		char		*name;
		Token		token;
		struct Symbol	*next;
}	Symbol;

typedef	struct	Node {			/*  type of Parse Tree Node	*/
	short	type;			/*  variant for a node		*/
	short	line;			/*  source line number		*/
	union	u {
		int		ival;	/*  integer value		*/
		unsigned	uval;	/*  unsigned value		*/
		struct Node	*ptr;	/*  pointer to another node	*/
	}	f1, f2, f3, f4;		/*  variable number of fields	*/
}	Node, *NodePtr;			/*  Node and pointer to Node	*/


/*===========	Parse Tree Node Types			================*/

#define		Seq		1000	/*  a sequence of two nodes	*/
#define		Type		1001	/*  a type specifier		*/
#define		Label		1002	/*  a labelled statement	*/
#define		Pre_Inc		1003	/*  ++ (expression)		*/
#define		Pre_Dec		1004	/*  -- (expression)		*/
#define		Post_Inc	1005	/*  (expression) ++		*/
#define		Post_Dec	1006	/*  (expression) --		*/
#define		Indirect	1007	/*  a -> b			*/
#define		Addr		1008	/*  & id			*/
#define		Uplus		1009	/*  + expression		*/
#define		Uminus		1010	/*  - expression		*/
#define		Cast		1011	/*  (type) expression		*/
#define		Size_Type	1012	/*  SIZEOF (type)		*/
#define		Size_Expr	1013	/*  SIZEOF (expression)		*/
#define		Error		9999	/*  error			*/


/*===========	External Function Definitions		================*/

extern	void	lex_init ();		/*  Lexical Analyser initialise	*/
extern	Token	yylex ();		/*  Lexical Analyser interface	*/

extern	void	sy_init ();		/*  Initialise symbol table	*/
extern	void	sy_tidy ();		/*  Tidy symbol table		*/
extern	Symbol	*findsym ();		/*  look up identifier in table	*/
extern	char	*emalloc ();		/*  allocate space		*/

extern	int	yyparse ();		/*  interface to Yacc Parser	*/

extern	NodePtr	new_node ();		/*  build a parse tree node	*/
extern	void	check_prog ();		/*  check the parse tree	*/
extern	void	tidy_prog ();		/*  delete the parse tree	*/
extern	void	walk_prog ();		/*  walk the parse tree		*/
extern	void	treeprint ();		/*  print the parse tree	*/

extern	void	metrics ();		/*  produce software metrics	*/
extern	void	met_init ();		/*  initialise metrics		*/
extern	void	proc_start ();		/*  initialise local metrics	*/

extern	void	yyerror ();		/*  Yacc syntax error report	*/
extern	void	warn ();		/*  generate warning messages	*/
extern	void	error ();		/*  stop with error message	*/
extern	void	setline ();		/*  set line and filename	*/


/*===========	External Data Definitions		================*/

extern	int	yychar;			/*  current lookahead token	*/
extern	char	*filename;		/*  current filename		*/
extern	int	yylineno;		/*  current line number		*/
extern	FILE	*yyin;			/*  current input file		*/
extern	NodePtr	Tree;			/*  Root of Parse Tree		*/
