/*----------------------------------------------------------------------*/
/*									*/
/*	This module handles a symbol/type hash table			*/
/*									*/
/*----------------------------------------------------------------------*/


#include	<stdio.h>
#ifdef	BSD
#include	<strings.h>
#define		memset(p,c,n)	{register int i;for(i=0;i<(n);i++)(p)[i]=(c);}
#else
#include	<string.h>
#include	<memory.h>
#endif
#include	"check.h"
#include	"y.tab.h"

#define		HASH_SIZE	1000  /*  Allow for 750 names at 75% full  */

unsigned hsize;		/* Size of the hash table */
Symbol	**htable;	/* Pointer to an array of ponters to hash entries */

#ifdef	DEBUG
unsigned *hcount;	/* Pointer to an array of hash counts  */
#endif


unsigned hash (key)
register char	*key;
{
	/*  Hash a key string  */

	register unsigned	hval = 0;

	while  (*key)  hval = (hval << 3) + (hval >> 29) + *key++;

	hval = (hval & 0x7fffffff) % hsize;
	return hval;
}


void mkhash (size)
unsigned	size;		/* Minimum size for hash table */
{
	/*  Create a hash table of size rounded up to next power of two-1  */

	register unsigned tsize = size;

	hsize = 1;		/* Actual hash table size  */
	while	(tsize)
	{
		tsize >>= 1;
		hsize <<= 1;
	}
	hsize--;
	if  (hsize == 0)  hsize++;   /* Silly, but it will work! */

	htable = (Symbol **) emalloc (hsize * sizeof(Symbol *));
	memset ((char *) htable, 0, (int) (hsize * sizeof(Symbol *)));

#ifdef	DEBUG
	Printf ("mkhash table size %d\n", hsize);
	hcount = (unsigned *) emalloc (hsize * sizeof(unsigned));
	memset ((char *) hcount, 0, (int) (hsize * sizeof(unsigned)));
#endif
}


void rmhash ()
{
	/*  Destroy hash table and all chained entries  */

	register Symbol	**pp, *p;
	extern void	free();

	for	(pp = htable; pp < htable + hsize; pp++)
	{
		while	(p = *pp)
		{
			*pp = p->next;
			free (p->name);
			free ((char *)p);
		}
	}

	free((char *) htable);
	htable = 0;
}


Symbol *findsym (name, token, action)
char	*name;		/* name to be inserted or found */
Token	token;		/* type of symbol */
Action	action;		/* Create or Find */
{
	/*  Search for, and create if required, an entry in the hash table  */

	register Symbol		**pp;	/* address of pointer to entry	*/
	register Symbol		*p;	/* search through linked list	*/
	register unsigned	hval;	/* hash value from name		*/
	register int		res;	/* result of strcmp		*/

	pp = &htable[hval = hash(name)];
	p = *pp;

	while	(p != NULL)
	{
		if	((res = strcmp(name, p->name)) == 0)
		{
			return p;
		}
		elif	(res < 0)
		{
			/*  past point where name would be in sorted chain  */
			break;
		}
		pp = &(p->next);
		p = *pp;
	}

	/* Item is not yet on list */
	if	(action == Find)
		return NilSym;
	else
	{
#ifdef	DEBUG
		/*  Accumulate hashing statistics  */
		hcount[hval]++;
#endif
		p = (Symbol *) emalloc (sizeof(Symbol));
		p->name = strcpy (emalloc ((unsigned) strlen(name)+1), name);
		p->token = token;
		p->next = *pp;
		*pp = p;
		return p;
	}
}


static struct Keyword {
	char	*name;
	Token	token;
} keywords [] = {
	"auto",		AUTO,
	"break",	BREAK,
	"case",		CASE,
	"char",		CHAR,
	"continue",	CONTINUE,
	"default",	DEFAULT,
	"do",		DO,
	"double",	DOUBLE,
	"else",		ELSE,
	"enum",		ENUM,
	"extern",	EXTERN,
	"float",	FLOAT,
	"for",		FOR,
	"goto",		GOTO,
	"if",		IF,
	"int",		INT,
	"long",		LONG,
	"register",	REGISTER,
	"return",	RETURN,
	"short",	SHORT,
	"sizeof",	SIZEOF,
	"static",	STATIC,
	"struct",	STRUCT,
	"switch",	SWITCH,
	"typedef",	TYPEDEF,
	"union",	UNION,
	"unsigned",	UNSIGNED,
	"void",		VOID,
	"while",	WHILE,
	0,		0
};


void sy_init ()
{
	/*  Initialise the Symbol Table with the reserved words  */

	register struct Keyword *kw;

	mkhash (HASH_SIZE);
	for	(kw = keywords; kw->name; kw++)
	{
		(void) findsym (kw->name, kw->token, Create);
	}
}


void sy_tidy ()
{
	/*  Remove all but reserved words from the Symbol Table  */
	/*  This is achieved by brute force; destroy & recreate! */

#ifdef	DEBUG
	/*  print hash statistics  */
	register unsigned i, j, tot = 0, maxc = 0, unused = 0;
	for  (i=0; i<hsize; i++)
	{
		/*  print hash count if non-zero  */
		if	(j = hcount[i])
		{
			Printf ("hash %6d : %d\n", i, j);
			if  (j > maxc)  maxc = j;
			tot += j;
		}
		else	unused++;
	}
	Printf ("Total=%d, max chain length=%d, unused=%d\n",tot,maxc,unused);
#endif
	rmhash ();
	sy_init ();
}
