%{
/*----------------------------------------------------------------------*/
/*									*/
/*		LEX generated C lexical analyser			*/
/*									*/
/*----------------------------------------------------------------------*/

#include	"check.h"
#include	"y.tab.h"

#define		yywrap()	(1)

extern	Token	ident ();
extern	void	strings (), comment ();    /*  forward declarations  */
%}

D			[0-9]
NUM			({D}+|({D}+"."{D}*)|("."{D}+))([eE][-+]?{D}+)?[lL]?
HEX			0[xX][0-9a-fA-F]+[lL]?
ID			[A-Za-z_][A-Za-z0-9_]*
ASG			([-+*/%&^|]?"=")|"<<="|">>="

%%

^"#".*"\n"		{ setline (yytext); }
{ID}			{ return ident(); }
{NUM}			{ return CONSTANT; }
{HEX}			{ return CONSTANT; }
{ASG}			{ return Asgn_Op; }
"\""			{ strings ('"');  return CONSTANT; }
"'"			{ strings ('\'');  return CONSTANT; }
"<<"			{ return Shift; }
">>"			{ return Shift; }
"&&"			{ return And; }
"||"			{ return Or; }
"->"			{ return Point; }
"<"|"<="|">="|">"	{ return Rel_Op; }
"=="|"!="		{ return Eq_Op; }
"++"|"--"		{ return IncDec; }
[ \t\n]+		;
"/*"			{ comment (); }
.			{ return yytext[0]; }

%%

Token ident ()
{
	/*  Handle an Identifier or Reserved Word  */

	yylval.id = findsym (yytext, IDENTIFIER, Create);
	return yylval.id->token;
}


void cwarn (ln, s)
int	ln;
char	*s;
{
	/*  Give a warning about a comment, including starting line number  */


	char	msg [120];
	(void) sprintf (msg, "%s, starting at line %d,", s, ln);
	warn (msg);
	free (msg);
}


void comment ()
{
	/*  Swallow the rest of a comment  */

	register int	c = input ();
	register int	startline = yylineno;

	while	(c)
	{
		if	(c == '*')
		{
			if  ((c = input()) == '/')  return;
		}
		elif	(c == '/')
		{
			if  ((c = input()) != '*')  continue;
			cwarn (startline, "nested comment");
		}
		else	c = input();
	}
	cwarn (startline, "unterminated comment");
}


void strings (term)
int	term;
{
	/*  A string terminating with 'term'  */

	register int c;

	while	(c = input ())
	{
		if	(c == term)	break;
		elif	(c == '\\')	(void) input ();
	}
}


void lex_init ()
{
	/*  Initialise the Lexical Analyser for a new file  */
	/*  lex itself should provide this!                 */

	yyleng		=  0;
	yymorfg		=  0;
	yytchar		=  0;
	yybgin		=  yysvec+1;
	yylineno	=  1;
	yysptr		=  yysbuf;
	yyprevious	=  YYNEWLINE;
}
