/*----------------------------------------------------------------------*/
/*									*/
/*	This module contains the actual checking logic			*/
/*									*/
/*----------------------------------------------------------------------*/


#include	<stdio.h>
#include	"check.h"
#include	"y.tab.h"


/*ARGSUSED*/
void checknode (depth, parent, branch, np)
int	depth, parent, branch;
NodePtr	np;
{
	/*  This routine is called as an 'action' by treewalk.	*/
	/*  It checks for the following things :-		*/
	/*	1) assignment in conditional contexts;		*/
	/*	2) potentially mismatched ELSE clauses;		*/
	/*	3) IFs with no THEN or ELSE.			*/


	if  (np->type == Asgn_Op)
	{
		if	((parent == IF && branch == 1) ||
			(parent == WHILE && branch == 1) ||
			(parent == DO && branch == 2) ||
			(parent == FOR && branch == 2) ||
			parent == And || parent == Or)

			warn ("assignment in conditional context");
	}

	if	(np->type == IF && np->f3.ptr == NilNode)  /* IF with no ELSE */
	{
		if	(np->f2.ptr == NilNode ||
			 np->f2.ptr->type == 0 || np->f2.ptr->type == ';')
			warn ("IF with neither THEN nor ELSE");

		if	(np->f2.ptr->type==IF && np->f2.ptr->f3.ptr!=NilNode)
			warn ("potentially mismatched ELSE - use {}");
	}
}


void check_prog ()
{
	/*  Start off the checking process  */

	walk_prog (checknode);
}
