/*----------------------------------------------------------------------*/
/*									*/
/*	This module handles Parse Tree building and walking		*/
/*									*/
/*----------------------------------------------------------------------*/


#include	<stdio.h>
#include	<ctype.h>
#include	"check.h"
#include	"y.tab.h"
#include	"tables.h"

#define		CHUNK		1024	/*  No. of nodes allocated	*/

NodePtr		Tree;		/*  holds the base of the Parse Tree,	*/
				/*  built by the Yacc-generated Parser.	*/

NodePtr		next_node,	/*  the next free node for allocation	*/
		last_node,	/*  node not available for allocation	*/
		node_list;	/*  head of list of blocks of nodes	*/


NodePtr new_node (nt, p1, p2, p3, p4)
int	nt;
NodePtr	p1, p2, p3, p4;
{
	/*  Build a node for the Parse Tree  */

	register NodePtr	np;

	if	(next_node == last_node)
	{
		/*  Allocate a new batch of nodes  */

		next_node = (NodePtr) emalloc (sizeof (Node) * CHUNK);
		last_node = next_node + CHUNK;

		next_node -> f1.ptr = node_list;
		node_list = next_node++;
	}

	np = next_node++;

	np -> type	=  nt;
	np -> line	=  yylineno;
	np -> f1.ptr	=  p1;
	np -> f2.ptr	=  p2;
	np -> f3.ptr	=  p3;
	np -> f4.ptr	=  p4;

	return np;
}


void tidy_prog ()
{
	/*  Delete the parse tree and release its memory space;		*/
	/*  Leave just the first block of nodes for the	next program	*/
	/*  No attempt is made to return the freed space to the system	*/
	/*  by using (s)brk, but this could be added if desired.	*/
	/*  My own view is that if one program builds a huge tree,	*/
	/*  others in the same call to check may also, so let's keep	*/
	/*  the space.  But in that case, why even return it to malloc?	*/
	/*  Because it makes it easier to add the (s)brk, and it might	*/
	/*  alleviate heap fragmentation if other modules are also	*/
	/*  using malloc, and because it just feels neater to me!	*/

	register NodePtr	np;
	extern void		free();

	Tree = NilNode;

	for  (np = node_list->f1.ptr; np; np = np->f1.ptr)  free ((char *) np);
	node_list -> f1.ptr = NilNode;
	next_node = node_list + 1;
	last_node = node_list + CHUNK;
}


void treewalk (depth, parent, branch, np, action)
int	depth, parent, branch;
NodePtr	np;
void	(*action) ();
{
	/*  Perform required action for this node, and all nodes below it  */

	register int	here;

	if  (np == NilNode)  return;
	yylineno = np -> line;

	action (depth, parent, branch, np);

	switch  (here = np -> type)
	{
		/* = = =  Terminal Nodes  = = = */

		case IDENTIFIER:
		case CONSTANT:
		case DEFAULT:
		case BREAK:
		case CONTINUE:
		case ';':
		case Type:
		case Error:
		case 0:		break;

		/* = = =  Unary Nodes  = = = */

		case GOTO:
		case RETURN:
		case CASE:
		case Indirect:
		case Addr:
		case Uplus:
		case Uminus:
		case '!':
		case '~':
		case Pre_Inc:
		case Post_Inc:
		case Size_Type:
		case Size_Expr:
				treewalk (depth+1,here,1,np->f1.ptr,action);
				break;

		/* = = =  Binary Nodes  = = = */

		case Seq:
		case Label:
		case WHILE:
		case DO:
		case SWITCH:
		case ',':
		case Or:
		case And:
		case '|':
		case '^':
		case '&':
		case Eq_Op:
		case Rel_Op:
		case Shift:
		case '+':
		case '-':
		case '*':
		case '/':
		case '%':
		case Cast:
		case Point:
		case '.':
		case '(':
		case '[':
		case Asgn_Op:
				treewalk (depth+1,here,1,np->f1.ptr,action);
				treewalk (depth+1,here,2,np->f2.ptr,action);
				break;

		/* = = =  Ternary Nodes  = = = */

		case IF:
		case '?':
				treewalk (depth+1,here,1,np->f1.ptr,action);
				treewalk (depth+1,here,2,np->f2.ptr,action);
				treewalk (depth+1,here,3,np->f3.ptr,action);
				break;

		/* = = =  Quaternary Nodes  = = = */

		case FOR:
				treewalk (depth+1,here,1,np->f1.ptr,action);
				treewalk (depth+1,here,2,np->f2.ptr,action);
				treewalk (depth+1,here,3,np->f3.ptr,action);
				treewalk (depth+1,here,4,np->f4.ptr,action);
				break;


		default:	Printf ("node type %d encountered\n", here);
				error ("treewalk: parse tree corrupt");
	}
}


void walk_prog (action)
void	(*action) ();
{
	/*  Start off the Parse Tree walk  */

	treewalk (0, 0, 0, Tree, action);
}


/*ARGSUSED*/
void printnode (depth, parent, branch, np)
int	depth, parent, branch;
NodePtr	np;
{
	/*  Print one node of the tree  */

	register int type = np->type;

	while  (depth--)  Printf ("  ");
	Printf ("(%d) line %d:  ", branch, np->line);

	if	(type > 256)
	{
		register NodeName *q = nodenames;

		while  (q->val != 0 && q->val != type)  q++;
		Printf ("%s\n", q->str);
	}
	elif	(type == 256)
		Printf ("ERROR/EOF\n");
	elif	(isprint(type))
		Printf ("%c\n", type);
	else	Printf ("type %d/0x%02x\n", type, type);
}


void treeprint ()
{
	/*  Print the Parse Tree  */

	treewalk (0, 0, 0, Tree, printnode);
}
