/*	YACC Grammar for C - not very strict.		*/
/*	No attempt is made to conform to or accept	*/
/*	ANSI C yet.  Some obsolete constructs are	*/
/*	not supported (deliberately).			*/
/*							*/
/*	If your terminal can handle it, view/edit this	*/
/*	file in 120 or 132 column mode, as all the	*/
/*	actions start in column 72.			*/
/*							*/
/*	Note that TYPEDEF names must be recognised as	*/
/*	such, and return a different token from the	*/
/*	Lexical Analyser.				*/
/*							*/
/*	The Actions build a Parse Tree.			*/

%{
#include	<stdio.h>
#include	"check.h"


	/*----------  Macros for Tree Building  ----------*/


#define		Z			(NodePtr) 0
#define		node0(t)		new_node (t, Z, Z, Z, Z);
#define		node1(t,a)		new_node (t, a, Z, Z, Z);
#define		node2(t,a,b)		new_node (t, a, b, Z, Z);
#define		node3(t,a,b,c)		new_node (t, a, b, c, Z);
#define		node4(t,a,b,c,d)	new_node (t, a, b, c, d);

%}

%union {				/*  Type for Parser Stack	*/
	Symbol		*id;		/*  Name for ID, or string	*/
	int		ival;		/*  integer constants		*/
	unsigned	uval;		/*  octal & hex constants	*/
	NodePtr		ptr;		/*  pointer to Parse Tree Node	*/
}

%token	<id>	IDENTIFIER	TYPENAME

%token	<ival>	CONSTANT

%token		AUTO		BREAK		CASE		CHAR
		CONTINUE	DEFAULT		DO		DOUBLE
		ELSE		ENUM		EXTERN		FLOAT
		FOR		GOTO		IF		INT
		LONG		REGISTER	RETURN		SHORT
		SIZEOF		STATIC		STRUCT		SWITCH
		TYPEDEF		UNION		UNSIGNED	VOID
		WHILE

		Shift		And		Or		Rel_Op
		Eq_Op		IncDec		Asgn_Op		Point

%right		Asgn_Op
%right		'?'		':'
%left		Or
%left		And
%left		'|'
%left		'^'
%left		'&'
%left		Eq_Op
%left		Rel_Op
%left		Shift
%left		'+'		'-'
%left		'*'		'/'		'%'
%left		Prefix
%left		SizeOf
%left		IncDec		Point		'.'
%left		'['		'('

%type	<id>	declarator

%type	<ptr>	top_level_decls		top_level_decl		function_decl
		type_name		compound		statements
		statement		label			expr_opt
		expr_list		expression		tag

%%


/*--------------------------   DECLARATIONS   -------------------------------*/


program		:	top_level_decls					{ Tree = $1; }
		;

top_level_decls	:	/*  empty  */					{ proc_start(); $$ = node0 (0); }
		|	top_level_decls top_level_decl			{ proc_start(); $$ = node2 (Seq, $1, $2); }
		;

top_level_decl	:	function_decl					{ $$ = $1; }
		|	declaration					{ $$ = node0 (0); }
		|	error '}'					{ $$ = node0 (Error); }
		|	error ';'					{ $$ = node0 (Error); }
		;

function_decl	:	specifiers declarator declarations compound	{ $$ = $4; metrics ($2->name); }
		|	declarator declarations compound		{ $$ = $3; metrics ($1->name); }
		;

declarations	:	/*  empty  */
		|	declarations declaration
		;

declaration	:	specifiers init_dclrtrs ';'
		|	specifiers ';'
		;

specifiers	:	storage
		|	storage type_spec
		|	type_spec
		;

storage		:	AUTO
		|	EXTERN
		|	REGISTER
		|	STATIC
		;

type_spec	:	int_spec
		|	UNSIGNED int_spec
		|	UNSIGNED
		|	float_spec
		|	enum_spec
		|	struct_spec
		|	union_spec
		|	TYPENAME
		|	VOID
		;

declarator	:	IDENTIFIER					{ $$ = $1; }
		|	'(' declarator ')'				{ $$ = $2; }
		|	declarator '(' parameter_list ')'		{ $$ = $1; }
		|	declarator '(' ')'				{ $$ = $1; }
		|	declarator '[' expr_opt ']'			{ $$ = $1; }
		|	'*' declarator %prec Prefix			{ $$ = $2; }
		;

parameter_list	:	IDENTIFIER
		|	parameter_list ',' IDENTIFIER
		;

init_dclrtrs	:	declarator
		|	declarator Asgn_Op initialiser
		|	init_dclrtrs ',' declarator
		|	init_dclrtrs ',' declarator Asgn_Op initialiser
		;

initialiser	:	expression
		|	'{' init_list '}'
		|	'{' init_list ',' '}'
		;

init_list	:	initialiser
		|	init_list ',' initialiser
		;

declaration	:	TYPEDEF type_spec type_decls ';'
		;

type_decls	:	declarator					{ $1->token = TYPENAME; }
		|	type_decls ',' declarator			{ $3->token = TYPENAME; }
		;


/*----------------------------   TYPES   ----------------------------------*/


int_spec	:	CHAR | SHORT | SHORT INT | INT | LONG INT | LONG ;
float_spec	:	FLOAT | LONG FLOAT | DOUBLE ;

enum_spec	:	ENUM IDENTIFIER
		|	ENUM IDENTIFIER '{' enum_fields '}'
		|	ENUM '{' enum_fields '}'
		;

struct_spec	:	STRUCT IDENTIFIER
		|	STRUCT IDENTIFIER '{' struct_fields '}'
		|	STRUCT '{' struct_fields '}'
		;

union_spec	:	UNION IDENTIFIER
		|	UNION IDENTIFIER '{' struct_fields '}'
		|	UNION '{' struct_fields '}'
		;

enum_fields	:	enum_const
		|	enum_fields ',' enum_const
		;

enum_const	:	IDENTIFIER
		|	IDENTIFIER Asgn_Op expression
		;

struct_fields	:	type_spec field_list ';'
		|	struct_fields type_spec field_list ';'
		|	error ';'
		;

field_list	:	field
		|	field_list ',' field
		;

field		:	declarator
		|	declarator ':' expression
		|	':' expression
		;

type_name	:	type_spec					{ $$ = node0 (Type); }
		|	type_spec abstract				{ $$ = node0 (Type); }
		;

abstract	:	'(' abstract ')'
		|	'(' ')'
		|	abstract '(' ')'
		|	'[' expr_opt ']'
		|	abstract '[' expr_opt ']'
		|	'*' %prec Prefix
		|	'*' abstract %prec Prefix
		;


/*--------------------------   STATEMENTS   --------------------------------*/


compound	:	'{' declarations statements '}'			{ $$ = node1 (Seq, $3); }
		|	'{' '}'						{ $$ = node0 (0); }
		|	error '}'					{ $$ = node0 (Error); }
		;

statements	:	statement					{ $$ = $1; }
		|	statements statement				{ $$ = node2 (Seq, $1, $2); }
		;

statement	:	expr_list ';'					{ $$ = $1; }
		|	label ':' statement				{ $$ = node2 (Label, $1, $3); }
		|	compound					{ $$ = $1; }
		|	IF '(' expr_list ')' statement			{ $$ = node3 (IF, $3, $5, Z); }
		|	IF '(' expr_list ')' statement ELSE statement	{ $$ = node3 (IF, $3, $5, $7); }
		|	WHILE '(' expr_list ')' statement		{ $$ = node2 (WHILE, $3, $5); }
		|	DO statement WHILE '(' expr_list ')' ';'	{ $$ = node2 (DO, $2, $5); }
		|	FOR '(' expr_opt ';' expr_opt ';' expr_opt ')'
			statement					{ $$ = node4 (FOR, $3, $5, $7, $9); }
		|	SWITCH '(' expr_list ')' statement		{ $$ = node2 (SWITCH, $3, $5); }
		|	BREAK ';'					{ $$ = node0 (BREAK); }
		|	CONTINUE ';'					{ $$ = node0 (CONTINUE); }
		|	RETURN expr_opt ';'				{ $$ = node1 (RETURN, $2); }
		|	GOTO tag ';'					{ $$ = node1 (GOTO, Z); }
		|	';'						{ $$ = node0 (';'); }
		|	error ';'					{ $$ = node0 (Error); }
		;

label		:	tag						{ $$ = $1; }
		|	CASE expression					{ $$ = node1 (CASE, $2); }
		|	DEFAULT						{ $$ = node0 (DEFAULT); }
		;


/*---------------------------   EXPRESSIONS   -------------------------------*/


expr_opt	:	/*  empty  */					{ $$ = node0 (0); }
		|	expr_list					{ $$ = $1; }
		;

expr_list	:	expression					{ $$ = $1; }
		|	expr_list ',' expression			{ $$ = node2 (',', $1, $3); }
		;

expression	:	expression Asgn_Op expression			{ $$ = node2 (Asgn_Op, $1, $3); }
		|	expression '?' expr_list ':' expression		{ $$ = node3 ('?', $1, $3, $5); }
		|	expression Or expression			{ $$ = node2 (Or, $1, $3); }
		|	expression And expression			{ $$ = node2 (And, $1, $3); }
		|	expression '|' expression			{ $$ = node2 ('|', $1, $3); }
		|	expression '^' expression			{ $$ = node2 ('^', $1, $3); }
		|	expression '&' expression			{ $$ = node2 ('&', $1, $3); }
		|	expression Eq_Op expression			{ $$ = node2 (Eq_Op, $1, $3); }
		|	expression Rel_Op expression			{ $$ = node2 (Rel_Op, $1, $3); }
		|	expression Shift expression			{ $$ = node2 (Shift, $1, $3); }
		|	expression '+' expression			{ $$ = node2 ('+', $1, $3); }
		|	expression '-' expression			{ $$ = node2 ('-', $1, $3); }
		|	expression '*' expression			{ $$ = node2 ('*', $1, $3); }
		|	expression '/' expression			{ $$ = node2 ('/', $1, $3); }
		|	expression '%' expression			{ $$ = node2 ('%', $1, $3); }
		|	'*' expression %prec Prefix			{ $$ = node1 (Indirect, $2); }
		|	'&' expression %prec Prefix			{ $$ = node1 (Addr, $2); }
		|	'+' expression %prec Prefix			{ $$ = node1 (Uplus, $2); }
		|	'-' expression %prec Prefix			{ $$ = node1 (Uminus, $2); }
		|	'!' expression %prec Prefix			{ $$ = node1 ('!', $2); }
		|	'~' expression %prec Prefix			{ $$ = node1 ('~', $2); }
		|	'(' type_name ')' expression %prec Prefix	{ $$ = node2 (Cast, $2, $4); }
		|	IncDec expression %prec Prefix			{ $$ = node1 (Pre_Inc, $2); }
		|	SIZEOF '(' type_name ')' %prec SizeOf		{ $$ = node1 (Size_Type, $3); }
		|	SIZEOF expression %prec SizeOf			{ $$ = node1 (Size_Expr, $2); }
		|	expression IncDec				{ $$ = node1 (Post_Inc, $1); }
		|	expression Point tag				{ $$ = node2 (Point, $1, $3); }
		|	expression '.' tag				{ $$ = node2 ('.', $1, $3); }
		|	expression '(' ')'				{ $$ = node2 ('(', $1, Z); }
		|	expression '(' expr_list ')'			{ $$ = node2 ('(', $1, $3); }
		|	expression '[' expr_list ']'			{ $$ = node2 ('[', $1, $3); }
		|	'(' expr_list ')'				{ $$ = $2; }
		|	tag						{ $$ = $1; }
		|	CONSTANT					{ $$ = node1 (CONSTANT, Z); }
		;

tag		:	IDENTIFIER					{ $$ = node1 (IDENTIFIER, (NodePtr) $1); }
		;
