%right   CONDITION      COLON
%left    LOGICAL_OR
%left    LOGICAL_AND
%left    INCLUSIVE_OR
%left    EXCLUSIVE_OR
%left    AMPERSAND
%left    EQUAL  NOT_EQUAL
%left    LEFT_SHIFT      RIGHT_SHIFT
%left    PLUS   MINUS
%left    STAR   DIVIDE   MODULUS
%left    INCREMENT      DECREMENT
%left    DOT    LEFT_PARENTHESIS     LEFT_BRACKET
%right   LOGICAL_NEGATE           ONES_COMPLEMENT
%left    LESS_THAN      GREATER_THAN    LESS_THAN_EQUAL    GREATER_THAN_EQUAL
%left    COMMA
%token   SEMI_COLON
%token   LEFT_BRACE               RIGHT_BRACE
%token   RIGHT_PARENTHESIS      RIGHT_BRACKET
%right   ASSIGN   MULTIPLY_ASSIGN   DIVIDE_ASSIGN   MODULUS_ASSIGN   ADD_ASSIGN
%right   SUBTRACT_ASSIGN   LEFT_SHIFT_ASSIGN   RIGHT_SHIFT_ASSIGN
%right   AND_ASSIGN    OR_ASSIGN   XOR_ASSIGN
%token   MEMBER_OF_STRUCT
%token   AUTO_TOKEN               BREAK_TOKEN
%token   CASE_TOKEN               CHAR_TOKEN
%token   CHAR_TOKEN               CONST_TOKEN
%token   CONTINUE_TOKEN           DEFAULT_TOKEN
%token   DO_TOKEN                 DOUBLE_TOKEN
%token   ELSE_TOKEN               ENUM_TOKEN
%token   ENUM_TOKEN               EXTERN_TOKEN
%token   FLOAT_TOKEN              FOR_TOKEN
%token   GOTO_TOKEN               IF_TOKEN
%token   INT_TOKEN                LONG_TOKEN
%token   REGISTER_TOKEN           RETURN_TOKEN
%token   SHORT_TOKEN              SIGNED_TOKEN
%token   SIZEOF_TOKEN             STATIC_TOKEN
%token   STRUCT_TOKEN             SWITCH_TOKEN
%token   TYPEDEF_TOKEN            UNION_TOKEN
%token   UNSIGNED_TOKEN           VOID_TOKEN
%token   VOLATILE_TOKEN           WHILE_TOKEN

%token   IDENTIFIER
%token   TYPEDEF_NAME
%token   INTEGER_CONSTANT         FLOATING_CONSTANT
%token   CHARACTER_CONSTANT       ENUMERATION_CONSTANT
%token   STRING_LITERAL

%start   Translation_Unit

%%


Translation_Unit          :  Translation_Unit
                             External_Declaration
                           | External_Declaration
                           ;

External_Declaration      :  Function_Definition
                           | Declaration
                           ;

Function_Definition       :  Declaration_Specifiers
                             Declarator
                             Declaration_List
                             Compound_Statement 
                           | Declaration_Specifiers
                             error
                             Compound_Statement
                           | Declarator
                             Compound_Statement
                           ;

Declaration               :  Declaration_Specifiers
                             Init_Declarator_List
                             SEMI_COLON
                           | Declaration_Specifiers
                             error
                             SEMI_COLON
                           | Declaration_Specifiers
                             SEMI_COLON
                           ;

Declaration_List          :  Declaration
                           | Declaration_List
                             Declaration
                           ;

Declaration_Specifiers    :  Storage_Class_Specifier
                           | Storage_Class_Specifier Declaration_Specifiers
                           | Type_Specifier
                           | Type_Specifier Declaration_Specifiers
                           | Type_Qualifier
                           | Type_Qualifier Declaration_Specifiers
                           ; 

Storage_Class_Specifier   :  AUTO_TOKEN
                           | REGISTER_TOKEN
                           | STATIC_TOKEN
                           | EXTERN_TOKEN
                           | TYPEDEF_TOKEN
                           ;

Type_Specifier            :  VOID_TOKEN
                           | CHAR_TOKEN
                           | SHORT_TOKEN
                           | INT_TOKEN
                           | LONG_TOKEN
                           | FLOAT_TOKEN
                           | DOUBLE_TOKEN
                           | SIGNED_TOKEN
                           | UNSIGNED_TOKEN
                           | Struct_Or_Union_Specifier
                           | Enum_Specifier
                           | TYPEDEF_NAME
                           ;

Type_Qualifier            :  CONST_TOKEN
                           | VOLATILE_TOKEN
                           ;

Struct_Or_Union_Specifier  :  Struct_Or_Union
                              IDENTIFIER
                            | Struct_Or_Union
                              Identifier_Opt
                              Struct_Definition
                            | Struct_Or_Union
                              error
                              Struct_Definition
                            ;

Struct_Definition          :  LEFT_BRACE
                              Struct_Declaration_List
                              RIGHT_BRACE
                            | LEFT_BRACE
                              error
                              RIGHT_BRACE
                            ;

Identifier_Opt             :  IDENTIFIER
                            |
                            ;

Struct_Or_Union            :  STRUCT_TOKEN
                            | UNION_TOKEN
                            ;

Struct_Declaration_List    :  Struct_Declaration_List
                              Struct_Declaration
                            | Struct_Declaration
                            ;

Init_Declarator_List       :  Init_Declarator
                            | Init_Declarator_List
                              COMMA
                              Init_Declarator
                            | error
                              COMMA
                              Init_Declarator
                            ;

Init_Declarator            :  Declarator
                            | Declarator
                              ASSIGN
                              Initializer
                            | error
                              ASSIGN
                              Initializer
                            ;

Struct_Declaration         :  Specifier_Qualifier_List
                              Struct_Declarator_List
			      SEMI_COLON
                            | error
                              SEMI_COLON
                            ;

Specifier_Qualifier_List   :  Type_Specifier
                            | Type_Specifier
                              Specifier_Qualifier_List
                            | Type_Qualifier
                            | Type_Qualifier
                              Specifier_Qualifier_List
                            ;

Struct_Declarator_List     :  Struct_Declarator
                            | Struct_Declarator_List
                              COMMA
                              Struct_Declarator
                            | error
                              COMMA
                              Struct_Declarator
                            ;

Struct_Declarator          :  Declarator
                            | Declarator
                              COLON
                              Constant_Expression
                            | error
                              COLON
                              Constant_Expression
                            | COLON
                              Constant_Expression
                            ;

Enum_Specifier             :  ENUM_TOKEN
                              Identifier_Opt
                              Enumerators_Definition
                            | ENUM_TOKEN
                              error
                              Enumerators_Definition
                            | ENUM_TOKEN
                              IDENTIFIER
                            ;

Enumerators_Definition     :  LEFT_BRACE
                              Enumerator_List
                              RIGHT_BRACE
                            | LEFT_BRACE
                              error
                              RIGHT_BRACE
                            ;

Enumerator_List            :  Enumerator
                            | Enumerator_List
                              COMMA
                              Enumerator
                            | error
                              COMMA
                              Enumerator
                            ;

Enumerator                 :  IDENTIFIER
                            | IDENTIFIER
                              ASSIGN
                              Constant_Expression
                            ;

Declarator                 :  Pointer
                              Direct_Declarator
                            | Direct_Declarator
                            ;

Direct_Declarator          :  IDENTIFIER
                            | LEFT_PARENTHESIS
                              Declarator
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            | Direct_Declarator
                              LEFT_BRACKET
                              Constant_Expression_Opt
                              RIGHT_BRACKET
                            | Direct_Declarator
                              LEFT_BRACKET
                              error
                              RIGHT_BRACKET
                            | Direct_Declarator
                              LEFT_PARENTHESIS
                              Parameter_Type_List
                              RIGHT_PARENTHESIS
                            | Direct_Declarator
                              LEFT_PARENTHESIS
                              Identifier_List_Opt
                              RIGHT_PARENTHESIS
                            | Direct_Declarator
                              LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;

Constant_Expression_Opt    :  Constant_Expression
                            |
                            ;

Identifier_List_Opt        :  Identifier_List
                            |
                            ;

Pointer                    :  STAR
                            | STAR
                              Pointer
                            | STAR
                              Type_Qualifier_List
                            | STAR
                              Type_Qualifier_List
                              Pointer
                            ;

Type_Qualifier_List        :  Type_Qualifier_List
                              Type_Qualifier
                            | Type_Qualifier
                            ;

Parameter_Type_List        :  Parameter_List
                            | Parameter_List
                              COMMA
                              DOT
                              DOT
                              DOT
                            | error
                              COMMA
                              DOT
                              DOT
                              DOT
                            ;

Parameter_List             :  Parameter_Declaration
                            | Parameter_List
                              COMMA
                              Parameter_Declaration
                            | error
                              COMMA
                              Parameter_Declaration
                            ;

Parameter_Declaration      :  Declaration_Specifiers
                              Declarator
                            | Declaration_Specifiers
                              Abstract_Declarator
                            | Declaration_Specifiers
                            ;

Identifier_List            :  IDENTIFIER
                            | Identifier_List
                              COMMA
                              IDENTIFIER
                            | error
                              COMMA
                              IDENTIFIER
                            ;

Initializer                :  Assignment_Expression
                            | LEFT_BRACE
                              Initializer_List
                              RIGHT_BRACE
                            | LEFT_BRACE
                              error
                              RIGHT_BRACE
                            | LEFT_BRACE
                              Initializer_List
                              COMMA
                              RIGHT_BRACE
                            | LEFT_BRACE
                              error
                              COMMA
                              RIGHT_BRACE
                            ;

Initializer_List           :  Initializer
                            | Initializer_List
                              COMMA
                              Initializer
                            ;

Type_Name                  :  Specifier_Qualifier_List
                              Abstract_Declarator
                            | Specifier_Qualifier_List
                            ;

Abstract_Declarator        :  Pointer
                            | Pointer
                              Direct_Abstract_Declarator
                            | Direct_Abstract_Declarator
                            ;

Direct_Abstract_Declarator :  LEFT_PARENTHESIS
                              Abstract_Declarator
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              Parameter_Type_List_Opt
                              RIGHT_PARENTHESIS
/*                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
  Causes 4 reduce/reduce conflicts
*/                            | LEFT_BRACKET
                              Constant_Expression_Opt
                              RIGHT_BRACKET
                            | LEFT_BRACKET
                              error
                              RIGHT_BRACKET
                            | Direct_Abstract_Declarator
                              LEFT_BRACKET
                              Constant_Expression_Opt
                              RIGHT_BRACKET
                            | Direct_Abstract_Declarator
                              LEFT_BRACKET
                              error
                              RIGHT_BRACKET
                            | Direct_Abstract_Declarator
                              LEFT_PARENTHESIS
                              Parameter_Type_List_Opt
                              RIGHT_PARENTHESIS
                            | Direct_Abstract_Declarator
                              LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;

Parameter_Type_List_Opt    :  Parameter_Type_List
                            |
                            ;


Statement                  :  Labeled_Statement
                            | Expression_Statement
                            | Compound_Statement
                            | Selection_Statement
                            | Iteration_Statement
                            | Jump_Statement
                            ;

Labeled_Statement          :  IDENTIFIER
                              COLON
                              Statement
                            | CASE_TOKEN
                              Constant_Expression
                              COLON
                              Statement
                            | CASE_TOKEN
                              error
                              COLON
                              Statement
                            | DEFAULT_TOKEN
                              COLON
                              Statement
                            ;

Expression_Statement       :  Expression_Opt
                              SEMI_COLON
                            | error
                              SEMI_COLON
                            ;

Expression_Opt             :  Expression
                            |
                            ;

Compound_Statement         :  LEFT_BRACE
                              RIGHT_BRACE
                            | LEFT_BRACE
                              Declaration_List
                              RIGHT_BRACE
                            | LEFT_BRACE
                              Statement_List
                              RIGHT_BRACE
                            | LEFT_BRACE
                              Declaration_List
                              Statement_List
                              RIGHT_BRACE
                            | LEFT_BRACE
                              error
                              RIGHT_BRACE
                            ;

Statement_List             :  Statement_List Statement
                            | Statement
                            ;

Selection_Statement        :  If_Statement
                            | If_Else_Statement
                            | Switch_Statement
                            ;                              

If_Statement               :  IF_TOKEN
                              If_Condition
                              Statement
                            ;

If_Condition               :  LEFT_PARENTHESIS
                              Expression
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;

If_Else_Statement          :  IF_TOKEN
                              If_Condition
                              IfStatement_Else
                              Statement
                            ;

IfStatement_Else           :  Statement
                              ELSE_TOKEN
                            | error
                              ELSE_TOKEN
                            ;

Switch_Statement           :  SWITCH_TOKEN
                              Switch_Expression
                              Statement
                            ;

Switch_Expression          :  LEFT_PARENTHESIS
                              Expression
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;
                            
Iteration_Statement        :  While_Statement
                            | Do_While_Statement
                            | For_Statement
                            ;

While_Statement            :  WHILE_TOKEN
                              While_Condition
                              Statement
                            ;

While_Condition            :  LEFT_PARENTHESIS
                              Expression
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;

Do_While_Statement         :  DO_TOKEN
                              Do_Statement
                              Do_Condition
                              SEMI_COLON
                            ;

Do_Statement               :  Statement
                              WHILE_TOKEN
                            | error
                              WHILE_TOKEN
                            ;

Do_Condition               :  LEFT_PARENTHESIS
                              Expression
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;

For_Statement              :  FOR_TOKEN
                              LEFT_PARENTHESIS
                              First_For_Expression
                              Second_For_Expression
                              Third_For_Expression
                              Statement
                            ;

First_For_Expression       :  Expression_Opt
                              SEMI_COLON
                            | error
                              SEMI_COLON
                            ;

Second_For_Expression      :  Expression_Opt
                              SEMI_COLON
                            | error
                              SEMI_COLON
                            ;

Third_For_Expression       :  Expression_Opt
                              RIGHT_PARENTHESIS
                            | error
                              RIGHT_PARENTHESIS
                            ;

Jump_Statement             :  GOTO_TOKEN
                              IDENTIFIER
                              SEMI_COLON
                            | CONTINUE_TOKEN
                              SEMI_COLON
                            | BREAK_TOKEN
                              SEMI_COLON
                            | RETURN_TOKEN
                              Expression_Opt
                              SEMI_COLON
                            | RETURN_TOKEN
                              error
                              SEMI_COLON
                            ;

Expression                 :  Assignment_Expression
                            | Expression
                              COMMA
                              Assignment_Expression
                            | error
                              COMMA
                              Assignment_Expression
                            ;

Assignment_Expression      :  Conditional_Expression
                            | Unary_Expression
                              Assignment_Operator
                              Assignment_Expression
                            ;

Assignment_Operator        :  ASSIGN
                            | MULTIPLY_ASSIGN
                            | DIVIDE_ASSIGN
                            | MODULUS_ASSIGN
                            | ADD_ASSIGN
                            | SUBTRACT_ASSIGN
                            | LEFT_SHIFT_ASSIGN
                            | RIGHT_SHIFT_ASSIGN
                            | AND_ASSIGN
                            | OR_ASSIGN
                            | XOR_ASSIGN
                            ;

Conditional_Expression     :  Logical_OR_Expression
                            | First_Condition_Expression
                              Second_Condition_Expression
                              Conditional_Expression
                            ;

First_Condition_Expression :  Logical_OR_Expression
                              CONDITION
                            | error
                              CONDITION
                            ;

Second_Condition_Expression :  Expression
                               COLON
                             | error
                               COLON
                             ;

Constant_Expression        :  Conditional_Expression
                            ;

Logical_OR_Expression      :  Logical_AND_Expression
                            | Logical_OR_Expression
                              LOGICAL_OR
                              Logical_AND_Expression
                            | error
                              LOGICAL_OR
                              Logical_AND_Expression
                            ;

Logical_AND_Expression     :  Inclusive_OR_Expression
                            | Logical_AND_Expression
                              LOGICAL_AND
                              Inclusive_OR_Expression
                            | error
                              LOGICAL_AND
                              Inclusive_OR_Expression
                            ;

Inclusive_OR_Expression    :  Exclusive_OR_Expression
                            | Inclusive_OR_Expression
                              INCLUSIVE_OR
                              Exclusive_OR_Expression
                            | error
                              INCLUSIVE_OR
                              Exclusive_OR_Expression
                            ;

Exclusive_OR_Expression    :  AND_Expression
                            | Exclusive_OR_Expression
                              EXCLUSIVE_OR
                              AND_Expression
                            | error
                              EXCLUSIVE_OR
                              AND_Expression
                            ;

AND_Expression             :  Equality_Expression
                            | AND_Expression
                              AMPERSAND
                              Equality_Expression
                            | error
                              AMPERSAND
                              Equality_Expression
                            ;

Equality_Expression        :  Relational_Expression
                            | Equality_Expression
                              EQUAL
                              Relational_Expression
                            | Equality_Expression
                              NOT_EQUAL
                              Relational_Expression
                            | error
                              Equality_Token
                              Relational_Expression
                            ;

Equality_Token             :  EQUAL
                            | NOT_EQUAL
                            ;

Relational_Expression      :  Shift_Expression
                            | Relational_Expression
                              LESS_THAN
                              Shift_Expression
                            | Relational_Expression
                              GREATER_THAN
                              Shift_Expression
                            | Relational_Expression
                              LESS_THAN_EQUAL
                              Shift_Expression
                            | Relational_Expression
                              GREATER_THAN_EQUAL
                              Shift_Expression
                            | error
                              Relational_Token
                              Shift_Expression
                            ;

Relational_Token           :  LESS_THAN
                            | GREATER_THAN
                            | LESS_THAN_EQUAL
                            | GREATER_THAN_EQUAL
                            ;

Shift_Expression           :  Additive_Expression
                            | Shift_Expression
                              LEFT_SHIFT
                              Additive_Expression
                            | Shift_Expression
                              RIGHT_SHIFT
                              Additive_Expression
                            | error
                              Shift_Token
                              Additive_Expression
                            ;

Shift_Token                :  LEFT_SHIFT
                            | RIGHT_SHIFT
                            ;

Additive_Expression        :  Multiplicative_Expression
                            | Additive_Expression
                              PLUS
                              Multiplicative_Expression
                            | Additive_Expression
                              MINUS
                              Multiplicative_Expression
                            | error
                              Additive_Token
                              Multiplicative_Expression
                            ;

Additive_Token             :  PLUS
                            | MINUS
                            ;

Multiplicative_Expression  :  Cast_Expression
                            | Multiplicative_Expression
                              STAR
                              Cast_Expression
                            | Multiplicative_Expression
                              DIVIDE
                              Cast_Expression
                            | Multiplicative_Expression
                              MODULUS
                              Cast_Expression
                            | error
                              Multiplicative_Token
                              Cast_Expression
                            ;

Multiplicative_Token       :  STAR
                            | DIVIDE
                            | MODULUS
                            ;

Cast_Expression            :  Unary_Expression
                            | LEFT_PARENTHESIS
                              Type_Name
                              RIGHT_PARENTHESIS
                              Cast_Expression
                            ;

Unary_Expression           :  Postfix_Expression
                            | INCREMENT
                              Unary_Expression
                            | DECREMENT
                              Unary_Expression
                            | Unary_Operator
                              Cast_Expression
                            | SIZEOF_TOKEN
                              Unary_Expression
                            | SIZEOF_TOKEN
                              LEFT_PARENTHESIS
                              Type_Name
                              RIGHT_PARENTHESIS
                            ;

Unary_Operator             :  AMPERSAND
                            | STAR
                            | PLUS
                            | MINUS
                            | LOGICAL_NEGATE
                            | ONES_COMPLEMENT
                            ;

Postfix_Expression         :  Primary_Expression
                            | Postfix_Expression
                              LEFT_BRACKET
                              Expression
                              RIGHT_BRACKET
                            | Postfix_Expression
                              LEFT_PARENTHESIS
                              RIGHT_PARENTHESIS
                            | Postfix_Expression
                              LEFT_PARENTHESIS
                              Argument_Expression_List
                              RIGHT_PARENTHESIS
                            | Postfix_Expression
                              LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            | Postfix_Expression
                              DOT
                              IDENTIFIER
                            | Postfix_Expression
                              MEMBER_OF_STRUCT
                              IDENTIFIER
                            | Postfix_Expression
                              INCREMENT
                            | Postfix_Expression
                              DECREMENT
                            ;

Primary_Expression         :  IDENTIFIER
                            | Constant
                            | STRING_LITERAL
                            | LEFT_PARENTHESIS
                              Expression
                              RIGHT_PARENTHESIS
                            | LEFT_PARENTHESIS
                              error
                              RIGHT_PARENTHESIS
                            ;

Argument_Expression_List   :  Assignment_Expression
                            | Argument_Expression_List
                              COMMA
                              Assignment_Expression
                            ;

Constant                   :  INTEGER_CONSTANT
                            | CHARACTER_CONSTANT
                            | FLOATING_CONSTANT
                            | ENUMERATION_CONSTANT
                            ;


%%
