/*	This is the source code for the /etc/trace command as
described in trace(8)	*/

#include	<stdio.h>
#include	<sys/time.h>
#include	<sys/file.h>
#include 	<errno.h>
#include	<sys/systrace.h>

main(argc, argv)

int argc;
char *argv[];

{
	int flag, status, c, interval;
	long pid, getpid();

	if (argc < 2) {
		fprintf( stderr, "%s requires at least one argument\n"
			, argv[0] );
		exit(1);
	}

	if (argv[1][0] == '-')
		c = argv[1][1];
	else {
		pid = getpid();
		status = systrace( ALL, (int) pid, 0);
		if (status) {
			fprintf( stderr, "systrace call unsuccessful\n");
			exit(-1);
		}
		status = execvp( argv[1], &argv[1] );
		perror("exec error :");
		exit(1);
	}

	switch (c) {

case 'f':
		if (argc >= 3) {
			if (argc == 3)
				interval = 0;
			else
				interval = atoi( &argv[3][0] );
			openlog( argv[2], interval );
		}
		else {
			fprintf( stderr, "Closing log file.\n" );
			status = systrace( FILESPEC, 0, NULL );
		}
		break;
case 'a':
case 'p':
case 'c':
case 'o':
		pid = atoi( &argv[2][0] );
		if (c == 'a')
			flag = ALL;
		else if (c == 'p')
			flag = PIDONLY;
		else if (c == 'c')
			flag = CHILDONLY;
		else flag = TRACEOFF;

		switch (flag) {
	case ALL:	fprintf( stderr, "Enabling trace on process %d");
	 		fprintf( stderr, " and all future children\n" );
			break;
	case PIDONLY:	fprintf( stderr, "Enabling trace on process %d only\n"
				, pid );
			break;
	case CHILDONLY:	fprintf( stderr, "Enabling trace on future children ");
			fprintf( stderr, "of process %d\n", pid );
			break;
	case TRACEOFF:	fprintf( stderr, "Disabling trace on process %d"
				, pid );
			fprintf( stderr, " and all future children\n" );
			break;
	default:	fprintf( stderr, "INTERNAL error in %s\n", argv[0] );
			exit( -1 );
		}

		status = systrace( flag, pid, 0);
		break;
default:
		fprintf(stderr, "%s : invalid option\n",argv[1]);
			exit(-1);
	}

	if (status) {
		fprintf( stderr, "systrace call unsuccessful\n");
		exit(-1);
	}
	exit(0);
}

openlog( filename, interval )

char	*filename;
int	interval;

{
	struct timeval tp;
	char *st;
	FILE *fp;
	int nbytes, status;

	fprintf( stderr, "Opening log file ");
	if (interval) {
		fprintf( stderr, "with minimum elapsed time entries ");
		fprintf( stderr, "every %d seconds\n", interval );
	} else
		fprintf( stderr, "with elapsed time entries disabled\n" );

	fp = fopen( filename, "w" );
	if (fp == NULL) {
		perror( filename );
		exit(-1);
	}

	gettimeofday( &tp, NULL );

	st = ctime( &tp.tv_sec );
	st[24] = '\0';
	fprintf( fp, "> > >---------- Log opened on %s ----------< < <", st);
	fclose( fp );

	status = systrace( FILESPEC, interval, filename );
	if (status) {
		fprintf( stderr, "systrace error opening log file\n" );
		exit(-1);
	}
}
