#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/inode.h"
#include "../h/fs.h"
#include "../h/kernel.h"
#include "../h/acct.h"
#include "../h/nami.h"
#include "../h/uio.h"
#include "../h/proc.h"
#include "../h/systrace.h"
#include "../sys/syscalls.c"	/* table of printable system call names */

struct	sysent sysent[];	/* contains argument counts for each call */
int	nsysent;		/* number of system calls defined */	


struct	inode *tracep = NULL;
struct	inode *savtracep = NULL;
int	tracesuspend = 2;	/* % free space where tracing is suspended */
int	traceresume = 4;	/* % free space where tracing is resumed */

#define	BUFSIZE	132
#define	TMPSIZE	55

struct {
	char line[BUFSIZE];	/* buffer for current log entry */
	int length,		/* current length of line in characters */
	locked,			/* lock flag to prevent buffer overwrite */
	wanted;			/* flag used to indicate desire to lock */
	unsigned long bot,	/* time when log file was opened */
	mytime,			/* when last elapsed time entry was written */
	delta;			/* timespan between generation of elapsed */
				/* time entries in the trace log.	*/
	} tbuf = { "\n", 0, 0, 0, };

systrace()

{
    register struct inode  *ip;
	struct proc	*pfind(), *procptr;
    register struct a {
	int	function;
	int	pid;
	char   *fname;
    }  *uap = (struct a    *) u.u_ap;

    if (suser ()) 
	switch (uap->function) {
	case FILESPEC:
		if (savtracep) {
		    tracep = savtracep;
		    savtracep = NULL;
		}
		if (uap -> fname == NULL) {
		    if (ip = tracep) {
			tlock();
			tbuf.length = 1;
			strapp("> > >------------------ Log closed at " );
			dumptime( time.tv_sec - tbuf.bot );
			strapp(" ------------------< < <\n" );
			logentry();
			irele (ip);
			tracep = NULL;
			tunlock();
		    }
		    return;
		}
		u.u_dirp = (caddr_t) uap->fname;
		ip = namei (uchar, LOOKUP, 1);
		if (ip == NULL)
		    return;
		if ((ip -> i_mode & IFMT) != IFREG) {
		    u.u_error = EACCES;
		    iput (ip);
		    return;
		}
		if (tracep && (tracep -> i_number != ip -> i_number ||
			    tracep -> i_dev != ip -> i_dev))
		    irele (tracep);
		tracep = ip;
		iunlock (ip);
		tbuf.mytime = time.tv_sec;  tbuf.bot = time.tv_sec;
		if (uap->pid < 0)
			tbuf.delta = 0L;
		else
			tbuf.delta = (unsigned long) uap->pid;
		break;
	case ALL:
	case PIDONLY:
	case CHILDONLY:
		if (tracep == NULL && savtracep == NULL) {
			u.u_error = ENOENT;
			return;
		}
		procptr = pfind( uap->pid );
		if (procptr == 0) {
			u.u_error = ESRCH;
			return;
		}
		if (uap->function == ALL || uap->function == PIDONLY)
			procptr->p_flag | = SYSTRACE;
		if (uap->function == ALL || uap->function == CHILDONLY)
			procptr->p_flag | = CHILDTRACE;
		break;
	case TRACEOFF:
		procptr = pfind( uap->pid );
		if (procptr == 0) {
			u.u_error = ESRCH;
			return;
		}
		procptr->p_flag & = ~( SYSTRACE | CHILDTRACE );
		break;
	default:
		u.u_error = EINVAL;
	}
}

tlock()

{
	while (tbuf.locked) {
		tbuf.wanted = 1;
		sleep ((caddr_t) &tbuf, PLOCK);
	}
	tbuf.locked = 1;
}

tunlock()

{
	tbuf.locked = 0;
	if (tbuf.wanted) {
		tbuf.wanted = 0;
		wakeup( (caddr_t) &tbuf);
	}
}

entrytrace( code, nargs )

unsigned code, nargs;

{
	register int i;
	char *cp;

	tlock();
	timelog();
	tbuf.length = 1;
	decout( u.u_procp->p_pid);
	strapp( "  Call ");

	if (code >= nsysent) {
			strapp( "Undefined ");
			decout( code );
			}
	else
		strapp( syscallnames[code] );

	cp = " ( ";
	for (i= 0; i < nargs; i++) {
		strapp( cp );
		dumparg( code, i );
		cp = ", ";
	}
	if (i)
		strapp( " )" );
	logentry();
	tunlock();
}

dumparg( code, argno )

unsigned code, argno;

/*	In special cases dump out the character string passed to
the system call, otherwise use the heuristic routine dumparg. */

{
	switch (code) {

case 33:	/* access */
case 51:	/* acct */
case 12:	/* chdir */
case 15:	/* chmod */
case 16:	/* chown */
case 61:	/* chroot */
case 8:		/* creat */
case 59:	/* execve */
case 40:	/* lstat */
case 136:	/* mkdir */
case 14:	/* mknod */
case 5:		/* open */
case 58:	/* readlink */
case 137:	/* rmdir */
case 18:	/* stat */
case 85:	/* swapon */
case 129:	/* truncate */
case 22:	/* umount */
case 10:	/* unlink */
case 138:	/* utimes */
		if (argno == 0) {
			strout( argno, 0 );
			return;
		}
		break;
case 9:		/* link */
case 21:	/* mount */
case 128:	/* rename */
case 148:	/* setquota */
case 57:	/* symlink */
		if (argno < 2) {
			strout( argno, 0 );
			return;
		}
		break;
case 101:	/* send */
case 133:	/* sendto */
case 4:		/* write */
		if (argno == 1 ) {
			strout( argno, u.u_arg[2] );
			return;
		}
		break;
case 54:	/* ioctl, output second argument in hex only */
		if (argno == 1 ) {
			hexout( u.u_arg[argno] );
			return;
		}
		break;
	}
	/* otherwise use rules of thumb to format the argument */
	numout( u.u_arg[argno] );
}

exittrace(code, nargs)

/*	On exit output the arguments based on the system call or the
value of u.u_error if nonzero */

unsigned code, nargs;

{
	if (code == 59 && u.u_error == 0) 
		return;		/* don't log successful execve */
	tlock();
	timelog();
	tbuf.length = 1;
	decout( u.u_procp->p_pid);
	if (code >= nsysent) {
		strapp("  Undefined ");
		decout( code );
		}
	else {
		strapp( "  ");
		strapp( syscallnames[code] );
	}
	strapp( " returns ");

	if (u.u_error) {
		strapp( "Error ");
		decout( u.u_error );
		}
	else 
		switch (code) {
	case 87:	/* gethostname */
			if (u.u_arg[1] > 0)
				strout( 0, 0 );
			break;
	case 3:		/* read */
	case 58:	/* readlink */
	case 102:	/* recv */
	case 125:	/* recvfrom */
			if (u.u_r.r_val1 > 0) {
				decout( u.u_r.r_val1 );
				strapp( " byte(s) : ");
				strout( 1, u.u_r.r_val1 );
			} else
				numout( u.u_r.r_val1 );
			break;
	default:
			numout( u.u_r.r_val1 );
			}
	logentry();
	tunlock();
}

timelog()

/*	Write a record containing the elapsed time since the log file
was opened.  An entry is written if more than tbuf.delta seconds
have passed since the writing of the last elapsed time record.
If tbuf.delta is zero then no elapsed time entries are written. */

{
	if (! tbuf.delta)
		return;
	if (time.tv_sec - tbuf.mytime >= tbuf.delta) { 
		tbuf.mytime = time.tv_sec;
		tbuf.length = 1;
		strapp( "> > >------------------------- ");
		dumptime( tbuf.mytime - tbuf.bot );
		strapp( " -------------------------< < <");
		logentry();
	}
}

dumptime( tmp )

/*	Output the time as an ascii string hh:mm:ss */

unsigned long tmp;

{
	if (tmp / 3600 < 10) 
		strapp( "0" );
	decout( tmp / 3600 );
	tmp % = 3600;
	strapp( ":" );
	if (tmp / 60 < 10)
		strapp( "0" );
	decout( tmp / 60 );
	strapp( ":" );
	if (tmp % 60 < 10)
		strapp( "0" );
	decout( tmp % 60 );
}

logentry()

{
	register int i,error, usave;
	register struct inode *ip;
	register struct fs *fs;
	off_t siz;
	register char *ap = tbuf.line;

	if (savtracep) {
		fs = savtracep->i_fs;
		if (freespace(fs, fs->fs_minfree + traceresume) > 0) {
			tracep = savtracep;
			savtracep = NULL;
			printf("Tracing resumed\n");
		}
	}
	if ((ip = tracep) == NULL)
		return;
	fs = tracep->i_fs;
	if (freespace(fs, fs->fs_minfree + tracesuspend) <= 0) {
		savtracep = tracep;
		tracep = NULL;
		printf("Tracing suspended\n");
		return;
	}
	ilock(ip);
	siz = ip->i_size;
	usave = u.u_error;	/* save user status */
	u.u_error = 0;		/* zero u.u_error to fake out rdwri */
	error =
	    rdwri(UIO_WRITE, ip, (caddr_t)ap, strlen(tbuf.line), siz,
		1, (int *)0);
	u.u_error = usave;	/* resture user status */
	if (error)
		itrunc(ip, (u_long)siz);
	iunlock(ip);
}

strout( argno, maxlen )

/*	Copy a string into the trace buffer.  The address of the first
byte is taken from u.u_arg[argno].
	If the maximum length is given as zero then copying will
terminate when a \0 is reached.  
	If the maximum length is given as nonvero then the number
of bytes copied will be the minimum of maxlen and TMPSIZE - 1.
	In all cases, copying will stop if a memory fault is
encountered.							*/

unsigned argno;
int	maxlen;

{
	caddr_t ptr;
	int s,c;
	char tmp[TMPSIZE], *tptr = tmp;

	ptr = (caddr_t)u.u_arg[argno];

	if (maxlen == 0 || maxlen > TMPSIZE - 1)
		s = TMPSIZE - 1;
	else
		s = maxlen;

	do {
		c = fubyte( ptr++ );
		if (c == 0 && maxlen == 0 || c == -1) break;

		/* change newlines and tabs to blanks, all other ctrl to ? */

		if (c == '\t') c = ' ';
		if (c == '\n') c = ' ';
		if (c < ' ' || c > 127) c = '?';

		*tptr++ = c;
		s--;
	} while ( s > 0 );
	*tptr = '\0';
	strapp( "\"" );
	strapp( tmp );
	strapp( "\"" );
}

numout( num )

/*	append the number num to the input string.  Conditionally output
decimal, hex or both representations based on the value of num.
	-1..DECLIMIT				-> decimal only
	DECLIMIT..BOTHLIMIT OR < -1		-> decimal and hex
	> BOTHLIMIT				-> hex only
*/

int	num;

#define	DECLIMIT	100
#define	BOTHLIMIT	50000
{
	int n;

	n = num;
	if (n < 0)
		n = -n;
	if (n <= BOTHLIMIT || num < -1)
		decout( num );
	if (n > DECLIMIT && n <= BOTHLIMIT || num < -1)
		strapp( "/ ");
	if (n > DECLIMIT || num < -1)
		hexout( num );
}

hexout( n )

unsigned n;

{
	int d;
	char tmp[20], *tptr = tmp;

	strapp( "Ox", 0);
	do {
		d = n & 15;
		*tptr++ = d + (d<10 ? '0' : 'a' - 10);
		n = n >> 4;
	} while (n != 0);
	*tptr = '\0';
	reverse( tmp );
	strapp( tmp );
}

decout( n )

int n;

{
	int d;
	char tmp[20], *tptr;

	if (n<0) {
		n = -n;
		strapp( "-" );
		};
	if (n == 0) {
		strapp( "0" );
		return;
	}
	for (tptr = tmp; n != 0; n = n / 10) {
		d = n % 10;
		*tptr++ = d + '0';
	}
	*tptr = '\0';
	reverse( tmp );
	strapp( tmp );
}

reverse( str )

char str[];

{
	int c, i, j;

	for (i = 0, j = strlen( str ) - 1; i < j; i++, j-- ) {
		c = str[i];
		str[i] = str[j];
		str[j] = c;
	}
}

strapp( str )

/*	append str to the trace buffer, stop when the trace buffer is full
or the end of str is reached. */

char	*str;

{
	int i = 0;

	while ( str[i] && tbuf.length < BUFSIZE )
		tbuf.line [tbuf.length++] = str[i++];
	tbuf.line [tbuf.length] = '\0';
}
