
/*
   Written by Jon Zeeff umix!b-tech!zeeff

   This "device driver" uses the kernel delay() call to allow calls
   to nap() from user processes.  Nap() is like sleep, but with finer
   resolution.
 
   Compile with cc -O  -c ft.c 

   Written for a Sys V.3 system, but should work on others.

   For Sys V.3:
   
   Make a new kernel according to the instructions and then:
   mknod /dev/ft c 28 0 

   modules/ft/config:
       character(28)
       prefix = ft 
       functions = open, close, read
   
   Edit systems/system.std and add ft.
   Copy ft.o to modules/ft/config

*/

#include <sys/signal.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/buf.h>
#include <sys/iobuf.h>
#include <sys/conf.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/utsname.h>
#include <sys/elog.h>
#include <sys/errno.h>
#include <sys/trap.h>
#include <sys/seg.h>
#include <sys/map.h>

/* use a raw device interface */

ftopen() {}

ftread(dev)
int dev;
{
delay(u.u_count);
u.u_count = 0;
}

ftwrite() {}
ftclose() {}

