/* pty.h - Eric H. Herrin II (eric@ms.uky.edu)
 * 
 * some elementary definitions for the pty driver (UnixPC version)
 *
 * Version 2.1
 */

int ptsproc();

#define True  (1 == 1)
#define False (0 == 1)

/*  This is the total number of ptys.  Note the maximum number here is
 *  currently 64 for the UnixPC (128 minor devices/2 minor devices per pty
 *  yields 64 total ptys).  I really don't see the need for more than 32
 *  on the 3B1, however, if someone does, then (s)he can change it.
 */
#include "number-ptys.h"
#define PTYCNT (dev_t)NUMBER_OF_PTYS

/* some definitions to include kernel info from system header files.
 */
#define KERNEL 1
#define defined_io 1
#define NOSTREAMS 1

#define UNIXPC 1

/* This macro returns True if the parameter is a master minor device number,
 * False otherwise.
 */
#define Master( dev )	(minor(dev) >= PTYCNT)
