#! /bin/sh

echo "Checking configuration and building 'nlist'"

CFLAGS="-O"
if [ -f /unix ]; then
	echo "This looks like a System 5 system"
	CFLAGS="${CFLAGS} -DSYSV"
	NAMELIST=/unix
	getmain() grep -c '_main[ 	]'
elif [ -f /vmunix ]; then
	echo "This looks like a BSD system"
	NAMELIST=/vmunix
	getmain() grep -c '_main$'
else
	echo "No /unix and no /vmunix. What system are you?" >&2
	exit 1
fi

if [ `nm ${NAMELIST} | getmain` -gt 0 ]; then
	CFLAGS="${CFLAGS} -DUNDERSCORESYM"
	MSG=prepends
else
	MSG="doesn't prepend"
fi

echo "It looks like the loader ${MSG} an underscore to symbol names"
echo "If this is not right, 'nlist' may fail. Build it manually"

echo ""
echo "Making 'nlist'"

make nlist CFLAGS="${CFLAGS}"
