/* lddefs.h, lzh, 09/30/85 */

/*
 * Structures and definitions for the loadable device driver
 */

#define LD_MAGIC 	96401815	/* Magic number */
#define LD_SIZE 	65536		/* Size of text and data of driver */
#define LD_ADDR0 	0xe4000		/* Location of first device */
#define LD_ADDR1	0x0		/* Location of second device */
#define LD_DEV_SIZE	16		/* Size of device */
#define LD_PROBE_OFFSET 0xe		/* Offset from start of dev to probe */

/* Define LD_IO if device is in I/O space */
/*#define LD_IO		0*/

/* Define DEMO if device isn't to be probed */
#define DEMO            0

struct ld_dev
{
	int	(*ld_open)();
	int	(*ld_close)();
	int	(*ld_read)();
	int	(*ld_write)();
	int	(*ld_ioctl)();
	int	(*ld_mmap)();
	int	(*ld_intr)();
};
