/*
 * The mrouted program is covered by the license in the accompanying file
 * named "LICENSE".  Use of the mrouted program represents acceptance of
 * the terms and conditions listed in that file.
 *
 * The mrouted program is COPYRIGHT 1989 by The Board of Trustees of
 * Leland Stanford Junior University.
 *
 *
 * $Revision: 1.2 $
 */

/*
 * A DVMRP message consists of an IP header + an IGMP header + (for reports
 * only) zero or more bytes of route information.  The route information
 * consists of one or more lists of the following form:
 *
 *		(mask, (origin, metric), (origin, metric), ...)
 *
 * where:
 *
 *	"mask" is the subnet mask for all the origins in the list.
 *		It is always THREE bytes long, containing the low-order
 *		three bytes of the mask (the high-order byte is always
 *		0xff and therefore need not be transmitted).
 *
 *	"origin" is the number of a subnet from which multicast datagrams
 *		may originate.  It is from one to four bytes long,
 *		depending on the value of "mask":
 *			if all bytes of the mask are zero
 *			    the subnet number is one byte long
 *			else if the low-order two bytes of the mask are zero
 *			    the subnet number is two bytes long
 *			else if the lowest-order byte of the mask is zero
 *			    the subnet number is three bytes long,
 *			else
 *			    the subnet number is four bytes long.
 *
 *	"metric" is a one-byte value consisting of two subfields:
 *		- the high-order bit is a flag which, when set, indicates
 *		  the last (origin, metric) pair of a list.
 *		- the low-order seven bits contain the routing metric for
 *		  the corresponding origin, relative to the sender of the
 *		  DVMRP report.  The metric may have the value of UNREACHABLE
 *		  added to it as a "split horizon" indication (so called
 *		  "poisoned reverse").
 *
 * Within a list, the origin subnet numbers must be in ascending order, and
 * the lists themselves are in order of increasing mask value.  A message may
 * not exceed 576 bytes, the default maximum IP reassembly size, including
 * the IP and IGMP headers; the route information may be split across more
 * than one message if necessary, by terminating a list in one message and
 * starting a new list in the next message (repeating the same mask value,
 * if necessary).
 */

/*
 * DVMRP message types (carried in the "code" field of an IGMP header)
 */
#define DVMRP_PROBE	1	/* for finding neighbors             */
#define DVMRP_REPORT	2	/* for reporting some or all routes  */

/*
 * Limit on length of route data
 */
#define MAX_IP_PACKET_LEN	576
#define MIN_IP_HEADER_LEN	20
#define MAX_IP_HEADER_LEN	60
#define MAX_DVMRP_DATA_LEN \
		( MAX_IP_PACKET_LEN - MAX_IP_HEADER_LEN - IGMP_MINLEN )

/*
 * Various protocol constants (all times in seconds)
 */
				        /* address for multicast DVMRP msgs */
#define INADDR_DVMRP_GROUP	(u_long)0xe0000004    /* 224.0.0.4 */

#define ROUTE_MAX_REPORT_DELAY	5	/* max delay for reporting changes  */
					/*  (This is the timer interrupt    */
					/*  interval; all times must be     */
					/*  multiples of this value.)       */

#define	ROUTE_REPORT_INTERVAL	60	/* periodic route report interval   */
#define ROUTE_SWITCH_TIME	140	/* time to switch to equivalent gw  */
#define	ROUTE_EXPIRE_TIME	200	/* time to mark route invalid       */
#define	ROUTE_DISCARD_TIME	340	/* time to garbage collect route    */

#define LEAF_CONFIRMATION_TIME	200	/* time to consider subnet a leaf   */

#define NEIGHBOR_PROBE_INTERVAL	190	/* periodic neighbor probe interval */
#define NEIGHBOR_EXPIRE_TIME	140	/* time to consider neighbor gone   */

#define GROUP_QUERY_INTERVAL	125	/* periodic group query interval    */
#define GROUP_EXPIRE_TIME	270	/* time to consider group gone      */

#define UNREACHABLE		32	/* "infinity" metric, must be <= 64 */
#define DEFAULT_METRIC		1	/* default subnet/tunnel metric     */
#define DEFAULT_THRESHOLD	1	/* default subnet/tunnel threshold  */
