RCS file: RCS/dz.c,v
retrieving revision 1.1.1.3
retrieving revision 1.4
diff -c2 -r1.1.1.3 -r1.4
*** /tmp/,RCSt1000449	Mon Dec  2 23:49:49 1985
--- /tmp/,RCSt2000449	Mon Dec  2 23:49:52 1985
***************
*** 52,56 ****
  
  int	dzstart(), dzxint(), dzdma();
! int	ttrstrt();
  struct	tty dz_tty[NDZLINE];
  int	dz_cnt = { NDZLINE };
--- 52,56 ----
  
  int	dzstart(), dzxint(), dzdma();
! int	ttrstrt(), wakeup();
  struct	tty dz_tty[NDZLINE];
  int	dz_cnt = { NDZLINE };
***************
*** 70,74 ****
  char	dz_brk[NDZ];
  char	dzsoftCAR[NDZ];
! char	dz_lnen[NDZ];	/* saved line enable bits for DZ32 */
  
  /*
--- 70,76 ----
  char	dz_brk[NDZ];
  char	dzsoftCAR[NDZ];
! char	dz_inout[NDZ];		/* outgoing mode flags */
! char	dz_flags[NDZ];		/* permanent copy of flags */
! char	dz_lnen[NDZ];		/* saved line enable bits for DZ32 */
  
  /*
***************
*** 130,134 ****
  		pdp++, tp++;
  	}
! 	dzsoftCAR[ui->ui_unit] = ui->ui_flags;
  	if (dz_timer == 0) {
  		dz_timer++;
--- 132,136 ----
  		pdp++, tp++;
  	}
! 	dzsoftCAR[ui->ui_unit] = dz_flags[ui->ui_unit] = ui->ui_flags;
  	if (dz_timer == 0) {
  		dz_timer++;
***************
*** 138,142 ****
  }
  
- /*ARGSUSED*/
  dzopen(dev, flag)
  	dev_t dev;
--- 140,143 ----
***************
*** 144,147 ****
--- 145,149 ----
  	register struct tty *tp;
  	register int unit;
+ 	register int dz, bit;
   
  	unit = minor(dev);
***************
*** 157,165 ****
  		/* tp->t_state |= TS_HUPCLS; */
  		dzparam(unit);
! 	} else if (tp->t_state&TS_XCLUDE && u.u_uid != 0)
  		return (EBUSY);
  	(void) dzmctl(dev, DZ_ON, DMSET);
  	(void) spl5();
! 	while ((tp->t_state & TS_CARR_ON) == 0) {
  		tp->t_state |= TS_WOPEN;
  		sleep((caddr_t)&tp->t_rawq, TTIPRI);
--- 159,175 ----
  		/* tp->t_state |= TS_HUPCLS; */
  		dzparam(unit);
! 	} else if ((tp->t_state&TS_XCLUDE || flag < 0) && u.u_uid != 0)
  		return (EBUSY);
  	(void) dzmctl(dev, DZ_ON, DMSET);
  	(void) spl5();
! 	dz = unit >> 3;
! 	bit = 1 << (unit & 7);
! 	if (flag < 0) {
! 		dz_inout[dz] |= bit;
! 		dzsoftCAR[dz] |= bit;
! 	}
! 	while ((tp->t_state & TS_CARR_ON) == 0 ||
! 	    dz_inout[dz] & bit && flag >= 0) {
! 		(void) dzmctl(dev, DZ_ON, DMSET);
  		tp->t_state |= TS_WOPEN;
  		sleep((caddr_t)&tp->t_rawq, TTIPRI);
***************
*** 168,173 ****
  	return ((*linesw[tp->t_line].l_open)(dev, tp));
  }
!  
  /*ARGSUSED*/
  dzclose(dev, flag)
  	dev_t dev;
--- 178,190 ----
  	return ((*linesw[tp->t_line].l_open)(dev, tp));
  }
! 
  /*ARGSUSED*/
+ dzoopen(dev, flag)
+ 	dev_t dev;
+ {
+ 
+ 	return (dzopen(dev, -1));
+ }
+ 
  dzclose(dev, flag)
  	dev_t dev;
***************
*** 187,195 ****
  	else
  		dzaddr->dzbrk = (dz_brk[dz] &= ~(1 << (unit&07)));
! 	if ((tp->t_state&(TS_HUPCLS|TS_WOPEN)) || (tp->t_state&TS_ISOPEN) == 0)
  		(void) dzmctl(dev, DZ_OFF, DMSET);
  	ttyclose(tp);
  }
   
  dzread(dev, uio)
  	dev_t dev;
--- 204,233 ----
  	else
  		dzaddr->dzbrk = (dz_brk[dz] &= ~(1 << (unit&07)));
! 	if (tp->t_state&TS_HUPCLS || (tp->t_state&TS_ISOPEN)==0 || flag < 0) {
  		(void) dzmctl(dev, DZ_OFF, DMSET);
+ 		timeout(wakeup, (caddr_t)&tp->t_state, hz);
+ 		sleep((caddr_t)&tp->t_state, TTOPRI);
+ 	}
  	ttyclose(tp);
+ 	if (flag < 0) {
+ 		register int bit = 1 << (unit & 7);
+ 
+ 		dz_inout[dz] &= ~bit;
+ 		if (dz_flags[dz] & bit)
+ 			dzsoftCAR[dz] |= bit;
+ 		else
+ 			dzsoftCAR[dz] &= ~bit;
+ 		wakeup((caddr_t)&tp->t_rawq);
+ 	}
  }
   
+ /*ARGSUSED*/
+ dzoclose(dev, flag)
+ 	dev_t dev;
+ {
+ 
+ 	dzclose(dev, -1);
+ }
+ 
  dzread(dev, uio)
  	dev_t dev;
***************
*** 575,581 ****
  	register struct tty *tp;
  	register car;
! 	int olddzsilos = dzsilos;
  	int dztimer();
!  
  	for (i = 0; i < dz_cnt ; i++) {
  		dzaddr = dzpdma[i].p_addr;
--- 613,619 ----
  	register struct tty *tp;
  	register car;
! 	int olddzsilos = dzsilos, realcar;
  	int dztimer();
! 
  	for (i = 0; i < dz_cnt ; i++) {
  		dzaddr = dzpdma[i].p_addr;
***************
*** 584,598 ****
  		tp = &dz_tty[i];
  		bit = 1<<(i&07);
! 		car = 0;
! 		if (dzsoftCAR[i>>3]&bit)
! 			car = 1;
! 		else if (dzaddr->dzcsr & DZ_32) {
  			dzaddr->dzlcs = i&07;
  			dzwait(dzaddr);
! 			car = dzaddr->dzlcs & DZ_CD;
  		} else
! 			car = dzaddr->dzmsr&bit;
  		if (car) {
  			/* carrier present */
  			if ((tp->t_state & TS_CARR_ON) == 0) {
  				wakeup((caddr_t)&tp->t_rawq);
--- 622,638 ----
  		tp = &dz_tty[i];
  		bit = 1<<(i&07);
! 		if (dzaddr->dzcsr & DZ_32) {
  			dzaddr->dzlcs = i&07;
  			dzwait(dzaddr);
! 			realcar = dzaddr->dzlcs & DZ_CD;
  		} else
! 			realcar = dzaddr->dzmsr&bit;
! 		car = 0;
! 		if (realcar || dzsoftCAR[i>>3] & bit)
! 			car++;
  		if (car) {
  			/* carrier present */
+ 			if (realcar && dz_inout[i>>3] & bit)
+ 				dzsoftCAR[i >> 3] &= ~bit;
  			if ((tp->t_state & TS_CARR_ON) == 0) {
  				wakeup((caddr_t)&tp->t_rawq);
***************
*** 599,604 ****
  				tp->t_state |= TS_CARR_ON;
  			}
  		} else {
! 			if ((tp->t_state&TS_CARR_ON) &&
  			    (tp->t_flags&NOHANG) == 0) {
  				/* carrier lost */
--- 639,651 ----
  				tp->t_state |= TS_CARR_ON;
  			}
+ 			else if (tp->t_state&TS_TTSTOP && tp->t_flags&MDMBUF) {
+ 				tp->t_state &= ~TS_TTSTOP;
+ 				ttstart(tp);
+ 			}
  		} else {
! 			if (tp->t_flags&MDMBUF) {
! 				tp->t_state |= TS_TTSTOP;
! 				dzstop(tp, 0);
! 			} else if ((tp->t_state&TS_CARR_ON) &&
  			    (tp->t_flags&NOHANG) == 0) {
  				/* carrier lost */
