#ifndef lint
static char rcsid[] = "$Header$";
#endif

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sgtty.h>
#ifdef lint
#include <sys/time.h>
#endif

/*
 * Usage: c -l link [ -s speed ] [ -p e|o|0|1|n ] [ -e escapechar ]
 *
 * Comm program.
 *
 * Compilation:
 % cc -O -R -o c c.c
 *
 * N.B.:  Should be setuid root, so that it can run at high priority
 * (helps avoid losing input at high baud rates).
 */

#ifndef lint
extern	int	errno;
extern	char	*optarg;
extern	int	optind;
#else
int	errno;
char	*optarg;
int	optind;
/* VARARGS3 ARGSUSED */
error(quit, e, fmt) int quit, e; char *fmt; { ; }
#endif

char	*_argv0;
char	*linkname;
int	linkfd;
int	speed;
int	escchar;
int	parbis;
int	parbic;
char	*partab;
char	ttybuf[BUFSIZ];
int	ttycount;
char	ttyobuf[BUFSIZ];
int	ttyocount;
char	linebuf[BUFSIZ];
int	linecount;
char	lineobuf[BUFSIZ];
int	lineocount;

/*
 * 4.3 and V8 style file descriptor mask macros
 * Should be in <sys/types.h> but aren't in 4.2.
 */
#ifndef FD_SET
typedef struct fd_set {
	int	fds_bits;
} fd_set;
#define	FD_SET(n, p)	((p)->fds_bits[0] |= (1 << (n)))
#define	FD_CLR(n, p)	((p)->fds_bits[0] &= ~(1 << (n)))
#define	FD_ISSET(n, p)	((p)->fds_bits[0] & (1 << (n)))
#define	FD_ZERO(p)	((p)->fds_bits = 0)
#endif

char	evenpar[128] = {
	0x00, 0x81, 0x82, 0x03, 0x84, 0x05, 0x06, 0x87,
	0x88, 0x09, 0x0a, 0x8b, 0x0c, 0x8d, 0x8e, 0x0f,
	0x90, 0x11, 0x12, 0x93, 0x14, 0x95, 0x96, 0x17,
	0x18, 0x99, 0x9a, 0x1b, 0x9c, 0x1d, 0x1e, 0x9f,
	0xa0, 0x21, 0x22, 0xa3, 0x24, 0xa5, 0xa6, 0x27,
	0x28, 0xa9, 0xaa, 0x2b, 0xac, 0x2d, 0x2e, 0xaf,
	0x30, 0xb1, 0xb2, 0x33, 0xb4, 0x35, 0x36, 0xb7,
	0xb8, 0x39, 0x3a, 0xbb, 0x3c, 0xbd, 0xbe, 0x3f,
	0xc0, 0x41, 0x42, 0xc3, 0x44, 0xc5, 0xc6, 0x47,
	0x48, 0xc9, 0xca, 0x4b, 0xcc, 0x4d, 0x4e, 0xcf,
	0x50, 0xd1, 0xd2, 0x53, 0xd4, 0x55, 0x56, 0xd7,
	0xd8, 0x59, 0x5a, 0xdb, 0x5c, 0xdd, 0xde, 0x5f,
	0x60, 0xe1, 0xe2, 0x63, 0xe4, 0x65, 0x66, 0xe7,
	0xe8, 0x69, 0x6a, 0xeb, 0x6c, 0xed, 0xee, 0x6f,
	0xf0, 0x71, 0x72, 0xf3, 0x74, 0xf5, 0xf6, 0x77,
	0x78, 0xf9, 0xfa, 0x7b, 0xfc, 0x7d, 0x7e, 0xff,
};
char	oddpar[128] = {
	0x80, 0x01, 0x02, 0x83, 0x04, 0x85, 0x86, 0x07,
	0x08, 0x89, 0x8a, 0x0b, 0x8c, 0x0d, 0x0e, 0x8f,
	0x10, 0x91, 0x92, 0x13, 0x94, 0x15, 0x16, 0x97,
	0x98, 0x19, 0x1a, 0x9b, 0x1c, 0x9d, 0x9e, 0x1f,
	0x20, 0xa1, 0xa2, 0x23, 0xa4, 0x25, 0x26, 0xa7,
	0xa8, 0x29, 0x2a, 0xab, 0x2c, 0xad, 0xae, 0x2f,
	0xb0, 0x31, 0x32, 0xb3, 0x34, 0xb5, 0xb6, 0x37,
	0x38, 0xb9, 0xba, 0x3b, 0xbc, 0x3d, 0x3e, 0xbf,
	0x40, 0xc1, 0xc2, 0x43, 0xc4, 0x45, 0x46, 0xc7,
	0xc8, 0x49, 0x4a, 0xcb, 0x4c, 0xcd, 0xce, 0x4f,
	0xd0, 0x51, 0x52, 0xd3, 0x54, 0xd5, 0xd6, 0x57,
	0x58, 0xd9, 0xda, 0x5b, 0xdc, 0x5d, 0x5e, 0xdf,
	0xe0, 0x61, 0x62, 0xe3, 0x64, 0xe5, 0xe6, 0x67,
	0x68, 0xe9, 0xea, 0x6b, 0xec, 0x6d, 0x6e, 0xef,
	0x70, 0xf1, 0xf2, 0x73, 0xf4, 0x75, 0x76, 0xf7,
	0xf8, 0x79, 0x7a, 0xfb, 0x7c, 0xfd, 0xfe, 0x7f,
};

struct	sgttyb sgbuf;

main(argc, argv)
	int argc;
	char **argv;
{
	register int fd, c, tx, lx;
	static int state;

	_argv0 = argv[0];

	speed = B1200;
	escchar = 27;
	argue(argc, argv, 1);

	(void) nice(-10);
	(void) setuid(getuid());

	fd = open(linkname, O_RDWR, 0);
	if (fd < 0)
		error(1, errno, "can't open %s", linkname);

	linkfd = fd;
	fixlink();
	rawtty();
	printf("open\r\n");
	lx = 0;
	tx = 0;

	for (;;) {
		if (lx >= linecount && tx >= ttycount) {
			fd_set inbits;

			if (ttyocount)
				flusho(ttyobuf, &ttyocount, 1);
			if (lineocount)
				flusho(lineobuf, &lineocount, fd);

			/* read from tty and/or line */
			FD_ZERO(&inbits);
			FD_SET(1, &inbits);
			FD_SET(fd, &inbits);
			c = select(fd + 1, &inbits, (fd_set *) 0, (fd_set *) 0,
				   (struct timeval *) 0);
			if (c == 0) {
				error(0, errno, "select");
				cleanup(1);
			}
			if (FD_ISSET(1, &inbits)) {
				ttycount = read(0, ttybuf, BUFSIZ);
				if (ttycount < 0) {
					error(0, errno, "read(0)");
					cleanup(1);
				}
				if (ttycount == 0) {
					error(0, 0, "eof(0)?");
					cleanup(1);
				}
				tx = 0;
			}
			if (FD_ISSET(fd, &inbits)) {
				linecount = read(fd, linebuf, BUFSIZ);
				if (linecount < 0) {
					error(0, errno, "read(%d)", fd);
					cleanup(1);
				}
				if (linecount == 0) {
					error(0, 0, "eof(%d)?", fd);
					cleanup(1);
				}
				lx = 0;
			}
		}
		/* handle tty input */
		while (tx < ttycount) {
			c = ttybuf[tx++] & 0x7f;
			if (state) {
				state = 0;
				if (c == escchar)
					goto put;
				switch (c) {
				case 'b':
					genbreak();
					break;

				case 'q':
					cleanup(0);
					/*NOTREACHED*/

				case 'z':
					printf("\r\nsuspend\r\n");
					susp();
					printf("resumed\r\n");
					break;

				case 'h':
				case 'H':
				case '?':
					printf("\r\n\
ESC subcommands:\r\n\
    b - generate a break\r\n\
    o - set options\r\n\
    q - quit\r\n\
    z - suspend\r\n");
					break;

				case 'o':
				case 'O':
					options();
					break;

				default:
beep:
					ttyobuf[ttyocount++] = 7;
					if (ttyocount == BUFSIZ)
						flusho(ttyobuf, &ttyocount, 1);
					break;
				}
			} else if (c == escchar) {
				state = 1;
				goto beep;
			} else {
put:
				if (partab)
					c = partab[c];
				else	/* restore parity */
					c = ttybuf[tx - 1];
				c |= parbis;
				c &= ~parbic;
				lineobuf[lineocount++] = c;
				if (lineocount == BUFSIZ)
					flusho(lineobuf, &lineocount, fd);
			}
		}
		/* handle line input */
		while (lx < linecount) {
			c = linebuf[lx++];
			/* handle parity here someday */
			ttyobuf[ttyocount++] = c & 0x7f;
			if (ttyocount == BUFSIZ)
				flusho(ttyobuf, &ttyocount, fd);
		}
	}
}

flusho(buf, p, fd)
	char *buf;
	register int *p;
	int fd;
{

	if (write(fd, buf, *p) != *p) {
		error(0, errno, "write(%d)", fd);
		cleanup(1);
	}
	*p = 0;
}

cleanup(code)
	int code;
{

	printf("\r\nclosed\r\n");
	(void) ioctl(0, TIOCSETP, &sgbuf);
	exit(code);
}

rawtty()
{
	struct sgttyb raw;

	if (ioctl(0, TIOCGETP, &sgbuf))
		error(1, errno, "ioctl TIOCGETP");
	raw = sgbuf;
	raw.sg_flags = RAW;
	(void) ioctl(0, TIOCSETP, &raw);
}

susp()
{

	(void) ioctl(0, TIOCSETP, &sgbuf);
	kill(0, SIGTSTP);
	rawtty();
}

struct speeds {
	int sp;
	int sp_b;
};

findspeed(sp)
{
	register struct speeds *spp;
	static struct speeds speeds[] = {
		300, B300, 600, B600, 1200, B1200, 2400, B2400,
		4800, B4800, 9600, B9600, -1, -1
	};

	spp = speeds;
	while (spp->sp >= 0) {
		if (spp->sp == sp)
			return (spp->sp_b);
		spp++;
	}
	return (-1);
}

genbreak()
{

	(void) ioctl(linkfd, TIOCSBRK, 0);
	sleep(1);
	(void) ioctl(linkfd, TIOCCBRK, 0);
}

char **
makeargv(avp, s)
	register char **avp, *s;
{

	for (;;) {
		while (*s == ' ' || *s == '\t' || *s == '\n')
			s++;
		if (*s == 0) {
			*avp = 0;
			return avp;
		}
		*avp++ = s;
		while (*s && *s != ' ' && *s != '\t' && *s != '\n')
			s++;
		if (*s == 0) {
			*avp = 0;
			return avp;
		}
		*s++ = 0;
	}
}

options()
{
	char buf[200];
	char *argv[100];
	int argc;

	(void) ioctl(0, TIOCSETP, &sgbuf);
	printf("options: ");
	if (fgets(buf, sizeof buf, stdin) == NULL)
		exit(1);
	argv[0] = _argv0;
	argc = makeargv(argv + 1, buf) - argv;
	argue(argc, argv, 0);
	rawtty();
}

argue(argc, argv, toplevel)
	int argc;
	char **argv;
	int toplevel;
{
	register int c;

	optind = 1;
	while ((c = getopt(argc, argv, "s:p:l:e:")) != EOF) {
		switch (c) {
		case '?':
usage:
			if (toplevel) {
				error(1, 0, "\
usage: c -l link [-s speed] [-p par] [-e esc]");
				/* NOTREACHED */
			}
			error(0, 0, "options: [-s speed] [-p par] [-e esc]");
			break;

		case 'l':
			if (!toplevel) {
				error(0, 0, "can't change link in midstream");
				break;
			}
			if (linkname)
				error(1, 0, "use only one -l option");
			linkname = optarg;
			break;

		case 's':
			if ((speed = findspeed(atoi(optarg))) < 0)
				error(toplevel, 0, "invalid speed %s", optarg);
			if (!toplevel)
				fixlink();
			break;

		case 'p':
			if (*optarg == 'e') {
				partab = evenpar;
				parbis = parbic = 0;
			} else if (*optarg == 'o') {
				partab = oddpar;
				parbis = parbic = 0;
			} else if (*optarg == '1') {
				parbis = 0x80;
				parbic = 0;
			} else if (*optarg == '0') {
				parbis = 0;
				parbic = 0x80;
			} else if (*optarg == 'n') {
				parbis = parbic = 0;
				partab = 0;
			} else
				error(toplevel, 0, "\
for -p, use one of [e, o, 1, 0, n]");
			break;

		case 'e':
			if (optarg[1] == 0)
				escchar = *optarg;
			else if (optarg[0] == '^')
				escchar = optarg[1] == '?' ? 0x7f :
					  *optarg & 0x1f;
			else
				escchar = atoi(optarg);
			printf("escape set to %s%c.\n",
			       escchar >= 0x20 && escchar < 0x7f ? "" : "^",
			escchar >= 0x20 ? (escchar == 0x7f ? '?' : escchar) :
			       escchar + '@');
			break;
		default:
			error(1, 0, "internal error: argue switch");
		}
	}
	if (linkname == 0)
		goto usage;
}

fixlink()
{
	struct sgttyb l;

	l.sg_ispeed = l.sg_ospeed = speed;
	l.sg_flags = RAW;
	(void) ioctl(linkfd, TIOCSETN, &l);
}

#ifndef lint
/*
 * Error routine from the local C library
 * N.B.: This code is system dependent.
 */

/*
 * error - University of Maryland specific (sigh)
 *
 * Useful for printing error messages.  Will print the program name
 * and (optionally) the system error associated with the values in
 * <errno.h>.
 *
 * Note that the type (and even the existence!) of ``arg'' is undefined.
 */
error(quit, e, fmt, arg)
	int quit;
	register int e;
	char *fmt;
{
	extern char *sys_errlist[];
	extern int sys_nerr;
	register char *p = _argv0;

	if (p != NULL)
		(void) fprintf(stderr, "%s: ", p);
	_doprnt(fmt, &arg, stderr);	/* magic */
	if (e > 0) {
		if (e < sys_nerr)
			(void) fprintf(stderr, ": %s", sys_errlist[e]);
		else
			(void) fprintf(stderr, ": unknown error number %d", e);
	}
	(void) putc('\n', stderr);
	(void) fflush(stderr);
	if (quit)
		exit(quit);
}
#endif
