RCS file: RCS/dh.c,v
retrieving revision 1.1.1.3
retrieving revision 1.4
diff -c2 -r1.1.1.3 -r1.4
*** /tmp/,RCSt1000424	Mon Dec  2 23:46:43 1985
--- /tmp/,RCSt2000424	Mon Dec  2 23:46:45 1985
***************
*** 70,73 ****
--- 70,74 ----
  short	dhsar[NDH];			/* software copy of last bar */
  short	dhsoftCAR[NDH];
+ short	dh_inout[NDH];
  
  struct	tty dh11[NDH*16];
***************
*** 80,84 ****
  int	dhlowrate = 75;			/* silo off if dhrate < dhlowrate */
  static short timerstarted;
! int	dhstart(), ttrstrt();
  
  /*
--- 81,85 ----
  int	dhlowrate = 75;			/* silo off if dhrate < dhlowrate */
  static short timerstarted;
! int	dhstart(), ttrstrt(), wakeup();
  
  /*
***************
*** 169,173 ****
   * the first use of it.  Also do a dmopen to wait for carrier.
   */
- /*ARGSUSED*/
  dhopen(dev, flag)
  	dev_t dev;
--- 170,173 ----
***************
*** 184,188 ****
  		return (ENXIO);
  	tp = &dh11[unit];
! 	if (tp->t_state&TS_XCLUDE && u.u_uid!=0)
  		return (EBUSY);
  	addr = (struct dhdevice *)ui->ui_addr;
--- 184,189 ----
  		return (ENXIO);
  	tp = &dh11[unit];
! 	if (u.u_uid != 0 && (tp->t_state&TS_XCLUDE ||
! 	    flag < 0 && tp->t_state&TS_ISOPEN))
  		return (EBUSY);
  	addr = (struct dhdevice *)ui->ui_addr;
***************
*** 231,235 ****
  	 * Wait for carrier, then process line discipline specific open.
  	 */
! 	dmopen(dev);
  	return ((*linesw[tp->t_line].l_open)(dev, tp));
  }
--- 232,236 ----
  	 * Wait for carrier, then process line discipline specific open.
  	 */
! 	dmopen(dev, flag);
  	return ((*linesw[tp->t_line].l_open)(dev, tp));
  }
***************
*** 236,242 ****
  
  /*
!  * Close a DH11 line, turning off the DM11.
   */
  /*ARGSUSED*/
  dhclose(dev, flag)
  	dev_t dev;
--- 237,254 ----
  
  /*
!  * Outgoing mode open: fake the carrier.
   */
  /*ARGSUSED*/
+ dhoopen(dev, flag)
+ 	dev_t dev;
+ 	int flag;
+ {
+ 
+ 	return (dhopen(dev, -1));
+ }
+ 
+ /*
+  * Close a DH11 line, turning off the DM11.
+  */
  dhclose(dev, flag)
  	dev_t dev;
***************
*** 250,258 ****
  	(*linesw[tp->t_line].l_close)(tp);
  	((struct dhdevice *)(tp->t_addr))->dhbreak &= ~(1<<(unit&017));
! 	if (tp->t_state&TS_HUPCLS || (tp->t_state&TS_ISOPEN)==0)
  		dmctl(unit, DML_OFF, DMSET);
  	ttyclose(tp);
  }
  
  dhread(dev, uio)
  	dev_t dev;
--- 262,290 ----
  	(*linesw[tp->t_line].l_close)(tp);
  	((struct dhdevice *)(tp->t_addr))->dhbreak &= ~(1<<(unit&017));
! 	if (tp->t_state&TS_HUPCLS || (tp->t_state&TS_ISOPEN)==0 || flag < 0) {
  		dmctl(unit, DML_OFF, DMSET);
+ 		/* hold DTR low long enough for it to be detected */
+ 		timeout(wakeup, (caddr_t)&tp->t_state, hz);
+ 		sleep((caddr_t)&tp->t_state, TTOPRI);
+ 	}
  	ttyclose(tp);
+ 	if (flag < 0) {		/* clear outgoing mode */
+ 		dh_inout[unit >> 4] &= ~(1 << (unit & 0xf));
+ 		wakeup((caddr_t)&tp->t_rawq);
+ 	}
  }
  
+ /*
+  * Close an outgoing DH line
+  */
+ /*ARGSUSED*/
+ dhoclose(dev, flag)
+ 	dev_t dev;
+ 	int flag;
+ {
+ 
+ 	dhclose(dev, -1);
+ }
+ 
  dhread(dev, uio)
  	dev_t dev;
***************
*** 403,406 ****
--- 435,439 ----
  		tp->t_state |= TS_HUPCLS;
  		dmctl(unit, DML_OFF, DMSET);
+ 		splx(s);
  		return;
  	}
***************
*** 671,676 ****
   * Turn on the line associated with dh dev.
   */
! dmopen(dev)
  	dev_t dev;
  {
  	register struct tty *tp;
--- 704,710 ----
   * Turn on the line associated with dh dev.
   */
! dmopen(dev, flag)
  	dev_t dev;
+ 	int flag;
  {
  	register struct tty *tp;
***************
*** 685,689 ****
  	tp = &dh11[unit];
  	unit &= 0xf;
! 	if (dm >= NDH || (ui = dminfo[dm]) == 0 || ui->ui_alive == 0) {
  		tp->t_state |= TS_CARR_ON;
  		return;
--- 719,724 ----
  	tp = &dh11[unit];
  	unit &= 0xf;
! 	if (dm >= NDH || (ui = dminfo[dm]) == 0 || ui->ui_alive == 0 ||
! 	    (dhsoftCAR[dm]&(1<<unit))) {
  		tp->t_state |= TS_CARR_ON;
  		return;
***************
*** 691,694 ****
--- 726,754 ----
  	addr = (struct dmdevice *)ui->ui_addr;
  	s = spl5();
+ 	if (flag < 0) {
+ 		dh_inout[dm] |= 1 << unit;
+ 		dmassert(addr, dm, unit, tp);
+ 		tp->t_state |= TS_CARR_ON;
+ 	}
+ 	else {
+ 		do {
+ 			dmassert(addr, dm, unit, tp);
+ 			if (tp->t_state&TS_CARR_ON &&
+ 			    (dh_inout[dm]&(1<<unit)) == 0)
+ 				break;
+ 			tp->t_state |= TS_WOPEN;
+ 			sleep((caddr_t)&tp->t_rawq, TTIPRI);
+ 		} while ((tp->t_state&TS_CARR_ON) == 0 ||
+ 		    (dh_inout[dm]&(1<<unit)));
+ 	}
+ 	splx(s);
+ }
+ 
+ dmassert(addr, dm, unit, tp)
+ 	register struct dmdevice *addr;
+ 	int dm, unit;
+ 	struct tty *tp;
+ {
+ 
  	addr->dmcsr &= ~DM_SE;
  	while (addr->dmcsr & DM_BUSY)
***************
*** 696,705 ****
  	addr->dmcsr = unit;
  	addr->dmlstat = DML_ON;
! 	if ((addr->dmlstat&DML_CAR) || (dhsoftCAR[dm]&(1<<unit)))
  		tp->t_state |= TS_CARR_ON;
  	addr->dmcsr = DM_IE|DM_SE;
- 	while ((tp->t_state&TS_CARR_ON)==0)
- 		sleep((caddr_t)&tp->t_rawq, TTIPRI);
- 	splx(s);
  }
  
--- 756,762 ----
  	addr->dmcsr = unit;
  	addr->dmlstat = DML_ON;
! 	if (addr->dmlstat & DML_CAR || dhsoftCAR[dm] & (1 << unit))
  		tp->t_state |= TS_CARR_ON;
  	addr->dmcsr = DM_IE|DM_SE;
  }
  
