#include <stdio.h>
#include <sys/param.h>
#include <sys/acl.h>
#include <grp.h>
#include <pwd.h>
#include "jjg.h"

#define ERR_FATAL 1	/* for the err() routine */
#define ERR_NONFATAL 0	/* for the err() routine */

/*
 * calling sequence: chacl [-u [user mode]] [-g [group mode]] -f [file]
 *
 * items enclosed in brackets may repeat.
 */
main(argc, argv, environ)
int argc;
char *argv[], *environ[];
{
	int i, j, na;
	struct acle acl[MAXACL];
	int is_u_type;
	int filec;
	int status;

	na = 0;

	for ( i = 1; i < argc; i++ ) {
		if ( equal(argv[i],"-u") || equal(argv[i],"-g") ) {
			is_u_type = equal( argv[i], "-u" );

		} else if ( equal(argv[i],"-f") ) {
			break;

		} else if ( *argv[i] == '-' ) {
			err( ERR_FATAL, "unrecognized option - %s", argv[i] );

		} else {
			struct passwd *up;
			struct group *gp;
			int valid_name;

			if ( is_u_type ) {
				up = getpwnam( argv[i] );
				valid_name = up != NULL;
			} else {
				gp = getgrnam( argv[i] );
				valid_name = gp != NULL;
			}

			if ( valid_name ) {
				i++;

				if ( i < argc ) {
					if ( is_u_type && up->pw_uid == 0 ) {
						err( ERR_NONFATAL, "warning: cannot deny access to user %s", "root" );
					} else {
						if ( sscanf( argv[i], "%d", &acl[na].a_mode ) == 1 &&
							acl[na].a_mode >= 0 && acl[na].a_mode <= 7 ) {
							if ( na < MAXACL ) {
								acl[na].a_type = is_u_type ? A_USER : A_GROUP;
								acl[na].a_id = is_u_type ? up->pw_uid : gp->gr_gid;
								na++;
							} else {
								err( ERR_NONFATAL, "warning: too many acl entries (must be no more than %d)", MAXACL );
							}

						} else {
							err( ERR_FATAL, "unrecognizable mode - %d (must be 0-7)", acl[na].a_mode );
						}
					}

				} else {
					err( ERR_FATAL, "expected mode after %sname", is_u_type ? "user" : "group" );
				}
			} else {
				err( ERR_FATAL, is_u_type ? "no such user - %s" : "no such group - %s", argv[i] );
			}
		}
	}

/*	
	printf( "number of acle = %d\n", na );
	printf( "file list begins at %d; argc = %d\n", i+1, argc );

	for ( i = 0; i < na; i++ ) {
		printf( "type = %s id = %d mode = %d\n", acl[i].a_type == A_GROUP ? "-g"
			: "-u", acl[i].a_id, acl[i].a_mode );
	}
*/

	status = 0;
	for ( filec = i+1; filec < argc; filec++ ) {
		if ( setacl( argv[filec], na, acl ) != 0 ) {
			perror( argv[filec] );
			status++;
		}
	}
	exit( status );
}

err( level, fmt, arg )
int level;
char *fmt, *arg;
{
	char buf[240];

	sprintf( buf, fmt, arg );
	fprintf( stderr, "chacl: %s\n", buf );

	if ( level == ERR_FATAL )
		exit( 1 );
}
