#define A_GROUP	1
#define A_USER	0

/*
 * macros to disassemble the packed acl in the inode
 */
#ifdef KERNEL
#define acle_type(ip,n)	( ( (ip)->i_acle[(n)/2] >> (((n)%2) ? 3 : 7) ) & 01 )
#define acle_id(ip,n)	(ip)->i_aclid[(n)]
#define acle_mode(ip,n)	( ( (ip)->i_acle[(n)/2] >> (((n)%2) ? 0 : 4) ) & 07 )
#define ok_acle(ip,n)	( ( acle_type((ip),(n)) != A_USER ) || ( acle_id((ip),(n)) != 0 ) )
#else
#define ok_uacle(a)	( ( (a).a_type != A_USER ) || ( (a).a_id != 0 ) )
#endif

struct acle {
	char a_type;	/* A_GROUP or A_USER */
	char a_mode;	/* 0 (no permission) through 7 (rwx) */
	int a_id;	/* gid or uid, depending */
};
